/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.FilteredContentProvider;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public abstract class Navigator
extends ViewPart
implements INavigator,
IPartListener,
ISelectionChangedListener,
KeyListener,
IMenuListener,
IOpenListener,
ISelectionListener {
    protected static final String SET_LINK_TO_EDITOR = "LINK_NAVIGATOR_TO_EDITOR";
    protected static final String TAG_SELECTION = "selection";
    protected static final String TAG_ELEMENT = "element";
    protected static final String TAG_STORE_VALUE = "storeValue";
    protected static final String TAG_FACTORY_ID = "factoryID";
    private static final String ID_POPUP_MENU = "#NavigatorPopupMenu";
    private StructuredViewer structuredViewer;
    private Object initialViewerInput;
    private IDialogSettings settings;
    private IMemento memento;
    private NavigatorActionGroup actionGroup;
    private boolean linkingEnabled;
    private static Navigator activeNavigator;
    private String navigatorID;
    static /* synthetic */ Class class$org$eclipse$ui$IPersistableElement;

    public Navigator(String string) {
        this.navigatorID = string;
    }

    public String getID() {
        return this.navigatorID;
    }

    public void dispose() {
        this.getViewer().removeOpenListener((IOpenListener)this);
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewSite().getPage().removePartListener((IPartListener)this);
        if (!this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().removeKeyListener((KeyListener)this);
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        this.initialViewerInput = null;
        this.structuredViewer = null;
        this.settings = null;
        this.actionGroup = null;
        super.dispose();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
        iViewSite.getPage().addPostSelectionListener((ISelectionListener)this);
        IDialogSettings iDialogSettings = this.getPlugin().getDialogSettings();
        this.settings = iDialogSettings.getSection(this.getStoreSection());
        if (this.settings == null) {
            this.settings = iDialogSettings.addNewSection(this.getStoreSection());
            this.initSettings();
        } else {
            this.loadSettings();
        }
    }

    protected void initSettings() {
    }

    public boolean isInitialized() {
        return this.getViewSite() != null;
    }

    protected IDialogSettings getSettings() {
        return this.settings;
    }

    protected void loadSettings() {
        this.setLinkingEnabled(this.getSettings().getBoolean(SET_LINK_TO_EDITOR));
    }

    public abstract String getStoreSection();

    protected NavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(NavigatorActionGroup navigatorActionGroup) {
        this.actionGroup = navigatorActionGroup;
    }

    protected abstract void createActions();

    public void createPartControl(Composite composite) {
        this.structuredViewer = this.createViewer(composite);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewer().addOpenListener((IOpenListener)this);
        this.getViewer().getControl().addKeyListener((KeyListener)this);
        this.initContextMenu();
        IContentProvider iContentProvider = this.getViewer().getContentProvider();
        this.getViewer().setContentProvider((IContentProvider)new FilteredContentProvider(iContentProvider, this.getID(), (Viewer)this.structuredViewer));
        this.getViewer().setInput(this.createViewerInput());
        this.initialViewerInput = this.getViewer().getInput();
        this.createActions();
        if (this.getActionGroup() != null) {
            this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        }
        this.updateActionBars(this.getStructuredSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getSite().getPage().addPartListener((IPartListener)this);
        String string = this.getHelpContextId();
        if (string != null) {
            WorkbenchHelp.setHelp((Control)this.getViewer().getControl(), (String)string);
        }
        if (this.memento != null) {
            this.loadMemento(this.memento);
            this.memento = null;
        }
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void loadMemento(IMemento iMemento) {
        this.loadSelection(iMemento);
    }

    protected void loadSelection(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild(TAG_SELECTION);
        if (iMemento2 == null) {
            return;
        }
        List list = this.loadElements(iMemento2);
        if (!list.isEmpty()) {
            this.selectReveal((ISelection)new StructuredSelection(list));
        }
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager(ID_POPUP_MENU);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
    }

    protected abstract Object createViewerInput();

    protected Object getInitialViewerInput() {
        return this.initialViewerInput;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    public StructuredViewer getViewer() {
        return this.structuredViewer;
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    public void selectReveal(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = this.convertToViewer(iSelection);
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        if (this.getViewer() == null || this.getViewer().getControl() == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (!UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)iStructuredSelection)) {
            this.getViewer().setSelection((ISelection)iStructuredSelection, true);
        }
    }

    protected IStructuredSelection convertFromViewer(ISelection iSelection) {
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection convertToViewer(ISelection iSelection) {
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.convertFromViewer(this.getViewer().getSelection());
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        this.linkingEnabled = bl;
        this.getSettings().put(SET_LINK_TO_EDITOR, bl);
        if (bl && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(iEditorPart);
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (this.isLinkingEnabled() && iWorkbenchPart instanceof IEditorPart) {
            this.editorActivated((IEditorPart)iWorkbenchPart);
        }
        if (iWorkbenchPart instanceof Navigator) {
            activeNavigator = (Navigator)iWorkbenchPart;
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof Navigator) {
            activeNavigator = (Navigator)iWorkbenchPart;
        }
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (activeNavigator == iWorkbenchPart) {
            activeNavigator = null;
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public boolean isActiveNavigator() {
        return activeNavigator == this;
    }

    protected abstract boolean editorActivated(IEditorPart var1);

    protected abstract void linkToEditor(IStructuredSelection var1);

    public void updateTitle() {
        String string = this.getConfigurationElement().getAttribute("name");
        this.setTitle(string);
        this.setTitleToolTip("");
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() == this.structuredViewer) {
            IStructuredSelection iStructuredSelection = this.convertFromViewer(selectionChangedEvent.getSelection());
            this.updateActionBars(iStructuredSelection);
            this.updateStatusLine(iStructuredSelection);
            if (!iStructuredSelection.isEmpty() && this.isLinkingEnabled()) {
                this.linkToEditor(iStructuredSelection);
            }
        }
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        NavigatorActionGroup navigatorActionGroup = this.getActionGroup();
        if (navigatorActionGroup != null) {
            navigatorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            navigatorActionGroup.updateActionBars();
        }
    }

    protected void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = this.getStatusLineMessage(iStructuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    protected String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        int n = iStructuredSelection.size();
        if (n > 1) {
            return HyadesUIPlugin.getString("STS_LNE_MULTI", Integer.toString(n));
        }
        return null;
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        this.saveSelection(iMemento);
    }

    protected void saveSelection(IMemento iMemento) {
        IStructuredSelection iStructuredSelection = this.convertFromViewer(this.getViewer().getSelection());
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        IMemento iMemento2 = iMemento.createChild(TAG_SELECTION);
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.saveElement(iMemento2, iterator.next());
        }
    }

    protected void saveElement(IMemento iMemento, Object object) {
        IPersistableElement iPersistableElement = null;
        iPersistableElement = object instanceof IPersistableElement ? (IPersistableElement)object : (object instanceof IAdaptable ? (IPersistableElement)((IAdaptable)object).getAdapter(class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = Navigator.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement) : (IPersistableElement)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = Navigator.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement));
        if (iPersistableElement == null) {
            return;
        }
        IMemento iMemento2 = iMemento.createChild(TAG_ELEMENT);
        iMemento2.putString(TAG_FACTORY_ID, iPersistableElement.getFactoryId());
        iPersistableElement.saveState(iMemento2);
    }

    protected List loadElements(IMemento iMemento) {
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>();
        IMemento[] iMementoArray = iMemento.getChildren(TAG_ELEMENT);
        int n = 0;
        int n2 = iMementoArray.length;
        while (n < n2) {
            IAdaptable iAdaptable;
            IElementFactory iElementFactory;
            String string = iMementoArray[n].getString(TAG_FACTORY_ID);
            if (string != null && (iElementFactory = CoreUtil.getElementFactory(string)) != null && (iAdaptable = iElementFactory.createElement(iMementoArray[n])) != null) {
                arrayList.add(iAdaptable);
            }
            ++n;
        }
        return arrayList;
    }

    public void keyPressed(KeyEvent keyEvent) {
        NavigatorActionGroup navigatorActionGroup;
        if (keyEvent.widget == this.getViewer().getControl() && (navigatorActionGroup = this.getActionGroup()) != null) {
            navigatorActionGroup.handleKeyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = this.convertFromViewer(this.getViewer().getSelection());
        NavigatorActionGroup navigatorActionGroup = this.getActionGroup();
        if (navigatorActionGroup != null) {
            navigatorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            navigatorActionGroup.fillContextMenu(iMenuManager);
        }
    }

    public void open(OpenEvent openEvent) {
        if (openEvent.getViewer() == this.getViewer()) {
            IStructuredSelection iStructuredSelection = this.convertFromViewer(openEvent.getSelection());
            NavigatorActionGroup navigatorActionGroup = this.getActionGroup();
            if (navigatorActionGroup != null) {
                this.getActionGroup().runDefaultAction(iStructuredSelection);
            }
        }
    }

    public void handleChange(int n) {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart == this) {
            return;
        }
        if (iWorkbenchPart instanceof IEditorPart && !this.isLinkingEnabled()) {
            return;
        }
        this.selectReveal(iSelection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

