/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public abstract class TreeNavigator
extends Navigator
implements ITreeNavigator,
IDoubleClickListener,
IPropertyChangeListener {
    protected static final String SET_WORKING_SET = "WORKING_SET";
    protected static final String TAG_FRAME = "FRAME";
    protected static final String TAG_EXPAND_STATE = "EXPAND_STATE";
    private FrameList frameList;
    private ResourceWorkingSetFilter workingSetFilter = this.createWorkingSetFilter();

    public TreeNavigator(String string) {
        super(string);
        this.getPlugin().getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.frameList = null;
        this.workingSetFilter = null;
        this.getViewer().removeDoubleClickListener((IDoubleClickListener)this);
        this.getPlugin().getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected ResourceWorkingSetFilter createWorkingSetFilter() {
        return new ResourceWorkingSetFilter();
    }

    protected ResourceWorkingSetFilter getWorkingSetFilter() {
        return this.workingSetFilter;
    }

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    protected void loadSettings() {
        super.loadSettings();
        this.initWorkingSet();
    }

    protected void initWorkingSet() {
        IWorkingSetManager iWorkingSetManager;
        IWorkingSet iWorkingSet;
        ResourceWorkingSetFilter resourceWorkingSetFilter = this.getWorkingSetFilter();
        if (resourceWorkingSetFilter == null) {
            return;
        }
        String string = this.getSettings().get(SET_WORKING_SET);
        if (string != null && !string.equals("") && (iWorkingSet = (iWorkingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager()).getWorkingSet(string)) != null) {
            resourceWorkingSetFilter.setWorkingSet(iWorkingSet);
        }
    }

    protected StructuredViewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 770);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        if (this.getWorkingSetFilter() != null) {
            treeViewer.addFilter((ViewerFilter)this.getWorkingSetFilter());
        }
        this.adjustTreeViewer(treeViewer);
        return treeViewer;
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent.getViewer() == this.getTreeViewer()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (this.getTreeViewer().isExpandable(object)) {
                this.getTreeViewer().setExpandedState(object, !this.getTreeViewer().getExpandedState(object));
            }
        }
    }

    protected void loadMemento(IMemento iMemento) {
        this.loadFrame(iMemento);
        super.loadMemento(iMemento);
        this.loadExpandState(iMemento);
    }

    public void saveState(IMemento iMemento) {
        this.saveFrame(iMemento);
        super.saveState(iMemento);
        this.saveExpandState(iMemento);
    }

    protected boolean loadFrame(IMemento iMemento) {
        FrameList frameList = this.getFrameList();
        if (frameList == null) {
            return false;
        }
        IMemento iMemento2 = iMemento.getChild(TAG_FRAME);
        if (iMemento2 == null) {
            return false;
        }
        TreeFrame treeFrame = new TreeFrame((AbstractTreeViewer)this.getTreeViewer());
        treeFrame.restoreState(iMemento2);
        if (treeFrame.getInput() == null) {
            return false;
        }
        this.getTreeViewer().getTree().deselectAll();
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection(treeFrame.getInput()));
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (!iStructuredSelection.isEmpty()) {
            treeFrame.setInput(iStructuredSelection.getFirstElement());
        }
        treeFrame.setName(this.getFrameName(treeFrame.getInput()));
        treeFrame.setToolTipText(this.getFrameToolTipText(treeFrame.getInput()));
        frameList.gotoFrame((Frame)treeFrame);
        return true;
    }

    protected void loadExpandState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild(TAG_EXPAND_STATE);
        if (iMemento2 == null) {
            return;
        }
        List list = this.loadElements(iMemento2);
        if (!list.isEmpty()) {
            ((TreeViewer)this.getViewer()).setExpandedElements(list.toArray());
        }
    }

    protected boolean saveFrame(IMemento iMemento) {
        FrameList frameList = this.getFrameList();
        if (frameList == null) {
            return false;
        }
        if (frameList.getCurrentIndex() == 0) {
            return false;
        }
        TreeFrame treeFrame = (TreeFrame)frameList.getCurrentFrame();
        IMemento iMemento2 = iMemento.createChild(TAG_FRAME);
        treeFrame.saveState(iMemento2);
        return true;
    }

    protected void saveExpandState(IMemento iMemento) {
        IStructuredSelection iStructuredSelection = this.convertFromViewer((ISelection)new StructuredSelection(((TreeViewer)this.getViewer()).getExpandedElements()));
        IMemento iMemento2 = iMemento.createChild(TAG_EXPAND_STATE);
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.saveElement(iMemento2, iterator.next());
        }
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        ResourceWorkingSetFilter resourceWorkingSetFilter = this.getWorkingSetFilter();
        if (resourceWorkingSetFilter == null) {
            return;
        }
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        Object[] objectArray = treeViewer.getExpandedElements();
        ISelection iSelection = treeViewer.getSelection();
        resourceWorkingSetFilter.setWorkingSet(iWorkingSet);
        if (iWorkingSet != null) {
            this.getSettings().put(SET_WORKING_SET, iWorkingSet.getName());
        } else {
            this.getSettings().put(SET_WORKING_SET, "");
        }
        this.updateTitle();
        treeViewer.refresh();
        treeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            treeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    public IWorkingSet getWorkingSet() {
        ResourceWorkingSetFilter resourceWorkingSetFilter = this.getWorkingSetFilter();
        if (resourceWorkingSetFilter == null) {
            return null;
        }
        return resourceWorkingSetFilter.getWorkingSet();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        IWorkingSet iWorkingSet = this.getWorkingSet();
        if ("workingSetRemove".equals(string) && object2 == iWorkingSet) {
            this.setWorkingSet(null);
        } else if ("workingSetNameChange".equals(string) && object == iWorkingSet) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(string) && object == iWorkingSet) {
            this.getViewer().refresh();
        }
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    public String getFrameName(Object object) {
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(object);
    }

    public String getFrameToolTipText(Object object) {
        return this.getFrameName(object);
    }

    protected FrameList createFrameList() {
        TreeNavigatorFrameSource treeNavigatorFrameSource = this.createFrameSource();
        if (treeNavigatorFrameSource == null) {
            return null;
        }
        FrameList frameList = new FrameList((IFrameSource)treeNavigatorFrameSource);
        treeNavigatorFrameSource.connectTo(frameList);
        return frameList;
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new TreeNavigatorFrameSource(this);
    }

    protected void initContextMenu() {
        super.initContextMenu();
        this.frameList = this.createFrameList();
    }

    public void updateTitle() {
        Object object = this.getViewer().getInput();
        String string = this.getConfigurationElement().getAttribute("name");
        IWorkingSet iWorkingSet = this.workingSetFilter.getWorkingSet();
        if (object == null || object.equals(this.getInitialViewerInput())) {
            this.setTitle(string);
            if (iWorkingSet != null) {
                this.setTitleToolTip(ResourceNavigatorMessages.format((String)"ResourceNavigator.workingSetToolTip", (Object[])new Object[]{iWorkingSet.getName()}));
            } else {
                this.setTitleToolTip("");
            }
        } else {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
            String string2 = this.getFrameToolTipText(object);
            this.setTitle(HyadesUIPlugin.getString("TREE_NAV_TTL", new String[]{string, iLabelProvider.getText(object)}));
            if (iWorkingSet != null) {
                this.setTitleToolTip(iWorkingSet.getName());
            } else {
                this.setTitleToolTip(string2);
            }
        }
    }
}

