/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.NewWizard;

public class NewObjectAction
extends Action
implements IDisposable {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWindow window;
    private IDialogSettings settings;
    private String wizardCategory;
    private String wizardTitle;

    public NewObjectAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        WorkbenchHelp.setHelp((IAction)this, (String)(HyadesUIPlugin.getID() + ".nact0003"));
    }

    public NewObjectAction(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_HOVER"));
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(this.getText());
        this.setSettings(HyadesUIPlugin.getInstance().getDialogSettings());
        this.wizardTitle = HyadesUIPlugin.getString("W_NEW");
    }

    public void dispose() {
        this.settings = null;
        this.window = null;
    }

    public void setSettings(IDialogSettings iDialogSettings) {
        this.settings = iDialogSettings;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    public void setWizardCategory(String string) {
        this.wizardCategory = string;
    }

    public String getWizardCategory() {
        return this.wizardCategory;
    }

    public void setWizardTitle(String string) {
        this.wizardTitle = string;
    }

    public String getWizardTitle() {
        return this.wizardTitle;
    }

    public void run() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        NewWizard newWizard = new NewWizard();
        String string = this.getWizardCategory();
        if (string != null) {
            newWizard.setCategoryId(string);
        }
        ISelection iSelection = this.window.getSelectionService().getSelection();
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        if (iSelection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)iSelection;
        }
        newWizard.init(iWorkbench, (IStructuredSelection)structuredSelection);
        IDialogSettings iDialogSettings = this.getSettings();
        if (iDialogSettings != null) {
            newWizard.setDialogSettings(iDialogSettings);
        }
        newWizard.setForcePreviousAndNextButtons(true);
        Shell shell = this.window.getShell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)newWizard);
        wizardDialog.create();
        String string2 = this.getWizardTitle();
        if (string2 != null) {
            newWizard.setWindowTitle(string2);
        }
        wizardDialog.getShell().setSize(Math.max(500, wizardDialog.getShell().getSize().x), 500);
        wizardDialog.open();
    }
}

