/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportManager
implements IDisposable {
    private static String prefKey = "reportDescriptions";
    private List pluginReportDescription;
    private List preferenceReportDescription = new ArrayList();
    private AbstractUIPlugin plugin;
    private String extensionPoint;

    public ReportManager(AbstractUIPlugin abstractUIPlugin, String string) {
        this.plugin = abstractUIPlugin;
        this.extensionPoint = string;
    }

    public void dispose() {
        if (this.pluginReportDescription != null) {
            this.pluginReportDescription.clear();
        }
        this.preferenceReportDescription.clear();
        this.plugin = null;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.plugin.getPreferenceStore();
    }

    public void addReportDefinition(IReportDescription iReportDescription) {
        this.preferenceReportDescription.add(iReportDescription);
    }

    public void removeReportDefinition(IReportDescription iReportDescription) {
        this.preferenceReportDescription.remove(iReportDescription);
    }

    public IReportDescription[] getPreferenceStoreReportDescriptions() {
        return this.preferenceReportDescription.toArray(new ReportDescription[this.preferenceReportDescription.size()]);
    }

    public IReportDescription[] getReportDescriptions() {
        ArrayList arrayList = null;
        if (this.pluginReportDescription != null) {
            arrayList = new ArrayList(this.pluginReportDescription);
            arrayList.addAll(this.preferenceReportDescription);
        } else {
            arrayList = this.preferenceReportDescription;
        }
        return arrayList.toArray(new ReportDescription[arrayList.size()]);
    }

    public void loadFromPluginRegistry() {
        if (this.pluginReportDescription != null) {
            return;
        }
        this.pluginReportDescription = new ArrayList();
        if (this.plugin != null) {
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(HyadesUIPlugin.getID(), this.extensionPoint);
            int n = 0;
            int n2 = iConfigurationElementArray.length;
            while (n < n2) {
                if ("reportDescription".equals(iConfigurationElementArray[n].getName())) {
                    String string = iConfigurationElementArray[n].getAttribute("name");
                    String string2 = iConfigurationElementArray[n].getAttribute("class");
                    this.pluginReportDescription.add(new ReportDescription(string, string2, "", iConfigurationElementArray[n]));
                }
                ++n;
            }
        }
    }

    public void loadFromPreferenceStore() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getString(prefKey);
        if (string == null || string.length() == 0) {
            return;
        }
        XMLUtil.setLogger(HyadesUIPlugin.getLogger());
        Element element = XMLUtil.loadDom(string, "reportDescriptions");
        if (element == null) {
            return;
        }
        NodeList nodeList = XMLUtil.getChildrenByName(element, "reportDescription");
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            if (nodeList.item(n) instanceof Element) {
                this.loadDescription((Element)nodeList.item(n));
            }
            ++n;
        }
    }

    protected void loadDescription(Element element) {
        String string = XMLUtil.getValue(element, "name");
        String string2 = XMLUtil.getValue(element, "class");
        if (string == null || string2 == null) {
            return;
        }
        String string3 = XMLUtil.getValue(element, "classpath");
        string3 = XMLUtil.removeXMLSymbols(string3);
        ReportDescription reportDescription = new ReportDescription(this.plugin.getClass().getClassLoader(), string, string2, string3);
        this.preferenceReportDescription.add(reportDescription);
    }

    public void saveIntoPreferenceStore() {
        Object object;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml");
        stringBuffer.append(XMLUtil.createXMLAttribute("version", "1.0", false)).append(XMLUtil.createXMLAttribute("encoding", "UTF-8", false));
        stringBuffer.append("?>");
        stringBuffer.append("<reportDescriptions>");
        Iterator iterator = this.preferenceReportDescription.iterator();
        while (iterator.hasNext()) {
            object = (IReportDescription)iterator.next();
            this.storeDescription(stringBuffer, (IReportDescription)object);
        }
        stringBuffer.append("</reportDescriptions>");
        object = stringBuffer.toString();
        if (((String)object).equals(iPreferenceStore.getString(prefKey))) {
            return;
        }
        iPreferenceStore.setValue(prefKey, (String)object);
    }

    protected void storeDescription(StringBuffer stringBuffer, IReportDescription iReportDescription) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<reportDescription");
        stringBuffer2.append(XMLUtil.createXMLAttribute("name", iReportDescription.getName(), false));
        stringBuffer2.append(XMLUtil.createXMLAttribute("class", iReportDescription.getClassName(), false));
        stringBuffer2.append(XMLUtil.createXMLAttribute("classpath", iReportDescription.getClassPath(), false));
        stringBuffer2.append("/>");
        stringBuffer.append(stringBuffer2);
    }
}

