/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ResourceUtil {
    static /* synthetic */ Class class$org$eclipse$ui$part$ISetSelectionTarget;

    public static void createContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iContainer == null || iContainer.exists()) {
            return;
        }
        ResourceUtil.createContainer(iContainer.getParent(), iProgressMonitor);
        if (iContainer instanceof IProject) {
            ((IProject)iContainer).create(iProgressMonitor);
        } else if (iContainer instanceof IFolder) {
            ((IFolder)iContainer).create(true, true, iProgressMonitor);
        }
    }

    public static void selectAndReveal(IResource iResource, IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null || iResource == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>();
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IWorkbenchPart iWorkbenchPart = iViewReferenceArray[n].getPart(false);
            if (iWorkbenchPart != null) {
                arrayList.add(iWorkbenchPart);
            }
            ++n;
        }
        iViewReferenceArray = iWorkbenchPage.getEditorReferences();
        int n2 = 0;
        while (n2 < iViewReferenceArray.length) {
            if (iViewReferenceArray[n2].getPart(false) != null) {
                arrayList.add(iViewReferenceArray[n2].getPart(false));
            }
            ++n2;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)iResource);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IWorkbenchPart iWorkbenchPart = (IWorkbenchPart)iterator.next();
            ISetSelectionTarget iSetSelectionTarget = null;
            iSetSelectionTarget = iWorkbenchPart instanceof ISetSelectionTarget ? (ISetSelectionTarget)iWorkbenchPart : (ISetSelectionTarget)iWorkbenchPart.getAdapter(class$org$eclipse$ui$part$ISetSelectionTarget == null ? ResourceUtil.class$("org.eclipse.ui.part.ISetSelectionTarget") : class$org$eclipse$ui$part$ISetSelectionTarget);
            if (iSetSelectionTarget == null) continue;
            final ISetSelectionTarget iSetSelectionTarget2 = iSetSelectionTarget;
            iWorkbenchWindow.getShell().getDisplay().asyncExec(new Runnable((ISelection)structuredSelection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    iSetSelectionTarget2.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static File getPluginDirectory(String string) {
        File file = null;
        try {
            URL uRL = new URL(Platform.getPlugin((String)string).getDescriptor().getInstallURL(), "plugin.xml");
            File file2 = new File(Platform.asLocalURL((URL)uRL).getFile()).getAbsoluteFile();
            if (file2.exists()) {
                file = file2.getParentFile();
            }
        }
        catch (Exception exception) {
            HyadesUIPlugin.logError(exception);
        }
        return file;
    }

    public static String[] getPluginLibraries(String string) {
        if (string == null) {
            return new String[0];
        }
        Plugin plugin = Platform.getPlugin((String)string);
        if (plugin == null) {
            return new String[0];
        }
        File file = ResourceUtil.getPluginDirectory(string);
        ILibrary[] iLibraryArray = plugin.getDescriptor().getRuntimeLibraries();
        ArrayList<String> arrayList = new ArrayList<String>(iLibraryArray.length);
        int n = 0;
        int n2 = iLibraryArray.length;
        while (n < n2) {
            File file2 = new File(file, iLibraryArray[n].getPath().toString());
            try {
                arrayList.add(file2.getCanonicalPath().replace('\\', '/'));
            }
            catch (IOException iOException) {
                arrayList.add(file2.getAbsolutePath().replace('\\', '/'));
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Map getFiles(IWorkspaceRoot iWorkspaceRoot, String[] stringArray, IGetFilesVisitor iGetFilesVisitor) {
        HashMap hashMap = new HashMap(stringArray.length, 1.1f);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            hashMap.put(stringArray[n], new ArrayList());
            ++n;
        }
        if (iGetFilesVisitor == null) {
            iGetFilesVisitor = new IGetFilesVisitor(){

                public Object visit(IFile iFile) {
                    return iFile;
                }
            };
        }
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        int n3 = 0;
        while (n3 < iProjectArray.length) {
            ResourceUtil.getFiles((IResource)iProjectArray[n3], hashMap, iGetFilesVisitor);
            ++n3;
        }
        return hashMap;
    }

    public static Map getFiles(IResource iResource, String[] stringArray, IGetFilesVisitor iGetFilesVisitor) {
        if (iResource == null || !iResource.exists()) {
            return Collections.EMPTY_MAP;
        }
        if (iGetFilesVisitor == null) {
            iGetFilesVisitor = new IGetFilesVisitor(){

                public Object visit(IFile iFile) {
                    return iFile;
                }
            };
        }
        HashMap hashMap = new HashMap(stringArray.length, 1.1f);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            hashMap.put(stringArray[n], new ArrayList());
            ++n;
        }
        ResourceUtil.getFiles(iResource, hashMap, iGetFilesVisitor);
        return hashMap;
    }

    private static void getFiles(IResource iResource, Map map, IGetFilesVisitor iGetFilesVisitor) {
        if (iResource == null || !iResource.exists()) {
            return;
        }
        switch (iResource.getType()) {
            case 1: {
                Object object;
                List list;
                String string = iResource.getFileExtension();
                if (string == null || (list = (List)map.get(string)) == null || (object = iGetFilesVisitor.visit((IFile)iResource)) == null) break;
                list.add(object);
                break;
            }
            case 4: {
                IProject iProject = (IProject)iResource;
                if (!iProject.isOpen()) {
                    return;
                }
            }
            case 2: {
                try {
                    IResource[] iResourceArray = ((IContainer)iResource).members();
                    int n = 0;
                    while (n < iResourceArray.length) {
                        ResourceUtil.getFiles(iResourceArray[n], map, iGetFilesVisitor);
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    HyadesUIPlugin.logError(coreException);
                }
                break;
            }
        }
    }

    public static List getValidAdapters(List list, Class clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            if (e instanceof IAdaptable) {
                Object object = ((IAdaptable)e).getAdapter(clazz);
                if (object == null) continue;
                arrayList.add(object);
                continue;
            }
            if (!clazz.isInstance(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static String getFullPath(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath.makeAbsolute());
        if (iResource != null) {
            iPath = iResource.getLocation().makeAbsolute();
        }
        return iPath.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface IGetFilesVisitor {
        public Object visit(IFile var1);
    }
}

