/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CreationWizardPage
extends WizardNewProjectCreationPage {
    private IConfigurationElement configurationElement;
    private String initialProjectName;
    private CreationWizard creationWizard;

    public CreationWizardPage(CreationWizard creationWizard, String string, IConfigurationElement iConfigurationElement) {
        super(string);
        this.configurationElement = iConfigurationElement;
        this.creationWizard = creationWizard;
        this.initialProjectName = this.getValue(iConfigurationElement, "name");
        if (this.initialProjectName != null) {
            this.setInitialProjectName(this.initialProjectName);
        }
        this.setDescription(this.getValue(iConfigurationElement, "pagedescription"));
        this.setTitle(this.getValue(iConfigurationElement, "pagetitle"));
    }

    public void dispose() {
        this.configurationElement = null;
        this.creationWizard = null;
        super.dispose();
    }

    protected CreationWizard getCreationWizard() {
        return this.creationWizard;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getInitialProjectName() {
        return this.initialProjectName;
    }

    protected boolean setHelpId() {
        String string = this.configurationElement.getAttribute("helpId");
        if (string == null) {
            return true;
        }
        if (this.getControl() == null) {
            return false;
        }
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)string);
        return true;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Text text = this.getProjectText();
        if (text != null) {
            text.notifyListeners(24, new Event());
            text.setSelection(0, text.getText().length());
        }
    }

    private Text getProjectText() {
        if (!(this.getControl() instanceof Composite)) {
            return null;
        }
        if (this.getProjectName() == null) {
            return null;
        }
        Composite composite = (Composite)this.getControl();
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                Control[] controlArray2 = ((Composite)controlArray[n]).getChildren();
                int n2 = 0;
                while (n2 < controlArray2.length) {
                    if (controlArray2[n2] instanceof Text) {
                        Text text = (Text)controlArray2[n2];
                        if (this.getProjectName().equals(text.getText())) {
                            return text;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String string = this.getProjectName();
        if (string == null) {
            return false;
        }
        IWizard iWizard = this.getWizard();
        if (iWizard instanceof CreationWizard) {
            IWizardPage[] iWizardPageArray = iWizard.getPages();
            int n = 0;
            while (n < iWizardPageArray.length) {
                if (iWizardPageArray[n] != this && iWizardPageArray[n] instanceof CreationWizardPage && string.equals(((CreationWizardPage)iWizardPageArray[n]).getProjectName())) {
                    this.setErrorMessage(HyadesUIPlugin.getString("_ERROR_DUP_PROJECT_NAME"));
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private String getValue(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }
}

