/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.TemplateContentHandler;
import org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

public class EventXMLFileEventFactoryHomeImpl
extends AbstractEventFactoryHome {
    private static final String XML_FILE_EXTENSION = ".event.xml";
    private static final String SYSTEM_PROPERTY_EXTENSION = ".event.xml".concat(".file");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public ContentHandler resolveContentHandler() {
        return new TemplateContentHandlerImpl();
    }

    public ContentHandler createContentHandler(String string) {
        if (string != null && string.trim().length() > 0) {
            int n;
            CommonBaseEvent[] commonBaseEventArray;
            InputStream inputStream = null;
            String string2 = System.getProperty(string.concat(SYSTEM_PROPERTY_EXTENSION));
            if (string2 != null) {
                try {
                    inputStream = new FileInputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                commonBaseEventArray = string.concat(XML_FILE_EXTENSION);
                try {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream((String)commonBaseEventArray);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (inputStream == null && (inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream((String)commonBaseEventArray)) == null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)commonBaseEventArray);
                }
            }
            if (inputStream != null) {
                try {
                    commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(inputStream);
                    if (commonBaseEventArray != null && commonBaseEventArray.length > 0 && commonBaseEventArray[0] != null) {
                        TemplateContentHandler templateContentHandler = (TemplateContentHandler)this.resolveContentHandler();
                        templateContentHandler.setTemplateEvent(commonBaseEventArray[0]);
                        return templateContentHandler;
                    }
                }
                catch (FormattingException formattingException) {
                    // empty catch block
                }
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                return this.createContentHandler(string.substring(0, n));
            }
        }
        return null;
    }
}

