/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.w3c.dom.Document;

public class XmlUtility
implements Constants {
    public static void serialize(Document document, File file) throws TransformerException {
        XmlUtility.serialize(document, file, true);
    }

    public static void serialize(Document document, File file, boolean bl) throws TransformerException {
        XmlUtility.createXMLTransformer(bl).transform(new DOMSource(document), new StreamResult(file));
    }

    public static String serialize(Document document) throws TransformerException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean bl) throws TransformerException {
        return new String(XmlUtility.serializeAsByteArray(document, bl));
    }

    public static byte[] serializeAsByteArray(Document document) throws TransformerException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl) throws TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtility.createXMLTransformer(bl).transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }

    private static Transformer createXMLTransformer(boolean bl) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        if (bl) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        if (Constants.OS_NAME.equals("z/OS") || Constants.OS_NAME.equals("OS/390")) {
            transformer.setOutputProperty("encoding", "IBM-1047");
        } else {
            transformer.setOutputProperty("encoding", "UTF-8");
        }
        return transformer;
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('?');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        int n2 = 0;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (c == '&' && (n = string.indexOf(59, n2 + 1)) != -1) {
                string2 = string.substring(n2 + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                n2 = n;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

