/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.profiler;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.collection.profiler.ProfilerNotAvailableException;

public final class Profiler {
    private static boolean _isTracing = true;
    private static boolean _isActive = true;
    private boolean _isProfiling = false;
    private int _mode = 3;
    private int _gcCount = 0;
    private List _fileList;
    private static Profiler _profiler;
    private static ProfilerNotAvailableException _errorCondition;
    public static final int PROFILER_EXECUTION_ONLY = 1;
    public static final int PROFILER_HEAP_ONLY = 2;
    public static final int PROFILER_EXECUTION_AND_HEAP = 3;
    public static final int PROFILER_OPTIMIZED_HEAP_ONLY = 4;
    public static final int EMIT_XML_SUCCESS = 0;
    public static final int EMIT_XML_SUSPENDED_IO = 1;
    public static final int EMIT_XML_FAIL = 2;

    private Profiler() throws ProfilerNotAvailableException {
        int n = this.initialize0();
        if (n < 0) {
            _errorCondition = new ProfilerNotAvailableException("The Java Profiling Agent is currently not running in \"application\" mode. ie. -XrunpiAgent:server=application must be provided as a  parameter to the JVM");
            throw _errorCondition;
        }
    }

    private native int initialize0();

    public static Profiler getProfiler() throws ProfilerNotAvailableException {
        if (!_isActive) {
            throw _errorCondition;
        }
        return _profiler;
    }

    public void setMode(int n) throws ProfilerNotAvailableException {
        if (n < 1 || n > 4) {
            throw new ProfilerNotAvailableException("Unknown mode");
        }
        if (n != 1 && n != 2 && n != 3 && n == 4 && this._mode != 4) {
            throw new ProfilerNotAvailableException("Unsupported mode change request");
        }
        this.setMode0(n);
    }

    private native void setMode0(int var1);

    public void startProfiling(boolean bl) {
        this.startProfiling(bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProfiling(boolean bl, int n) {
        Profiler profiler = this;
        synchronized (profiler) {
            if (!(this._mode != 1 && this._mode != 3 || this._isProfiling || this.startProfiling0(bl, n) != 0)) {
                this._isProfiling = true;
            }
        }
    }

    private native int startProfiling0(boolean var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProfiling() {
        Profiler profiler = this;
        synchronized (profiler) {
            if (this._isProfiling) {
                this.stopProfiling0();
                this._isProfiling = false;
            }
        }
    }

    private native void stopProfiling0();

    public void markHeap() {
        if ((this._mode == 2 || this._mode == 3) && _isActive) {
            this.markHeap0();
        }
    }

    private native void markHeap0();

    public void analyzeHeap(String string) {
        if ((this._mode == 2 || this._mode == 3) && this._isProfiling) {
            this.analyzeHeap0(string);
        }
    }

    private native void analyzeHeap0(String var1);

    public List optimizedHeapInfoSnapshot() {
        if (this._mode == 4) {
            if (this._fileList == null) {
                this._fileList = new ArrayList();
            }
            this._fileList.add(this.optimizedHeapDump0());
        }
        return null;
    }

    private native String optimizedHeapDump0();

    public List stopOptimizedHeapInfoSnapshot() {
        if (this._mode == 4) {
            this._fileList.add(this.stopOptimizedHeapInfoSnapshot0());
            List list = this._fileList;
            this._fileList = null;
            return list;
        }
        return null;
    }

    private native String stopOptimizedHeapInfoSnapshot0();

    public void disableGC() {
        if (_isActive) {
            ++this._gcCount;
            this.disableGC0();
        }
    }

    private native void disableGC0();

    public void enableGC() {
        if (_isActive && this._gcCount > 0) {
            --this._gcCount;
            this.enableGC0();
        }
    }

    private native void enableGC0();

    public void runGC() {
        if (_isActive) {
            this.runGC0();
        }
    }

    private native void runGC0();

    public boolean isProfiling() {
        return this._isProfiling;
    }

    public void release() {
        if (_isActive) {
            while (this._gcCount > 0) {
                this.disableGC();
            }
            this.release0();
        }
    }

    private native void release0();

    public static synchronized int emitXMLFragment(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return Profiler.emitXMLFragment(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 2;
        }
    }

    public static synchronized int emitXMLFragment(byte[] byArray, int n, int n2) {
        return Profiler.emitXMLFragment0(byArray, n, n2);
    }

    private static native int emitXMLFragment0(byte[] var0, int var1, int var2);

    static {
        try {
            System.loadLibrary("piAgent");
            _profiler = new Profiler();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _isActive = false;
            _profiler = null;
            _errorCondition = new ProfilerNotAvailableException("Cannot locate Java Profiling Agent.  Both, the IBM Agent Controller must be installed and the piAgent.dll must be provided as a parameter to the JVM and it must be running in \"application\" mode. ie. -XrunpiAgent:server=application must be provided as a parameter to the JVM: " + unsatisfiedLinkError);
        }
        catch (ProfilerNotAvailableException profilerNotAvailableException) {
            _isActive = false;
            _profiler = null;
        }
    }
}

