/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class DirectedGraph {
    private Object[] objList = null;
    private Object[][] adjMat = null;
    private int nVerts = -1;
    private Hashtable threadNumbers = null;
    private Hashtable _threads = null;
    private Hashtable _reversedTid = null;
    private boolean deadlockExists = false;

    public DirectedGraph(Hashtable hashtable) {
        this._threads = hashtable;
        int n = this._threads.size();
        this.objList = new Object[n];
        this.adjMat = new Object[n][n];
        this.nVerts = 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                this.adjMat[n2][n3] = null;
                ++n3;
            }
            ++n2;
        }
        this.threadNumbers = new Hashtable();
    }

    public void addVertex(Object object) {
        this.threadNumbers.put(object, new Integer(this.nVerts));
        this.objList[this.nVerts++] = object;
    }

    public void addEdge(Object object, Object object2, Object object3) {
        int n = (Integer)this.threadNumbers.get(object2);
        int n2 = (Integer)this.threadNumbers.get(object3);
        this.adjMat[n][n2] = object;
    }

    public void displayVertex(int n) {
        System.out.print(((Thd)this.objList[n])._threadId);
    }

    public void findCircularPattern() {
        int n = this.nVerts;
        while (this.nVerts > 0) {
            int n2 = this.noSuccessors();
            if (n2 == -1) {
                return;
            }
            this.deleteVertex(n2);
        }
    }

    public int noSuccessors() {
        int n = 0;
        while (n < this.nVerts) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.nVerts) {
                if (this.adjMat[n][n2] != null) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void deleteVertex(int n) {
        if (n != this.nVerts - 1) {
            int n2 = n;
            while (n2 < this.nVerts - 1) {
                this.objList[n2] = this.objList[n2 + 1];
                ++n2;
            }
            int n3 = n;
            while (n3 < this.nVerts - 1) {
                this.moveRowUp(n3, this.nVerts);
                ++n3;
            }
            int n4 = n;
            while (n4 < this.nVerts - 1) {
                this.moveColLeft(n4, this.nVerts - 1);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < this.nVerts) {
                this.adjMat[n][n5] = null;
                this.adjMat[n5][n] = null;
                ++n5;
            }
        }
        --this.nVerts;
    }

    private void moveRowUp(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.adjMat[n][n3] = this.adjMat[n + 1][n3];
            this.adjMat[n + 1][n3] = null;
            ++n3;
        }
    }

    private void moveColLeft(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.adjMat[n3][n] = this.adjMat[n3][n + 1];
            this.adjMat[n3][n + 1] = null;
            ++n3;
        }
    }

    public void debugPrint() {
        System.out.println("<p>Printing Graph:---------------------</p><br><br>");
        System.err.println("<table>");
        int n = 0;
        while (n < this.adjMat.length) {
            System.err.println("\t<tr><td>" + n + "</td><td>" + ((Thd)this.objList[n])._name + "</td></tr>");
            ++n;
        }
        System.err.println("</table>");
        System.err.println("<table>");
        System.err.println("\t<tr>");
        System.err.print("<td>&nbsp;</td>");
        int n2 = 0;
        while (n2 < this.adjMat.length) {
            System.err.print("<td>[" + n2 + "]</td>");
            ++n2;
        }
        System.err.println("\t</tr>");
        int n3 = 0;
        while (n3 < this.adjMat.length) {
            System.err.println("\t<tr>");
            System.err.print("<td>[" + n3 + "]</td>");
            int n4 = 0;
            while (n4 < this.adjMat[n3].length) {
                if (this.adjMat[n3][n4] == null) {
                    System.err.print("<td>-</td>");
                } else {
                    System.err.print("<td>" + ((Monitor)this.adjMat[n3][n4])._name + "</td>");
                }
                ++n4;
            }
            System.err.println("\t</tr>");
            ++n3;
        }
        System.err.println("</table>");
    }

    public void debugPrint(String string) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("IO Error:: Printing to err stream anyway.");
            printStream = System.err;
        }
        printStream.println("<p>Printing Graph:---------------------</p><br><br>");
        printStream.println("<table>");
        int n = 0;
        while (n < this.adjMat.length) {
            printStream.println("\t<tr><td>" + n + "</td><td>" + ((Thd)this.objList[n])._name + "</td></tr>");
            ++n;
        }
        printStream.println("</table>");
        printStream.println("<table>");
        printStream.println("\t<tr>");
        printStream.print("<td>&nbsp;</td>");
        int n2 = 0;
        while (n2 < this.adjMat.length) {
            printStream.print("<td>[" + n2 + "]</td>");
            ++n2;
        }
        printStream.println("\t</tr>");
        int n3 = 0;
        while (n3 < this.adjMat.length) {
            printStream.println("\t<tr>");
            printStream.print("<td>[" + n3 + "]</td>");
            int n4 = 0;
            while (n4 < this.adjMat[n3].length) {
                if (this.adjMat[n3][n4] == null) {
                    printStream.print("<td>-</td>");
                } else {
                    printStream.print("<td>" + ((Monitor)this.adjMat[n3][n4])._name + "</td>");
                }
                ++n4;
            }
            printStream.println("\t</tr>");
            ++n3;
        }
        printStream.println("</table>");
    }

    public Object[] getObjectList() {
        return this.objList;
    }

    public Object[][] getResultMatrix() {
        return this.adjMat;
    }

    public Object getObjectAt(int n, int n2) {
        if (this.adjMat != null && n < this.adjMat.length && n2 < this.adjMat[0].length) {
            return this.adjMat[n][n2];
        }
        return null;
    }

    public Object getObjectAt(Integer n, Integer n2) {
        return this.getObjectAt((int)n, (int)n2);
    }

    public Object getObjListObjectAt(int n) {
        if (this.objList != null && n < this.objList.length) {
            return this.objList[n];
        }
        return null;
    }

    public Object getObjListObjectAt(Integer n) {
        return this.getObjListObjectAt((int)n);
    }

    public Vector getNotNullPairs() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        Vector vector = new Vector();
        vector.add(new Vector());
        Vector<String> vector2 = null;
        ((Vector)vector.get(0)).add("The following threads appear to be waiting on themselves.\nCheck to see if the application is simply in a timed wait or if it is going \nto wait indefinitely.  Further information can be found by looking in the \nOverall Thread Analysis section of this tool.\n");
        if (this.adjMat != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.adjMat.length) {
                int n3 = 0;
                while (n3 < this.adjMat[0].length) {
                    if (this.adjMat[n2][n3] != null) {
                        if (n2 == n3) {
                            ((Thd)this.objList[n2]).setSelfWaiter(true);
                            if (!((Thd)this.objList[n2]).waitingForWork()) {
                                ((Vector)vector.get(0)).add("Single-threaded waiter " + ++n + ":\n" + "\"" + ((Thd)this.objList[n2])._name + "\" (TID:" + this._reversedTid.get(((Thd)this.objList[n2])._threadId) + ") is waiting on " + ((Monitor)this.adjMat[n2][n3])._name + "\n");
                            }
                        } else {
                            hashMap.put(new Integer(n2), new Integer(n3));
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            Integer n4 = null;
            Vector vector3 = new Vector();
            vector3.add(new Hashtable());
            if (iterator.hasNext()) {
                n4 = (Integer)iterator.next();
            }
            int n5 = 0;
            Integer n6 = null;
            while (!hashMap.isEmpty()) {
                n6 = (Integer)hashMap.get(n4);
                ((Hashtable)vector3.get(n5)).put(n4, n6);
                hashMap.remove(n4);
                n4 = n6;
                if ((Integer)hashMap.get(n4) != null || hashMap.isEmpty()) continue;
                iterator = set.iterator();
                n4 = (Integer)iterator.next();
                vector3.add(++n5, new Hashtable());
            }
            Vector<String> vector4 = new Vector<String>();
            Hashtable hashtable = null;
            int n7 = 0;
            while (n7 < vector3.size()) {
                iterator = null;
                hashtable = (Hashtable)vector3.get(n7);
                iterator = hashtable.keySet().iterator();
                Integer n8 = null;
                if (iterator.hasNext()) {
                    vector4.add("Multi-threaded deadlock " + (n7 + 1) + ":\n");
                    n8 = (Integer)iterator.next();
                    if (!((Thd)this.objList[n8]).isSelfWaiter()) {
                        while (iterator.hasNext()) {
                            n4 = (Integer)iterator.next();
                            if (!((Thd)this.objList[n4]).isSelfWaiter()) continue;
                            n8 = n4;
                            break;
                        }
                    }
                }
                n4 = null;
                while (hashtable.size() > 0) {
                    n4 = n4 == null ? n8 : n6;
                    n6 = (Integer)hashtable.get(n4);
                    hashtable.remove(n4);
                    if (((Thd)this.objList[n4]).isSelfWaiter()) {
                        vector4.add("Thread \"" + ((Thd)this.objList[n4.intValue()])._name + "\" is a self-waiter.  As a result, this deadlock is NON-circular.\n");
                    }
                    vector4.add("\"" + ((Thd)this.objList[n4.intValue()])._name + "\" of (sys:" + ((Thd)this.objList[n4.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[n4.intValue()])._threadId) + ")\n" + "\tHolding Resource: " + ((Monitor)this.adjMat[n4.intValue()][n6.intValue()])._name + "\n\tThread Waiting: \"" + ((Thd)this.objList[n6.intValue()])._name + "\" (sys:" + ((Thd)this.objList[n6.intValue()])._threadId + ") (TID:" + this._reversedTid.get(((Thd)this.objList[n6.intValue()])._threadId) + ")\n");
                }
                ++n7;
            }
            vector2 = new Vector<String>(vector4.size() + ((Vector)vector.get(0)).size());
            vector2.add("\n\nDeadlock Detection Report\n------------------------\n");
            if (vector4.size() > 0 || ((Vector)vector.get(0)).size() > 1) {
                this.deadlockExists = true;
            } else {
                vector2.add("No deadlock(s) found.\n");
            }
            if (vector4.size() > 1) {
                vector2.add("The following threads appear to be in a circular deadlock.\nFurther information can be found by looking in the Overall Thread Analysis\nsection of this tool.\n");
            }
            vector2.addAll(vector4);
            if (((Vector)vector.get(0)).size() > 1) {
                vector2.addAll((Vector)vector.get(0));
            }
            vector2.add("------------------------");
            return vector2;
        }
        return null;
    }

    public boolean getDeadlockExists() {
        return this.deadlockExists;
    }

    public void putReversedTid(Hashtable hashtable) {
        this._reversedTid = hashtable;
    }
}

