/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSEntryPointCaller;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class TOSEntryPoint {
    private StkEntry _stkEntry = null;
    protected Vector _threads = null;
    protected Vector _callers = null;

    public TOSEntryPoint(StkEntry stkEntry) {
        this._stkEntry = stkEntry;
        this._threads = new Vector();
        this._callers = new Vector();
    }

    String getName() {
        String string = null;
        if (this._stkEntry != null) {
            string = this._stkEntry.getFQName();
        }
        return string;
    }

    public int numThreads() {
        return this._threads.size();
    }

    public int numCallers() {
        return this._callers.size();
    }

    public void addThread(Thd thd) {
        this._threads.add(thd);
    }

    public Enumeration getThreadEnum() {
        Enumeration enumeration = this._threads.elements();
        return enumeration;
    }

    public Thd getNextThread(Enumeration enumeration) {
        Thd thd = null;
        if (enumeration.hasMoreElements()) {
            thd = (Thd)enumeration.nextElement();
        }
        return thd;
    }

    public void addCaller(TOSEntryPointCaller tOSEntryPointCaller) {
        this._callers.add(tOSEntryPointCaller);
    }

    public Enumeration getCallerEnum() {
        return this._callers.elements();
    }

    public TOSEntryPointCaller getNextCaller(Enumeration enumeration) {
        TOSEntryPointCaller tOSEntryPointCaller = null;
        if (enumeration.hasMoreElements()) {
            tOSEntryPointCaller = (TOSEntryPointCaller)enumeration.nextElement();
        }
        return tOSEntryPointCaller;
    }

    public void addThreadsNoDups(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Thd thd = (Thd)vector.elementAt(n);
            boolean bl = false;
            int n2 = 0;
            while (n2 < this._threads.size()) {
                Thd thd2 = (Thd)this._threads.elementAt(n2);
                if (thd2.equals(thd)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this._threads.add(thd);
            }
            ++n;
        }
    }

    private TOSEntryPoint() {
    }
}

