/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.InvocationEvent;
import org.eclipse.hyades.test.common.event.LoopEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.common.junit.HyadesTestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTest;
import org.eclipse.hyades.test.common.runner.HyadesRunner;
import org.eclipse.hyades.test.common.util.BaseString;

public class HyadesTestRunner
extends HyadesRunner
implements TestListener {
    protected static final boolean SYSOUT = false;
    private Test rootTest;
    private Collection succeedTests;
    private Collection failureTests;
    private Collection errorTests;
    private StringBuffer failureCauses;
    private StringBuffer errorCauses;
    private static Hashtable threadIDtoParentIDStackTable = new Hashtable();
    private static Hashtable threadIDtoParentThreadTable = new Hashtable();

    public HyadesTestRunner() {
        this.initialize();
    }

    public HyadesTestRunner(String[] stringArray) {
        super(stringArray);
        this.initialize();
    }

    private void initialize() {
        this.succeedTests = Collections.synchronizedCollection(new ArrayList());
        this.failureTests = Collections.synchronizedCollection(new ArrayList());
        this.errorTests = Collections.synchronizedCollection(new ArrayList());
        this.failureCauses = new StringBuffer();
        this.errorCauses = new StringBuffer();
    }

    public static void setParentThread(Thread thread, Thread thread2) {
        threadIDtoParentThreadTable.put(new Integer(thread.hashCode()), new Integer(thread2.hashCode()));
    }

    public static Integer getParentThreadID(Thread thread) {
        return (Integer)threadIDtoParentThreadTable.get(new Integer(thread.hashCode()));
    }

    public static Integer getParentThreadID(Integer n) {
        return (Integer)threadIDtoParentThreadTable.get(n);
    }

    public static Stack getParentStack() {
        int n = Thread.currentThread().hashCode();
        return (Stack)threadIDtoParentIDStackTable.get(new Integer(n));
    }

    public static void setParentStack(Stack stack) {
        int n = Thread.currentThread().hashCode();
        threadIDtoParentIDStackTable.put(new Integer(n), stack);
    }

    public static String peekParentEventID() {
        return HyadesTestRunner.peekParentEventID(new Integer(Thread.currentThread().hashCode()));
    }

    public static String peekParentEventID(Integer n) {
        Object object;
        Stack stack = (Stack)threadIDtoParentIDStackTable.get(n);
        try {
            if (stack != null && !stack.isEmpty() && (object = (String)stack.peek()) != null && ((String)object).length() > 0) {
                return object;
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        object = HyadesTestRunner.getParentThreadID(n);
        if (object == null) {
            return "ROOT";
        }
        return HyadesTestRunner.peekParentEventID((Integer)object);
    }

    public static synchronized void pushParentEventID(String string) {
        Stack<String> stack = HyadesTestRunner.getParentStack();
        if (stack != null) {
            stack.push(string);
        } else {
            stack = new Stack<String>();
            stack.push(string);
            HyadesTestRunner.setParentStack(stack);
        }
    }

    public static synchronized String popParentEventID() {
        Stack stack = HyadesTestRunner.getParentStack();
        try {
            if (stack != null && !stack.isEmpty()) {
                String string = (String)stack.pop();
                if (string == null || string.length() == 0) {
                    return "ROOT";
                }
                return string;
            }
        }
        catch (EmptyStackException emptyStackException) {}
        return "ROOT";
    }

    public static synchronized void seedParentStack(Thread thread) {
        Stack<String> stack = new Stack<String>();
        stack.push(HyadesTestRunner.peekParentEventID());
        int n = thread.hashCode();
        threadIDtoParentIDStackTable.put(new Integer(n), stack);
    }

    public Test getRoot() {
        return this.rootTest;
    }

    protected void setRoot(Test test) {
        this.rootTest = test;
    }

    public Collection getSucceedTests() {
        return this.succeedTests;
    }

    public Collection getFailureTests() {
        return this.failureTests;
    }

    public Collection getErrorTests() {
        return this.errorTests;
    }

    public void run(Class clazz) {
        this.run(new HyadesTestSuite(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Test test) {
        long l;
        this.setRoot(test);
        TestResult testResult = this.createTestResult();
        testResult.addListener((TestListener)this);
        this.runnerStarted();
        long l2 = this.getCurrentTime();
        try {
            test.run(testResult);
            l = this.getCurrentTime();
        }
        catch (Throwable throwable) {
            long l3 = this.getCurrentTime();
            this.runnerExit(testResult == null || testResult.shouldStop(), l3 - l2);
            throw throwable;
        }
        this.runnerExit(testResult == null || testResult.shouldStop(), l - l2);
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected void runnerStarted() {
        int n = HyadesTestUtil.countTests(new Test[]{this.getRoot()});
    }

    protected void runnerExit(boolean bl, long l) {
        this.writeEvent(this.getDefaultVerdictEvent(this.getRoot()));
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(this.getRoot()));
        typedEvent.setType(1);
        typedEvent.setText(this.getLastEventText(bl, l));
        typedEvent.setParentId("ROOT");
        this.writeEvent(typedEvent);
    }

    protected String getLastEventText(boolean bl, long l) {
        return null;
    }

    public void startTest(Test test) {
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setType(0);
        if (test instanceof IHyadesTest) {
            IHyadesTest iHyadesTest = (IHyadesTest)test;
            String string = iHyadesTest.getTestInvocationId();
            if (string != null) {
                String string2 = HyadesTestUtil.getHierarchyIds(iHyadesTest.getParent());
                string2 = HyadesTestUtil.appendToHierarchyId(string2, string, iHyadesTest.getIteration());
                InvocationEvent invocationEvent = new InvocationEvent();
                string = this.appendLoopIterationToID(string, (IHyadesTest)iHyadesTest.getParent());
                invocationEvent.setId(string);
                invocationEvent.setParentId(HyadesTestRunner.peekParentEventID());
                HyadesTestRunner.pushParentEventID(string);
                invocationEvent.setOwnerId(iHyadesTest.getTestInvocationId());
                invocationEvent.setStatus(1);
                invocationEvent.setReason(1);
                invocationEvent.setInvokedId(HyadesTestUtil.getHierarchyIds(iHyadesTest));
                this.writeEvent(invocationEvent);
                typedEvent.setOwnerId(iHyadesTest.getTestInvocationId());
            } else if (iHyadesTest.getParent() != null) {
                String string3 = iHyadesTest.getId();
                string3 = this.appendLoopIterationToID(string3, (IHyadesTest)iHyadesTest.getParent());
                if (iHyadesTest.getIteration() == 1) {
                    String string4 = HyadesTestRunner.peekParentEventID();
                    LoopEvent loopEvent = new LoopEvent();
                    loopEvent.setId(string3);
                    loopEvent.setAsychronous(!iHyadesTest.isSynchronous());
                    loopEvent.setOwnerId(iHyadesTest.getId());
                    loopEvent.setParentId(string4);
                    this.writeEvent(loopEvent);
                    HyadesTestRunner.pushParentEventID(string3);
                    typedEvent.setOwnerId(iHyadesTest.getId());
                } else if (iHyadesTest.getIteration() > 1) {
                    HyadesTestRunner.pushParentEventID(string3);
                    typedEvent.setOwnerId(iHyadesTest.getId());
                }
            }
        }
        typedEvent.setParentId(HyadesTestRunner.peekParentEventID());
        this.writeEvent(typedEvent);
    }

    public void endTest(Test test) {
        if (test == this.getRoot()) {
            return;
        }
        if (test instanceof TestCase && !this.getFailureTests().contains(test) && !this.getErrorTests().contains(test)) {
            this.getSucceedTests().add(test);
        }
        this.writeEvent(this.getDefaultVerdictEvent(test));
        TypedEvent typedEvent = new TypedEvent();
        if (test instanceof IHyadesTest) {
            IHyadesTest iHyadesTest = (IHyadesTest)test;
            String string = iHyadesTest.getTestInvocationId();
            if (string != null) {
                String string2 = HyadesTestUtil.getHierarchyIds(iHyadesTest.getParent());
                string2 = HyadesTestUtil.appendToHierarchyId(string2, string, iHyadesTest.getIteration());
                typedEvent.setParentId(HyadesTestRunner.popParentEventID());
                typedEvent.setOwnerId(string);
            } else if (iHyadesTest.getParent() != null && iHyadesTest.getIteration() > 0) {
                typedEvent.setParentId(HyadesTestRunner.popParentEventID());
                typedEvent.setOwnerId(iHyadesTest.getId());
            }
        }
        typedEvent.setType(1);
        this.writeEvent(typedEvent);
    }

    protected VerdictEvent getDefaultVerdictEvent(Test test) {
        ExecutionEvent executionEvent = null;
        if (test instanceof TestSuite) {
            HyadesTestSuite hyadesTestSuite;
            if (test instanceof HyadesTestSuite && (hyadesTestSuite = (HyadesTestSuite)test).getArbiter() != null && (executionEvent = hyadesTestSuite.getArbiter().analyse(hyadesTestSuite, this.filterTests(test, this.getSucceedTests()), this.filterTests(test, this.getErrorTests()), this.filterTests(test, this.getFailureTests()), this.errorCauses.toString(), this.failureCauses.toString())) != null && executionEvent.getOwnerId() == null) {
                executionEvent.setOwnerId(hyadesTestSuite.getId());
            }
        } else if (test instanceof TestCase && !this.getFailureTests().contains(test) && !this.getErrorTests().contains(test)) {
            executionEvent = new VerdictEvent();
            executionEvent.setOwnerId(((HyadesTestCase)test).getId());
            ((VerdictEvent)executionEvent).setVerdict(1);
            executionEvent.setId(this.computeVerdictId(HyadesTestRunner.peekParentEventID()));
        }
        if (executionEvent != null) {
            executionEvent.setParentId(HyadesTestRunner.peekParentEventID());
        }
        return executionEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(Test test, Throwable throwable) {
        this.getErrorTests().add(test);
        VerdictEvent verdictEvent = new VerdictEvent();
        if (test instanceof IHyadesTest) {
            String string = this.computeVerdictId(HyadesTestRunner.peekParentEventID());
            verdictEvent.setId(string);
            StringBuffer stringBuffer = this.errorCauses;
            synchronized (stringBuffer) {
                if (this.errorCauses.length() > 0) {
                    this.errorCauses.append(',');
                }
                this.errorCauses.append(string);
            }
        }
        verdictEvent.setParentId(HyadesTestRunner.peekParentEventID());
        verdictEvent.setVerdict(3);
        verdictEvent.setReason(2);
        verdictEvent.setText(BaseString.getStackTrace(throwable));
        this.writeEvent(verdictEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.getFailureTests().add(test);
        VerdictEvent verdictEvent = new VerdictEvent();
        if (test instanceof IHyadesTest) {
            String string = this.computeVerdictId(HyadesTestRunner.peekParentEventID());
            verdictEvent.setId(string);
            StringBuffer stringBuffer = this.failureCauses;
            synchronized (stringBuffer) {
                if (this.failureCauses.length() > 0) {
                    this.failureCauses.append(',');
                }
                this.failureCauses.append(string);
            }
        }
        verdictEvent.setParentId(HyadesTestRunner.peekParentEventID());
        verdictEvent.setVerdict(2);
        verdictEvent.setReason(2);
        verdictEvent.setText(BaseString.getStackTrace((Throwable)assertionFailedError));
        this.writeEvent(verdictEvent);
    }

    protected void writeEvent(ExecutionEvent executionEvent) {
        if (executionEvent != null) {
            System.out.println(executionEvent);
        }
    }

    protected Collection filterTests(Test test, Collection collection) {
        Test[] testArray = collection.toArray(new Test[collection.size()]);
        ArrayList<Test> arrayList = new ArrayList<Test>(testArray.length);
        int n = 0;
        int n2 = testArray.length;
        while (n < n2) {
            if (testArray[n] instanceof IHyadesTest && HyadesTestUtil.isParentOf(test, testArray[n])) {
                arrayList.add(testArray[n]);
            }
            ++n;
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    protected String computeVerdictId(String string) {
        return string + "_verdict";
    }

    protected String appendLoopIterationToID(String string, IHyadesTest iHyadesTest) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = HyadesTestSuite.getIterationsString(iHyadesTest);
        return string + string2;
    }
}

