/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableEditorListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.TableAdapter;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ControlTable
extends TableAdapter {
    public static final int VAL_CONTROL = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_IMAGE = 3;
    public static final int VAL_SLIDER = 4;
    public static final int VAL_MODIFY = 5;
    public static final int COL_NAME = 0;
    public static final int COL_DESC = 1;
    public static final int COL_IMAGE = 2;
    public static final int COL_SLIDER = 3;
    public static final int COL_MODIFY = 4;
    private Vector datas = new Vector();
    private Vector listeners = new Vector();
    private Integer[] sliderChoices = new Integer[]{new Integer(1)};
    private String[] sliderChoicesString = new String[]{"1"};

    public void addListener(ControlTableEditorListener controlTableEditorListener) {
        this.listeners.add(controlTableEditorListener);
    }

    public void notifyListeners(ZoomControlBar zoomControlBar) {
        if (zoomControlBar != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                ControlTableEditorListener controlTableEditorListener = (ControlTableEditorListener)this.listeners.elementAt(n);
                controlTableEditorListener.barEdited(zoomControlBar);
                ++n;
            }
        }
    }

    public ControlTable(Composite composite) {
        super(composite);
        String[] stringArray = new String[]{"Name", "Description", "Image", "Slider", "Value"};
        int[] nArray = new int[]{0, 0, 0, 2, 1};
        this.setColumnNames(stringArray);
        this.setColumnTypes(nArray);
        this.autoSizeOnContents = new boolean[]{true, false, false, true, true};
        this.columnExpands = new boolean[]{true, false, false, true, true};
        this.configure();
    }

    public void ensureControlsValid() {
        int n = 0;
        while (n < this.datas.size()) {
            BarElement barElement = (BarElement)this.datas.get(n);
            if (barElement.slider >= this.sliderChoices.length) {
                barElement.slider = new Integer(0);
            }
            ++n;
        }
        this.configure();
    }

    public void setSliderChoices(Integer[] integerArray, String[] stringArray) {
        this.sliderChoices = integerArray;
        this.sliderChoicesString = stringArray;
        this.ensureControlsValid();
        this.redraw();
    }

    public Object[] getElements(Object object) {
        return this.datas.toArray();
    }

    public void setControlValues(Object[][] objectArray) {
        int n = 0;
        while (n < this.datas.size()) {
            try {
                BarElement barElement = (BarElement)this.datas.get(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        this.datas.clear();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.datas.add(new BarElement((ZoomControlBar)objectArray[n2][0], (String)objectArray[n2][1], (String)objectArray[n2][2], (Image)objectArray[n2][3], (Integer)objectArray[n2][4], (SDModifiableVariableRepresentation)objectArray[n2][5]));
            ++n2;
        }
        this.configure();
    }

    public Object[][] getControlValues() {
        Object[][] objectArray = new Object[this.datas.size()][6];
        int n = 0;
        while (n < this.datas.size()) {
            objectArray[n][0] = ((BarElement)this.datas.get((int)n)).bar;
            objectArray[n][1] = ((BarElement)this.datas.get((int)n)).name;
            objectArray[n][2] = ((BarElement)this.datas.get((int)n)).description;
            objectArray[n][3] = ((BarElement)this.datas.get((int)n)).image;
            objectArray[n][4] = ((BarElement)this.datas.get((int)n)).slider;
            objectArray[n][5] = ((BarElement)this.datas.get((int)n)).rep;
            ++n;
        }
        return objectArray;
    }

    public String[] getComboChoices(Object object, int n) {
        BarElement barElement = (BarElement)object;
        if (n == 3) {
            return this.sliderChoicesString;
        }
        if (object == null) {
            return new String[]{"this is big enough"};
        }
        if (barElement.rep.getEnumerationValues() != null) {
            return barElement.rep.getEnumerationValues();
        }
        return new String[0];
    }

    public int getColumnType(Object object, int n) {
        BarElement barElement = (BarElement)object;
        if (n != 4) {
            return super.getColumnType(object, n);
        }
        if (barElement.rep.getModifierType() == 4) {
            return 2;
        }
        return 1;
    }

    public Image getColumnImage(Object object, int n) {
        BarElement barElement = (BarElement)object;
        if (n == 2) {
            return barElement.image;
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        BarElement barElement = (BarElement)object;
        if (n == 0) {
            return barElement.name;
        }
        if (n == 1) {
            return barElement.description;
        }
        if (n == 2) {
            return "";
        }
        if (n == 3) {
            int n2 = barElement.slider;
            if (n2 >= 0 && n2 < this.sliderChoicesString.length) {
                return this.sliderChoicesString[n2];
            }
            return "error";
        }
        if (n == 4) {
            return "" + barElement.rep.getLastRequestedValue();
        }
        return "";
    }

    public void valueChanged(Object object, int n, String string) throws InvalidTableValueException {
        try {
            BarElement barElement = (BarElement)object;
            double d = Double.parseDouble(string);
            d = Math.min(d, barElement.rep.getMaxBound());
            d = Math.max(d, barElement.rep.getMinBound());
            barElement.rep.setRequestedValue(System.currentTimeMillis(), d);
            this.notifyListeners(barElement.bar);
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.warning("invalid table value entered " + string);
            throw new InvalidTableValueException(throwable.toString());
        }
    }

    public void valueChanged(Object object, int n, Integer n2) throws InvalidTableValueException {
        if (n == 3) {
            try {
                BarElement barElement = (BarElement)object;
                barElement.slider = this.sliderChoices[n2];
                this.notifyListeners(barElement.bar);
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.warning("invalid table value entered " + n2);
                throw new InvalidTableValueException(throwable.toString());
            }
        }
        if (n == 4) {
            try {
                BarElement barElement = (BarElement)object;
                String string = barElement.rep.getEnumerationValues()[n2];
                barElement.rep.setRequestedValue(System.currentTimeMillis(), string);
                this.notifyListeners(barElement.bar);
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.warning("invalid table value entered " + n2);
                throw new InvalidTableValueException(throwable.toString());
            }
        }
        this.configure();
    }

    public class BarElement {
        public ZoomControlBar bar;
        public String name;
        public String description;
        public Integer slider;
        public Image image;
        public SDModifiableVariableRepresentation rep;

        public BarElement(ZoomControlBar zoomControlBar, String string, String string2, Image image, Integer n, SDModifiableVariableRepresentation sDModifiableVariableRepresentation) {
            this.bar = zoomControlBar;
            this.name = string;
            this.description = string2;
            this.image = image;
            this.slider = n;
            this.rep = sDModifiableVariableRepresentation;
        }

        public void update() {
        }
    }
}

