/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ColumnPrinter;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTable;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableEditorListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ExportTimeDialog;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditor;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableEditorListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphCanvas;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorLineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.MessagePanel;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.ReferenceLineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.ThicknessHighlighter;
import org.eclipse.hyades.statistical.ui.widgets.spinner.internal.DateDialog;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarsCollection;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class GraphWindow
extends Composite
implements PaintListener,
GraphTableEditorListener,
ControlTableEditorListener,
SelectionListener {
    public static final int TAB_GRAPHS = 0;
    public static final int TAB_CONTROLS = 1;
    public static final int TAB_LOG = 2;
    private static final boolean RIGHT_DRAG_RELEASES_BUTTON = false;
    public static final double YSLIDER_DEFMAX = 1.0E8;
    public static final double YSLIDER_DEFMIN = -1.0E8;
    private static final int XSLIDER_HEIGHT = 35;
    private static final int YSLIDER_WIDTH = 50;
    ArrayList disposables = new ArrayList();
    SashForm sash;
    Composite topsash;
    Composite bottomsash;
    Composite graph_panel;
    Composite nw_panel;
    GraphCanvas ne_panel;
    Composite sw_panel;
    Composite se_panel;
    ReferenceLineGraph ref_min_graph;
    ReferenceLineGraph ref_maj_graph;
    IndicatorLineGraph indicator_graph;
    boolean ref_min_on = true;
    boolean ref_maj_on = true;
    boolean sliders_match_graph = false;
    Composite modify_panel;
    Button add_vert;
    Button del_vert;
    Button add_horz;
    Button del_horz;
    TabFolder config_panel;
    TabItem config_tab;
    GraphTableEditor config_editor;
    TabItem control_tab;
    ControlTable control_editor;
    TabItem cbe_tab;
    MessagePanel cbe_text;
    ArrayList colours = new ArrayList();
    ArrayList ysliders = new ArrayList();
    ArrayList xsliders = new ArrayList();
    HashMap button_map = new HashMap();
    HashMap menu_map = new HashMap();
    GraphPopupListener graph_popup;
    final int GRAPH_COLUMNS = 10;
    Object[][] graph_values = new Object[0][10];
    final int CONTROL_COLUMNS = 7;
    Object[][] control_values = new Object[0][7];
    boolean constant_update = false;
    long constant_update_ms = 1000L;
    UpdateThread update_thread = null;
    ArrayList update_runnables = new ArrayList();
    Dirtiable dirtiable = null;
    protected ArrayList hslider_actions = new ArrayList();
    protected ArrayList vslider_actions = new ArrayList();
    ZoomSlider selected_slider;
    double selected_slider_value;

    public static void disposeObject(Object object) throws Throwable {
        Class<?> clazz = object.getClass();
        Throwable throwable = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod("dispose", new Class[0]);
                method.setAccessible(true);
                method.invoke(object, new Object[0]);
                throwable = null;
                break;
            }
            catch (Throwable throwable2) {
                EditorPlugin.DBG.warning("failed to dispose object " + object.getClass() + " / " + object);
                throwable = throwable2;
                clazz = clazz.getSuperclass();
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public void addUpdateRunnable(Runnable runnable) {
        this.update_runnables.add(runnable);
    }

    public void removeUpdateRunnables(Runnable runnable) {
        this.update_runnables.remove(runnable);
    }

    public void showTab(int n) {
        this.config_panel.setSelection(n);
    }

    public void setCBEText(String string) {
        this.cbe_text.setMsgText(string);
    }

    public void appendCBEText(String string) {
        this.cbe_text.appendMsgText(string);
    }

    public boolean getSlidersMatchGraph() {
        return this.sliders_match_graph;
    }

    public void setSlidersMatchGraph(boolean bl) {
        this.sliders_match_graph = bl;
        this.updateSliderColors();
        this.setDirty(true);
    }

    private void updateSliderColors() {
        if (this.sliders_match_graph) {
            Color color = this.ne_panel.getBackground();
            RGB rGB = color.getRGB();
            int n = rGB.red;
            int n2 = rGB.green;
            int n3 = rGB.blue;
            int n4 = (n + n2 + n3) / 3;
            RGB rGB2 = new RGB(n4 > 100 ? 0 : 255, n4 > 100 ? 0 : 255, n4 > 100 ? 0 : 255);
            Color color2 = ((ZoomSlider)((Object)this.ysliders.get(0))).getForeground();
            Color color3 = new Color((Device)this.getDisplay(), rGB2);
            this.disposables.add(color3);
            if (this.disposables.remove(color2)) {
                color2.dispose();
            }
            int n5 = 0;
            while (n5 < this.xsliders.size()) {
                ZoomSlider zoomSlider = (ZoomSlider)((Object)this.xsliders.get(n5));
                zoomSlider.setBackground(color);
                zoomSlider.setForeground(color3);
                zoomSlider.setTitleColor(color3);
                zoomSlider.updateScale();
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.ysliders.size()) {
                ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(n6));
                zoomSlider.setBackground(color);
                zoomSlider.setForeground(color3);
                zoomSlider.setTitleColor(color3);
                zoomSlider.updateScale();
                ++n6;
            }
            this.sw_panel.setBackground(color);
        } else {
            Color color = this.getDisplay().getSystemColor(22);
            Color color4 = this.getDisplay().getSystemColor(21);
            int n = 0;
            while (n < this.xsliders.size()) {
                ZoomSlider zoomSlider = (ZoomSlider)((Object)this.xsliders.get(n));
                zoomSlider.setBackground(color);
                zoomSlider.setForeground(color4);
                zoomSlider.setTitleColor(color4);
                zoomSlider.updateScale();
                ++n;
            }
            int n7 = 0;
            while (n7 < this.ysliders.size()) {
                ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(n7));
                zoomSlider.setBackground(color);
                zoomSlider.setForeground(color4);
                zoomSlider.setTitleColor(color4);
                zoomSlider.updateScale();
                ++n7;
            }
            this.sw_panel.setBackground(color);
        }
    }

    public void setConstantUpdate(boolean bl) {
        this.setConstantUpdate(bl, this.constant_update_ms);
    }

    public void setConstantUpdate(boolean bl, long l) {
        EditorPlugin.DBG.info("set constant update " + bl + " / " + l + "ms");
        if (l < 500L) {
            l = 500L;
        }
        this.constant_update_ms = l;
        EditorPlugin.DBG.info("actual constant update " + bl + " / " + l + "ms");
        if (bl && !this.constant_update) {
            this.constant_update = true;
            this.update_thread = new UpdateThread();
            this.update_thread.start();
        } else if (!bl && this.constant_update) {
            this.constant_update = false;
        }
    }

    public void jumpToNow() {
        int n = 0;
        while (n < this.xsliders.size()) {
            this.jumpToNow((TimeZoomSlider)((Object)this.xsliders.get(n)));
            ++n;
        }
    }

    public void jumpToNow(TimeZoomSlider timeZoomSlider) {
        block5: {
            this.indicator_graph.setIndicatorLocation(Double.MAX_VALUE);
            double d = System.currentTimeMillis();
            if (d <= timeZoomSlider.getMaxLimit()) {
                try {
                    timeZoomSlider.configure(timeZoomSlider.getMinLimit(), timeZoomSlider.getMaxLimit() + 7200000.0, timeZoomSlider.getMinVisible(), timeZoomSlider.getMaxVisible(), timeZoomSlider.getResolution());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!(d <= timeZoomSlider.getMaxLimit())) break block5;
            double d2 = d - timeZoomSlider.getMaxVisible();
            try {
                timeZoomSlider.configure(timeZoomSlider.getMinLimit(), timeZoomSlider.getMaxLimit(), timeZoomSlider.getMinVisible() + d2, timeZoomSlider.getMaxVisible() + d2, timeZoomSlider.getResolution());
                this.setDirty(true);
            }
            catch (Throwable throwable) {}
        }
    }

    public void setDirty(boolean bl) {
        if (this.dirtiable != null) {
            this.dirtiable.setDirty(bl);
        }
    }

    public GraphWindow(Composite composite, int n, Dirtiable dirtiable) {
        super(composite, n);
        this.dirtiable = dirtiable;
        this.initGraphics();
    }

    public GraphWindow(Composite composite, int n) {
        super(composite, n);
        this.initGraphics();
    }

    public Graph getIndicatorLineGraph() {
        return this.indicator_graph;
    }

    public Graph getMinorReferenceLineGraph() {
        return this.ref_min_graph;
    }

    public Graph getMajorReferenceLineGraph() {
        return this.ref_maj_graph;
    }

    public void updateSliders() {
        int n = 0;
        while (n < this.ysliders.size()) {
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(n));
            zoomSlider.updateScale();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.xsliders.size()) {
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.xsliders.get(n2));
            zoomSlider.updateScale();
            ++n2;
        }
    }

    public void updateTables() {
        this.updateGraphTable();
        this.updateControlTable();
    }

    public void updateGraphs() {
        this.ne_panel.redraw();
    }

    public void updateGraphTable() {
        Object[][] objectArray = this.graph_values;
        int n = 0;
        while (n < objectArray.length) {
            Graph graph = (Graph)objectArray[n][0];
            objectArray[n][3] = graph.getForeground().getRGB();
            objectArray[n][4] = new Integer(graph.getLineWidth());
            objectArray[n][5] = new Integer(graph.getLineStyle());
            objectArray[n][6] = new Integer(this.xsliders.indexOf((Object)graph.getXSlider()));
            objectArray[n][7] = new Integer(this.ysliders.indexOf((Object)graph.getYSlider()));
            objectArray[n][8] = new Double(graph.getStaticScaling());
            ++n;
        }
        this.config_editor.setValues(this.graph_values);
    }

    public void updateControlTable() {
        Object[][] objectArray = this.control_values;
        int n = 0;
        while (n < objectArray.length) {
            ZoomControlBar zoomControlBar = (ZoomControlBar)objectArray[n][0];
            if (zoomControlBar != null) {
                objectArray[n][4] = new Integer(this.ysliders.indexOf((Object)zoomControlBar.getZoomSlider()));
            }
            ++n;
        }
        this.rebuildSliderChoices();
        this.control_editor.setControlValues(this.control_values);
    }

    public void addGraph(String string, String string2, Graph graph, SDDescriptor sDDescriptor) {
        try {
            if (string == null) {
                string = "none";
            }
            if (string2 == null) {
                string2 = "none";
            }
            graph.setIndicatorSource(this.indicator_graph);
            int n = this.graph_values.length + 1;
            int n2 = this.graph_values.length;
            Object[][] objectArray = new Object[n][10];
            int n3 = 0;
            while (n3 < this.graph_values.length) {
                objectArray[n3] = this.graph_values[n3];
                ++n3;
            }
            objectArray[n2][0] = graph;
            objectArray[n2][1] = string;
            objectArray[n2][2] = string2;
            objectArray[n2][3] = graph.getForeground().getRGB();
            objectArray[n2][4] = new Integer(graph.getLineWidth());
            objectArray[n2][5] = new Integer(graph.getLineStyle());
            objectArray[n2][6] = new Integer(this.xsliders.indexOf((Object)graph.getXSlider()));
            objectArray[n2][7] = new Integer(this.ysliders.indexOf((Object)graph.getYSlider()));
            objectArray[n2][8] = new Double(graph.getStaticScaling());
            objectArray[n2][9] = sDDescriptor;
            this.graph_values = objectArray;
            this.config_editor.setValues(this.graph_values);
            this.ne_panel.addGraph(graph);
            this.ne_panel.redraw();
            this.setDirty(true);
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.warning("problem adding control to GraphWindow", throwable);
        }
    }

    public void addControl(String string, String string2, Image image, ZoomControlBar zoomControlBar, SDModifiableVariableRepresentation sDModifiableVariableRepresentation) {
        try {
            if (string == null) {
                string = "none";
            }
            if (string2 == null) {
                string2 = "none";
            }
            int n = this.control_values.length + 1;
            int n2 = this.control_values.length;
            Object[][] objectArray = new Object[n][7];
            int n3 = 0;
            while (n3 < this.control_values.length) {
                objectArray[n3] = this.control_values[n3];
                ++n3;
            }
            objectArray[n2][0] = zoomControlBar;
            objectArray[n2][1] = string;
            objectArray[n2][2] = string2;
            objectArray[n2][3] = image;
            objectArray[n2][4] = zoomControlBar == null ? new Integer(0) : new Integer(this.ysliders.indexOf((Object)zoomControlBar.getZoomSlider()));
            objectArray[n2][5] = sDModifiableVariableRepresentation;
            this.control_values = objectArray;
            this.rebuildSliderChoices();
            this.control_editor.setControlValues(this.control_values);
            this.setDirty(true);
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.warning("problem adding control to GraphWindow", throwable);
        }
    }

    private int getGraphIndex(Object[][] objectArray, Graph graph) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2][0] == graph) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getControlIndex(Object[][] objectArray, ZoomControlBar zoomControlBar) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2][0] == zoomControlBar) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getControlIndex(Object[][] objectArray, SDModifiableVariableRepresentation sDModifiableVariableRepresentation) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2][5] == sDModifiableVariableRepresentation) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeGraph(Graph graph) {
        int n = this.getGraphIndex(this.graph_values, graph);
        if (n == -1) {
            EditorPlugin.DBG.warning("attempt to remove non-existent graph (-1)");
            return;
        }
        if (n >= this.graph_values.length) {
            EditorPlugin.DBG.warning("attempt to remove non-existent graph > array length");
            return;
        }
        Object[][] objectArray = new Object[this.graph_values.length - 1][10];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.graph_values[n2];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.graph_values.length) {
            objectArray[n3 - 1] = this.graph_values[n3];
            ++n3;
        }
        this.graph_values = objectArray;
        this.config_editor.setValues(this.graph_values);
        this.ne_panel.removeGraph(graph);
        this.ne_panel.redraw();
        this.setDirty(true);
    }

    public void removeControl(SDModifiableVariableRepresentation sDModifiableVariableRepresentation) {
        int n = this.getControlIndex(this.control_values, sDModifiableVariableRepresentation);
        if (n == -1) {
            EditorPlugin.DBG.warning("attempt to remove non-existent control (-1)");
            return;
        }
        if (n >= this.control_values.length) {
            EditorPlugin.DBG.warning("attempt to remove non-existent control > array length");
            return;
        }
        ZoomControlBar zoomControlBar = (ZoomControlBar)this.control_values[n][0];
        Object[][] objectArray = new Object[this.control_values.length - 1][7];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.control_values[n2];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.control_values.length) {
            objectArray[n3 - 1] = this.control_values[n3];
            ++n3;
        }
        this.control_values = objectArray;
        this.rebuildSliderChoices();
        this.control_editor.setControlValues(this.control_values);
        if (zoomControlBar != null) {
            try {
                zoomControlBar.getZoomSlider().removeZoomControlBar(zoomControlBar);
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.warning("problem removing control", throwable);
            }
        }
        this.setDirty(true);
    }

    public void removeAllGraphs() {
        this.graph_values = new Object[0][10];
        this.config_editor.setValues(this.graph_values);
        this.ne_panel.removeAllGraphs();
        this.ne_panel.addGraph(this.ref_min_graph);
        this.ne_panel.addGraph(this.ref_maj_graph);
        this.ne_panel.addGraph(this.indicator_graph);
        this.setDirty(true);
    }

    public void setGraphBackground(Color color) {
        if (color != null) {
            this.setGraphBackground(color.getRGB());
        }
    }

    public void setGraphBackground(RGB rGB) {
        if (rGB != null) {
            int n = rGB.red;
            int n2 = rGB.green;
            int n3 = rGB.blue;
            int n4 = (n + n2 + n3) / 3;
            Color color = this.ne_panel.getBackground();
            Color color2 = new Color((Device)this.getDisplay(), rGB);
            this.disposables.add(color2);
            if (this.disposables.remove(color)) {
                color.dispose();
            }
            this.ne_panel.setBackground(color2);
            this.updateSliderColors();
            double d = 40.0;
            RGB rGB2 = new RGB((int)(n > 128 ? (double)n - d : (double)n + d), (int)(n2 > 128 ? (double)n2 - d : (double)n2 + d), (int)(n3 > 128 ? (double)n3 - d : (double)n3 + d));
            d = 60.0;
            RGB rGB3 = new RGB((int)(n > 128 ? (double)n - d : (double)n + d), (int)(n2 > 128 ? (double)n2 - d : (double)n2 + d), (int)(n3 > 128 ? (double)n3 - d : (double)n3 + d));
            RGB rGB4 = new RGB(n4 > 100 ? 0 : 255, n4 > 100 ? 0 : 255, n4 > 100 ? 0 : 255);
            color = this.ref_min_graph.getForeground();
            color2 = new Color((Device)this.getDisplay(), rGB2);
            this.disposables.add(color2);
            if (this.disposables.remove(color)) {
                color.dispose();
            }
            this.ref_min_graph.setForeground(color2);
            color = this.ref_maj_graph.getForeground();
            color2 = new Color((Device)this.getDisplay(), rGB3);
            this.disposables.add(color2);
            if (this.disposables.remove(color)) {
                color.dispose();
            }
            this.ref_maj_graph.setForeground(color2);
            color = this.indicator_graph.getForeground();
            color2 = new Color((Device)this.getDisplay(), rGB4);
            this.disposables.add(color2);
            if (this.disposables.remove(color)) {
                color.dispose();
            }
            this.indicator_graph.setForeground(color2);
            this.setDirty(true);
        }
    }

    public Color getGraphBackground() {
        return this.ne_panel.getBackground();
    }

    public void setYSlidersBackground(Color color) {
        this.nw_panel.setBackground(color);
        this.setDirty(true);
    }

    public void setXSlidersBackground(Color color) {
        this.se_panel.setBackground(color);
        this.setDirty(true);
    }

    public void setDeadSpaceBackground(Color color) {
        this.sw_panel.setBackground(color);
        this.setDirty(true);
    }

    private Color getColor(int n, int n2, int n3) {
        Color color = new Color((Device)this.getShell().getDisplay(), n, n2, n3);
        this.colours.add(color);
        return color;
    }

    private void initGraphics() {
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = null;
        this.sash = new SashForm((Composite)this, 0);
        this.sash.setOrientation(512);
        this.disposables.add(this.sash);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.sash.setLayoutData((Object)gridData);
        this.topsash = new Group((Composite)this.sash, 0);
        this.bottomsash = new Composite((Composite)this.sash, 0);
        this.disposables.add(this.topsash);
        this.disposables.add(this.bottomsash);
        this.topsash.setLayout((Layout)new FillLayout());
        this.bottomsash.setLayout((Layout)new FillLayout());
        this.graph_panel = new Composite(this.topsash, 0);
        WorkbenchHelp.setHelp((Control)this.graph_panel, (String)(EditorPlugin.getInfopopsId() + ".statcon_anywhere"));
        this.config_panel = new TabFolder(this.bottomsash, 128);
        this.disposables.add(this.graph_panel);
        this.disposables.add(this.config_panel);
        this.sash.setWeights(new int[]{75, 25});
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.nw_panel = new Composite(this.graph_panel, 0);
        this.ne_panel = new GraphCanvas(this.graph_panel, 0);
        this.sw_panel = new Composite(this.graph_panel, 0);
        this.se_panel = new Composite(this.graph_panel, 0);
        this.sw_panel.setBackground(this.getDisplay().getSystemColor(22));
        this.graph_popup = new GraphPopupListener(this.ne_panel);
        this.ne_panel.addMouseListener(this.graph_popup);
        this.disposables.add(this.nw_panel);
        this.disposables.add(this.ne_panel);
        this.disposables.add(this.sw_panel);
        this.disposables.add(this.se_panel);
        gridLayout = new GridLayout(2, false);
        gridData = null;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.graph_panel.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        this.nw_panel.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.ne_panel.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 30;
        this.sw_panel.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 30;
        this.se_panel.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.config_panel.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.config_editor = new GraphTableEditor((Composite)this.config_panel, 0, this.graph_values, (Control)this.ne_panel);
        this.config_editor.setLayoutData(gridData);
        this.config_editor.addListener(this);
        this.config_tab = new TabItem(this.config_panel, 0);
        this.config_tab.setControl((Control)this.config_editor);
        this.config_tab.setText(EditorPlugin.getString("TABLE_NAME_GRAPHS"));
        this.config_tab.setToolTipText(EditorPlugin.getString("GRAPHS_TAB_TOOLTIP"));
        this.ne_panel.setGraphHighlighter(new ThicknessHighlighter());
        this.ne_panel.setGraphSelectionSource(this.config_editor);
        this.disposables.add(this.config_editor);
        this.control_editor = new ControlTable((Composite)this.config_panel);
        this.control_editor.setLayoutData(gridData);
        this.control_editor.addListener(this);
        this.control_tab = new TabItem(this.config_panel, 0);
        this.control_tab.setControl((Control)this.control_editor);
        this.control_tab.setText(EditorPlugin.getString("TABLE_NAME_CONTROLS"));
        this.control_tab.setToolTipText(EditorPlugin.getString("CONTROLS_TAB_TOOLTIP"));
        this.disposables.add(this.control_editor);
        this.cbe_text = new MessagePanel((Composite)this.config_panel, 0);
        this.cbe_tab = new TabItem(this.config_panel, 0);
        this.cbe_tab.setControl((Control)this.cbe_text);
        this.cbe_tab.setText(EditorPlugin.getString("TABLE_NAME_CBELOG"));
        this.cbe_tab.setToolTipText(EditorPlugin.getString("MESSAGES_TAB_TOOLTIP"));
        WorkbenchHelp.setHelp((Control)this.config_editor, (String)(EditorPlugin.getInfopopsId() + ".statcon_graphtable"));
        WorkbenchHelp.setHelp((Control)this.control_editor, (String)(EditorPlugin.getInfopopsId() + ".statcon_controlstable"));
        WorkbenchHelp.setHelp((Control)this.cbe_text, (String)(EditorPlugin.getInfopopsId() + ".statcon_cbelog"));
        this.addXSlider();
        this.addYSlider();
        this.ref_min_graph = new ReferenceLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(15), false);
        this.ref_maj_graph = new ReferenceLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(16), true);
        this.indicator_graph = new IndicatorLineGraph(this.getXSlider(0), this.getYSlider(0), this.getShell().getDisplay().getSystemColor(2));
        this.indicator_graph.setSourceType(1);
        this.ne_panel.addGraph(this.ref_min_graph);
        this.ne_panel.addGraph(this.ref_maj_graph);
        this.ne_panel.addGraph(this.indicator_graph);
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.colours);
        this.disposables.addAll(this.xsliders);
        this.disposables.addAll(this.ysliders);
        this.disposables.addAll(this.menu_map.values());
        EditorPlugin.DBG.info(this.getClass() + ":disposed");
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            GraphWindow.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.warning("failed to dispose " + e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("dispose error ", throwable);
            }
            ++n;
        }
    }

    public int getXSliderCount() {
        return this.xsliders.size();
    }

    public int getYSliderCount() {
        return this.ysliders.size();
    }

    public ZoomSlider getYSlider(int n) {
        return (ZoomSlider)((Object)this.ysliders.get(n));
    }

    public int getYSlider(ZoomSlider zoomSlider) {
        return this.ysliders.indexOf((Object)zoomSlider);
    }

    public TimeZoomSlider getXSlider(int n) {
        return (TimeZoomSlider)((Object)this.xsliders.get(n));
    }

    public int getXSlider(TimeZoomSlider timeZoomSlider) {
        return this.xsliders.indexOf((Object)timeZoomSlider);
    }

    public void ensureGraphsAreValid() {
        TimeZoomSlider timeZoomSlider = (TimeZoomSlider)((Object)this.xsliders.get(0));
        ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(0));
        if (!this.xsliders.contains((Object)this.ref_min_graph.getXSlider())) {
            this.ref_min_graph.setXSlider(timeZoomSlider);
        }
        if (!this.ysliders.contains((Object)this.ref_min_graph.getYSlider())) {
            this.ref_min_graph.setYSlider(zoomSlider);
        }
        if (!this.xsliders.contains((Object)this.ref_maj_graph.getXSlider())) {
            this.ref_maj_graph.setXSlider(timeZoomSlider);
        }
        if (!this.ysliders.contains((Object)this.ref_maj_graph.getYSlider())) {
            this.ref_maj_graph.setYSlider(zoomSlider);
        }
        if (!this.xsliders.contains((Object)this.indicator_graph.getXSlider())) {
            this.indicator_graph.setXSlider(timeZoomSlider);
        }
        if (!this.ysliders.contains((Object)this.indicator_graph.getYSlider())) {
            this.indicator_graph.setYSlider(zoomSlider);
        }
        int n = 0;
        while (n < this.graph_values.length) {
            Graph graph = (Graph)this.graph_values[n][0];
            TimeZoomSlider timeZoomSlider2 = graph.getXSlider();
            ZoomSlider zoomSlider2 = graph.getYSlider();
            if (!this.ysliders.contains((Object)zoomSlider2)) {
                graph.setYSlider(zoomSlider);
            }
            if (!this.xsliders.contains((Object)timeZoomSlider2)) {
                graph.setXSlider(timeZoomSlider);
            }
            ++n;
        }
    }

    public void rebuildSliderChoices() {
        Integer[] integerArray = new Integer[this.xsliders.size()];
        String[] stringArray = new String[this.xsliders.size()];
        Integer[] integerArray2 = new Integer[this.ysliders.size()];
        String[] stringArray2 = new String[this.ysliders.size()];
        int n = 0;
        while (n < this.xsliders.size()) {
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.xsliders.get(n));
            integerArray[n] = new Integer(n);
            stringArray[n] = zoomSlider.getTitle();
            if (stringArray[n] == null) {
                stringArray[n] = EditorPlugin.getString("HORIZONTAL_SLIDER_PREFIX") + " " + (n + 1);
                zoomSlider.setTitle(stringArray[n]);
                zoomSlider.redraw();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.ysliders.size()) {
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(n2));
            integerArray2[n2] = new Integer(n2);
            stringArray2[n2] = zoomSlider.getTitle();
            if (stringArray2[n2] == null) {
                stringArray2[n2] = EditorPlugin.getString("VERTICAL_SLIDER_PREFIX") + " " + (n2 + 1);
                zoomSlider.setTitle(stringArray2[n2]);
                zoomSlider.redraw();
            }
            ++n2;
        }
        this.config_editor.setXSliderChoices(integerArray, stringArray);
        this.config_editor.setYSliderChoices(integerArray2, stringArray2);
        this.control_editor.setSliderChoices(integerArray2, stringArray2);
    }

    public void shiftBars(ZoomSlider zoomSlider, ZoomSlider zoomSlider2) {
        ZoomControlBarsCollection zoomControlBarsCollection = zoomSlider.getZoomControlBarsCollection();
        Vector vector = zoomControlBarsCollection.getZoomControlBars();
        int n = 0;
        while (n < vector.size()) {
            ZoomControlBar zoomControlBar = (ZoomControlBar)vector.get(n);
            zoomSlider.removeZoomControlBar(zoomControlBar);
            zoomControlBar.setZoomSlider(zoomSlider2);
            zoomSlider2.addZoomControlBar(zoomControlBar);
            ++n;
        }
    }

    public void updateSliderLayouts() {
        GridData gridData = (GridData)this.nw_panel.getLayoutData();
        gridData.widthHint = 50 * this.ysliders.size();
        this.nw_panel.setLayoutData((Object)gridData);
        gridData = (GridData)this.se_panel.getLayoutData();
        gridData.heightHint = 35 * this.xsliders.size();
        this.se_panel.setLayoutData((Object)gridData);
        this.se_panel.layout(true);
        this.se_panel.redraw();
        this.nw_panel.layout(true);
        this.nw_panel.redraw();
        this.graph_panel.layout(true);
        this.graph_panel.redraw();
        this.graph_panel.update();
    }

    public void removeYSlider(ZoomSlider zoomSlider) {
        this.removeYSlider(this.ysliders.indexOf((Object)zoomSlider));
    }

    public void removeYSlider(int n) {
        if (n > -1 && n < this.ysliders.size() && this.ysliders.size() > 1) {
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.ysliders.get(n));
            this.ysliders.remove((Object)zoomSlider);
            this.shiftBars(zoomSlider, (ZoomSlider)((Object)this.ysliders.get(0)));
            SliderPopupListener sliderPopupListener = (SliderPopupListener)this.menu_map.get((Object)zoomSlider);
            if (sliderPopupListener != null) {
                sliderPopupListener.dispose();
            }
            this.ensureGraphsAreValid();
            zoomSlider.dispose();
            GridLayout gridLayout = new GridLayout(this.ysliders.size(), false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.nw_panel.setLayout((Layout)gridLayout);
            this.rebuildSliderChoices();
            this.updateSliderLayouts();
            this.updateTables();
            this.setDirty(true);
        }
    }

    public void removeXSlider(ZoomSlider zoomSlider) {
        this.removeXSlider(this.xsliders.indexOf((Object)zoomSlider));
    }

    public void removeXSlider(int n) {
        if (n > -1 && n < this.xsliders.size() && this.xsliders.size() > 1) {
            Button button;
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.xsliders.get(n));
            this.xsliders.remove((Object)zoomSlider);
            this.shiftBars(zoomSlider, (TimeZoomSlider)((Object)this.xsliders.get(0)));
            SliderPopupListener sliderPopupListener = (SliderPopupListener)this.menu_map.get((Object)zoomSlider);
            if (sliderPopupListener != null) {
                sliderPopupListener.dispose();
            }
            if ((button = (Button)this.button_map.get((Object)zoomSlider)) != null) {
                button.dispose();
            }
            this.ensureGraphsAreValid();
            zoomSlider.dispose();
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.se_panel.setLayout((Layout)gridLayout);
            this.rebuildSliderChoices();
            this.updateSliderLayouts();
            this.updateTables();
            this.setDirty(true);
        }
    }

    public void addYSlider() {
        GridLayout gridLayout = new GridLayout(this.ysliders.size() + 1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.nw_panel.setLayout((Layout)gridLayout);
        try {
            long l = System.currentTimeMillis();
            ZoomSlider zoomSlider = new ZoomSlider(this.nw_panel);
            WorkbenchHelp.setHelp((Control)zoomSlider, (String)(EditorPlugin.getInfopopsId() + ".statcon_anywhere"));
            zoomSlider.setOrientation(0);
            zoomSlider.configure(0.0, 1.0E8, 0.0, 500.0, 0.01);
            GridData gridData = new GridData();
            gridData.heightHint = 50;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            zoomSlider.setLayoutData(gridData);
            int n = this.ysliders.size();
            this.ysliders.add(zoomSlider);
            this.disposables.add(zoomSlider);
            SliderPopupListener sliderPopupListener = new SliderPopupListener(zoomSlider, false);
            this.menu_map.put(zoomSlider, sliderPopupListener);
            this.rebuildSliderChoices();
            this.updateSliderColors();
            this.updateSliderLayouts();
            this.setDirty(true);
            return;
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.error("problem adding Y slider ", throwable);
            this.updateSliderColors();
            this.rebuildSliderChoices();
            return;
        }
    }

    public void addXSlider() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.se_panel.setLayout((Layout)gridLayout);
        try {
            TimeZoomSlider timeZoomSlider = new TimeZoomSlider(this.se_panel);
            WorkbenchHelp.setHelp((Control)timeZoomSlider, (String)(EditorPlugin.getInfopopsId() + ".statcon_anywhere"));
            timeZoomSlider.setOrientation(1);
            timeZoomSlider.setDirection(-1);
            timeZoomSlider.configure(0.0, 3600000.0, 0.0, 60000.0, 1000.0);
            timeZoomSlider.setWallTime(true);
            GridData gridData = new GridData();
            gridData.widthHint = 50;
            gridData.heightHint = 30;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            timeZoomSlider.setLayoutData(gridData);
            Button button = new Button(this.se_panel, 2);
            button.setText(">");
            this.button_map.put(timeZoomSlider, button);
            gridData = new GridData();
            gridData.widthHint = 15;
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = false;
            gridData.grabExcessVerticalSpace = true;
            button.setLayoutData((Object)gridData);
            this.xsliders.add(timeZoomSlider);
            this.disposables.add(timeZoomSlider);
            SliderPopupListener sliderPopupListener = new SliderPopupListener(timeZoomSlider, true);
            this.menu_map.put(timeZoomSlider, sliderPopupListener);
            this.rebuildSliderChoices();
            this.updateSliderColors();
            this.updateSliderLayouts();
            this.setDirty(true);
            return;
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.error("problem adding X slider ", throwable);
            this.updateSliderColors();
            this.rebuildSliderChoices();
            return;
        }
    }

    public void setTimeSliderFollowing(TimeZoomSlider timeZoomSlider, boolean bl) {
        Button button = (Button)this.button_map.get((Object)timeZoomSlider);
        if (button != null) {
            button.setSelection(bl);
        }
    }

    public boolean getTimeSliderFollowing(TimeZoomSlider timeZoomSlider) {
        Button button = (Button)this.button_map.get((Object)timeZoomSlider);
        if (button != null) {
            return button.getSelection();
        }
        return false;
    }

    public void snapSlider(ZoomSlider zoomSlider) {
        double d = -2.0E9;
        double d2 = 2.0E9;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.graph_values.length) {
            double d5;
            double d6;
            Graph graph = (Graph)this.graph_values[n][0];
            if (zoomSlider == graph.getXSlider()) {
                d6 = graph.getXMin();
                d5 = graph.getXMax();
                if (d6 != Double.NEGATIVE_INFINITY && d6 != Double.POSITIVE_INFINITY && d6 < d3) {
                    d3 = d6;
                    bl = true;
                }
                if (d5 != Double.NEGATIVE_INFINITY && d5 != Double.POSITIVE_INFINITY && d5 > d4) {
                    d4 = d5;
                    bl2 = true;
                }
            } else if (zoomSlider == graph.getYSlider()) {
                d6 = graph.getYMin();
                d5 = graph.getYMax();
                if (d6 != Double.NEGATIVE_INFINITY && d6 != Double.POSITIVE_INFINITY && d6 < d3) {
                    d3 = d6;
                    bl = true;
                }
                if (d5 != Double.NEGATIVE_INFINITY && d5 != Double.POSITIVE_INFINITY && d5 > d4) {
                    d4 = d5;
                    bl2 = true;
                }
            }
            ++n;
        }
        if (d4 > d3 && bl && bl2) {
            double d7 = 2.4192E9;
            if (d4 - d3 > d7) {
                d3 = d4 - d7;
            }
            if (d4 - d3 < zoomSlider.getResolution()) {
                d4 += zoomSlider.getResolution() * 5.0;
                d3 -= zoomSlider.getResolution() * 5.0;
            }
            EditorPlugin.DBG.info("Snapping to " + d3 + " / " + d4);
            try {
                if (zoomSlider instanceof TimeZoomSlider) {
                    double d8 = 7200000.0;
                    zoomSlider.configure(d3, d4 + d8, d3, d4, zoomSlider.getResolution());
                    this.setDirty(true);
                } else {
                    double d9 = d3;
                    double d10 = d4;
                    d9 = d3 < 0.0 ? -1.0E8 : 0.0;
                    d10 = 1.0E8;
                    if (d3 >= 0.0) {
                        d3 = 0.0;
                    }
                    zoomSlider.configure(d9, d10, d3, d4, zoomSlider.getResolution());
                    this.setDirty(true);
                }
                zoomSlider.redraw();
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("problem snapping slider", throwable);
            }
        } else {
            EditorPlugin.DBG.info("snap slider request is invalid");
        }
        this.ne_panel.redraw();
    }

    public void paintControl(PaintEvent paintEvent) {
        this.ne_panel.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object == this.add_vert) {
            this.addYSlider();
            this.setDirty(true);
        } else if (object == this.del_vert) {
            this.removeYSlider(0);
            this.setDirty(true);
        } else if (object == this.add_horz) {
            this.addXSlider();
            this.setDirty(true);
        } else if (object == this.del_horz) {
            this.removeXSlider(0);
            this.setDirty(true);
        } else {
            return;
        }
        this.layout(true);
        this.redraw();
        this.update();
    }

    public void barMoved(ZoomControlBar zoomControlBar, int n) {
        if (zoomControlBar == null) {
            EditorPlugin.DBG.error("zoom control bar is null", new Exception("Null bar being moved?"));
            return;
        }
        ZoomSlider zoomSlider = zoomControlBar.getZoomSlider();
        ZoomSlider zoomSlider2 = null;
        zoomSlider2 = n >= this.ysliders.size() ? (ZoomSlider)((Object)this.xsliders.get(n -= this.ysliders.size() - 1)) : (ZoomSlider)((Object)this.ysliders.get(n));
        if (zoomSlider != zoomSlider2) {
            if (!zoomSlider.isDisposed()) {
                zoomSlider.removeZoomControlBar(zoomControlBar);
            }
            zoomControlBar.setZoomSlider(zoomSlider2);
            zoomSlider2.addZoomControlBar(zoomControlBar);
        }
        this.setDirty(true);
    }

    public void barEdited(ZoomControlBar zoomControlBar) {
        this.control_values = this.control_editor.getControlValues();
        int n = this.getControlIndex(this.control_values, zoomControlBar);
        Object[] objectArray = this.control_values[n];
        this.barMoved(zoomControlBar, (Integer)objectArray[4]);
        Number number = (Number)((SDModifiableVariableRepresentation)objectArray[5]).getLastRequestedValue();
        zoomControlBar.setValue(number.doubleValue());
        zoomControlBar.getZoomSlider().updateIndicators();
        zoomControlBar.getZoomSlider().updateScale();
        this.redraw();
    }

    public void graphEdited(Graph graph) {
        int n;
        this.graph_values = this.config_editor.getValues();
        int n2 = this.getGraphIndex(this.graph_values, graph);
        Object[] objectArray = this.graph_values[n2];
        Color color = graph.getForeground();
        Color color2 = new Color((Device)this.getDisplay(), (RGB)objectArray[3]);
        this.disposables.add(color2);
        this.disposables.remove(color);
        graph.setForeground(color2);
        color.dispose();
        Integer n3 = (Integer)objectArray[4];
        graph.setLineWidth(n3);
        Integer n4 = (Integer)objectArray[5];
        graph.setLineStyle(n4);
        int n5 = (Integer)objectArray[6];
        if (n5 >= 0 && n5 < this.xsliders.size()) {
            graph.setXSlider((TimeZoomSlider)((Object)this.xsliders.get(n5)));
        }
        if ((n = ((Integer)objectArray[7]).intValue()) >= 0 && n < this.ysliders.size()) {
            graph.setYSlider((ZoomSlider)((Object)this.ysliders.get(n)));
        }
        double d = (Double)objectArray[8];
        graph.setStaticScaling(d);
        this.ne_panel.redraw();
        this.setDirty(true);
    }

    private BasicAction findAction(String string, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            BasicAction basicAction = (BasicAction)arrayList.get(n);
            if (basicAction.id.equals(string)) {
                return basicAction;
            }
            ++n;
        }
        return null;
    }

    public void addSliderAction(String string, String string2, Image image, Runnable runnable, boolean bl) {
        BasicAction basicAction;
        ArrayList arrayList = this.hslider_actions;
        if (!bl) {
            arrayList = this.vslider_actions;
        }
        if ((basicAction = this.findAction(string, arrayList)) == null) {
            basicAction = new BasicAction();
            arrayList.add(basicAction);
        }
        basicAction.id = string;
        basicAction.name = string2;
        basicAction.image = image;
        basicAction.runnable = runnable;
        basicAction.horizontal = bl;
    }

    public void removeSliderAction(String string) {
        BasicAction basicAction = this.findAction(string, this.hslider_actions);
        if (basicAction == null) {
            basicAction = this.findAction(string, this.vslider_actions);
        }
        if (basicAction != null) {
            basicAction.dispose();
            this.vslider_actions.remove(basicAction);
            this.hslider_actions.remove(basicAction);
        }
    }

    public ZoomSlider getSelectedSlider() {
        return this.selected_slider;
    }

    public double getSelectedSliderValue() {
        return this.selected_slider_value;
    }

    class SliderTitleValidator
    implements IInputValidator {
        SliderTitleValidator() {
        }

        public String isValid(String string) {
            if (string == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (string.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            return null;
        }
    }

    class SliderMaxValidator
    implements IInputValidator {
        ZoomSlider slider;

        public SliderMaxValidator(ZoomSlider zoomSlider) {
            this.slider = zoomSlider;
        }

        public String isValid(String string) {
            if (string == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (string.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            try {
                double d = Double.parseDouble(string);
                if (d <= this.slider.getMinLimit() + this.slider.getIncrement()) {
                    return EditorPlugin.getString("VALUE_TOO_SMALL") + " (" + (this.slider.getMinLimit() + this.slider.getIncrement()) + ")";
                }
            }
            catch (Throwable throwable) {
                return EditorPlugin.getString("NOT_A_VALID_NUMBER");
            }
            return null;
        }
    }

    class SliderMinValidator
    implements IInputValidator {
        ZoomSlider slider;

        public SliderMinValidator(ZoomSlider zoomSlider) {
            this.slider = zoomSlider;
        }

        public String isValid(String string) {
            if (string == null) {
                return EditorPlugin.getString("NULL_ARGUMENT");
            }
            if (string.length() == 0) {
                return EditorPlugin.getString("STRING_TOO_SHORT");
            }
            try {
                double d = Double.parseDouble(string);
                if (d >= this.slider.getMaxLimit() - this.slider.getIncrement()) {
                    return EditorPlugin.getString("VALUE_TOO_LARGE") + " (" + (this.slider.getMaxLimit() - this.slider.getIncrement()) + ")";
                }
            }
            catch (Throwable throwable) {
                return EditorPlugin.getString("NOT_A_VALID_NUMBER");
            }
            return null;
        }
    }

    class SliderPopupListener
    implements MouseListener,
    SelectionListener {
        boolean horizontal;
        ZoomSlider slider;
        Menu menu;
        MenuItem add_slider;
        MenuItem remove_slider;
        MenuItem title_slider;
        MenuItem maxlock_slider;
        MenuItem minlock_slider;
        MenuItem maximum_slider;
        MenuItem minimum_slider;
        MenuItem snap_slider;
        ArrayList menu_disposables = new ArrayList();
        int dx;

        public void dispose() {
            this.menu.dispose();
            this.add_slider.dispose();
            this.remove_slider.dispose();
            this.title_slider.dispose();
            this.maxlock_slider.dispose();
            this.minlock_slider.dispose();
            this.maximum_slider.dispose();
            this.minimum_slider.dispose();
            this.snap_slider.dispose();
        }

        public SliderPopupListener(ZoomSlider zoomSlider, boolean bl) {
            this.slider = zoomSlider;
            this.horizontal = bl;
            this.initMenu();
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.slider.addMouseListener(this);
            this.add_slider.addSelectionListener((SelectionListener)this);
            this.remove_slider.addSelectionListener((SelectionListener)this);
            this.title_slider.addSelectionListener((SelectionListener)this);
            this.maxlock_slider.addSelectionListener((SelectionListener)this);
            this.minlock_slider.addSelectionListener((SelectionListener)this);
            this.maximum_slider.addSelectionListener((SelectionListener)this);
            this.minimum_slider.addSelectionListener((SelectionListener)this);
            this.snap_slider.addSelectionListener((SelectionListener)this);
        }

        private void initMenu() {
            this.menu = new Menu((Control)this.slider);
            this.add_slider = new MenuItem(this.menu, 0);
            this.title_slider = new MenuItem(this.menu, 0);
            this.maxlock_slider = new MenuItem(this.menu, 0);
            this.minlock_slider = new MenuItem(this.menu, 0);
            this.maximum_slider = new MenuItem(this.menu, 0);
            this.minimum_slider = new MenuItem(this.menu, 0);
            this.remove_slider = new MenuItem(this.menu, 0);
            this.snap_slider = new MenuItem(this.menu, 0);
            this.initMenuText();
        }

        private void initMenuEnabled() {
            if (this.horizontal) {
                if (GraphWindow.this.getXSliderCount() <= 1) {
                    this.remove_slider.setEnabled(false);
                } else {
                    this.remove_slider.setEnabled(true);
                }
            } else if (GraphWindow.this.getYSliderCount() <= 1) {
                this.remove_slider.setEnabled(false);
            } else {
                this.remove_slider.setEnabled(true);
            }
        }

        private void initMenuText() {
            MenuItem menuItem;
            this.add_slider.setText(EditorPlugin.getString("ADD_SLIDER"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
            if (this.horizontal) {
                this.maximum_slider.setText(EditorPlugin.getString("SET_MAXIMUM") + " (" + simpleDateFormat.format(new Date((long)this.slider.getMaxLimit())) + ") (" + this.slider.getTitle() + ")");
                this.minimum_slider.setText(EditorPlugin.getString("SET_MINIMUM") + " (" + simpleDateFormat.format(new Date((long)this.slider.getMinLimit())) + ") (" + this.slider.getTitle() + ")");
            } else {
                this.maximum_slider.setText(EditorPlugin.getString("SET_MAXIMUM") + " (" + this.slider.getMaxLimit() + ") (" + this.slider.getTitle() + ")");
                this.minimum_slider.setText(EditorPlugin.getString("SET_MINIMUM") + " (" + this.slider.getMinLimit() + ") (" + this.slider.getTitle() + ")");
            }
            if (this.slider.isLocked(1)) {
                this.maxlock_slider.setText(EditorPlugin.getString("UNLOCK_SLIDER_MAX") + " (" + this.slider.getTitle() + ")");
            } else {
                this.maxlock_slider.setText(EditorPlugin.getString("LOCK_SLIDER_MAX") + " (" + this.slider.getTitle() + ")");
            }
            if (this.slider.isLocked(0)) {
                this.minlock_slider.setText(EditorPlugin.getString("UNLOCK_SLIDER_MIN") + " (" + this.slider.getTitle() + ")");
            } else {
                this.minlock_slider.setText(EditorPlugin.getString("LOCK_SLIDER_MIN") + " (" + this.slider.getTitle() + ")");
            }
            this.remove_slider.setText(EditorPlugin.getString("REMOVE_SLIDER") + " (" + this.slider.getTitle() + ")");
            this.title_slider.setText(EditorPlugin.getString("SET_TITLE") + " (" + this.slider.getTitle() + ")");
            this.snap_slider.setText(EditorPlugin.getString("SNAP_TO_ASSOCIATED_GRAPHS") + " (" + this.slider.getTitle() + ")");
            if (this.menu_disposables != null) {
                int n = 0;
                while (n < this.menu_disposables.size()) {
                    menuItem = (MenuItem)this.menu_disposables.get(n);
                    menuItem.dispose();
                    ++n;
                }
            }
            ArrayList arrayList = GraphWindow.this.hslider_actions;
            if (!this.horizontal) {
                arrayList = GraphWindow.this.vslider_actions;
            }
            if (arrayList.size() > 0) {
                menuItem = new MenuItem(this.menu, 2);
                this.menu_disposables.add(menuItem);
                int n = 0;
                while (n < arrayList.size()) {
                    BasicAction basicAction = (BasicAction)arrayList.get(n);
                    basicAction.menuitem = new MenuItem(this.menu, 0);
                    basicAction.menuitem.setText(basicAction.name);
                    basicAction.menuitem.setImage(basicAction.image);
                    basicAction.menuitem.addSelectionListener((SelectionListener)basicAction);
                    this.menu_disposables.add(basicAction.menuitem);
                    ++n;
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object = selectionEvent.getSource();
            if (object == this.add_slider) {
                if (this.horizontal) {
                    EditorPlugin.DBG.info("add a horizontal slider");
                    GraphWindow.this.addXSlider();
                } else {
                    EditorPlugin.DBG.info("add a vertical slider");
                    GraphWindow.this.addYSlider();
                }
                GraphWindow.this.setDirty(true);
            } else if (object == this.remove_slider) {
                if (this.horizontal) {
                    EditorPlugin.DBG.info("remove slider " + this.slider.getTitle());
                    GraphWindow.this.removeXSlider(this.slider);
                } else {
                    EditorPlugin.DBG.info("remove slider " + this.slider.getTitle());
                    GraphWindow.this.removeYSlider(this.slider);
                }
                GraphWindow.this.setDirty(true);
            } else if (object == this.snap_slider) {
                EditorPlugin.DBG.info("snap slider " + this.slider.getTitle());
                GraphWindow.this.snapSlider(this.slider);
                GraphWindow.this.setDirty(true);
            } else if (object == this.title_slider) {
                EditorPlugin.DBG.info("set slider " + this.slider.getTitle() + " title");
                InputDialog inputDialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_TITLE"), EditorPlugin.getString("SLIDER_TITLE_REQUEST") + ":", this.slider.getTitle(), (IInputValidator)new SliderTitleValidator());
                inputDialog.open();
                String string = inputDialog.getValue();
                if (string != null) {
                    this.slider.setTitle(string);
                    GraphWindow.this.updateSliders();
                    GraphWindow.this.setDirty(true);
                }
                inputDialog.close();
                this.slider.redraw();
            } else if (object == this.maxlock_slider) {
                EditorPlugin.DBG.info("(un)lock max of slider " + this.slider.getTitle());
                this.slider.lock(1, !this.slider.isLocked(1));
                GraphWindow.this.setDirty(true);
            } else if (object == this.minlock_slider) {
                EditorPlugin.DBG.info("(un)lock in of slider " + this.slider.getTitle());
                this.slider.lock(0, !this.slider.isLocked(0));
                GraphWindow.this.setDirty(true);
            } else if (object == this.maximum_slider) {
                EditorPlugin.DBG.info("set maximum for slider " + this.slider.getTitle());
                double d = 0.0;
                try {
                    DateDialog dateDialog;
                    if (this.horizontal) {
                        dateDialog = new DateDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_TIME_SLIDER_MAX"));
                        dateDialog.setDate((long)this.slider.getMaxLimit());
                        d = ((Long)dateDialog.open()).doubleValue();
                    } else {
                        dateDialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_MAX"), EditorPlugin.getString("NEW_SLIDER_MAXIMUM") + ":", "" + this.slider.getMaxLimit(), (IInputValidator)new SliderMaxValidator(this.slider));
                        dateDialog.open();
                        d = Double.parseDouble(dateDialog.getValue());
                    }
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.warning("problem getting slider configuration", throwable);
                    return;
                }
                try {
                    double d2 = d;
                    double d3 = this.slider.getMinLimit();
                    double d4 = d2;
                    double d5 = this.slider.getMinVisible();
                    double d6 = Math.min(d2, this.slider.getMaxVisible());
                    double d7 = this.slider.getResolution();
                    this.slider.configure(d3, d4, d5, d6, d7);
                    GraphWindow.this.setDirty(true);
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.warning("problem setting slider configuration", throwable);
                }
                this.slider.redraw();
            } else if (object == this.minimum_slider) {
                EditorPlugin.DBG.info("set minimum for slider " + this.slider.getTitle());
                double d = 0.0;
                try {
                    DateDialog dateDialog;
                    if (this.horizontal) {
                        dateDialog = new DateDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_TIME_SLIDER_MIN"));
                        dateDialog.setDate((long)this.slider.getMinLimit());
                        d = ((Long)dateDialog.open()).doubleValue();
                    } else {
                        dateDialog = new InputDialog(GraphWindow.this.getShell(), EditorPlugin.getString("SET_SLIDER_MIN"), EditorPlugin.getString("NEW_SLIDER_MINIMUM") + ":", "" + this.slider.getMinLimit(), (IInputValidator)new SliderMinValidator(this.slider));
                        dateDialog.open();
                        d = Double.parseDouble(dateDialog.getValue());
                    }
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.warning("problem getting slider configuration", throwable);
                    return;
                }
                try {
                    double d8 = d;
                    double d9 = this.slider.getMinLimit();
                    double d10 = this.slider.getMaxLimit();
                    double d11 = Math.max(d8, this.slider.getMinVisible());
                    double d12 = this.slider.getMaxVisible();
                    double d13 = this.slider.getResolution();
                    double d14 = d8 - d9;
                    this.slider.configure(d8, d10, d11, d12, d13);
                    GraphWindow.this.setDirty(true);
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.warning("problem setting slider configuration", throwable);
                }
                this.slider.redraw();
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            GraphWindow.this.setDirty(true);
            this.dx = mouseEvent.x;
            if (this.horizontal) {
                GraphWindow.this.ref_min_graph.setXSlider((TimeZoomSlider)this.slider);
                GraphWindow.this.ref_maj_graph.setXSlider((TimeZoomSlider)this.slider);
            } else {
                GraphWindow.this.ref_min_graph.setYSlider(this.slider);
                GraphWindow.this.ref_maj_graph.setYSlider(this.slider);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseUp(MouseEvent mouseEvent) {
            GraphWindow.this.setDirty(true);
            if (this.dx < mouseEvent.x) {
                // empty if block
            }
            if (this.horizontal) {
                GraphWindow.this.ref_min_graph.setXSlider((TimeZoomSlider)this.slider);
                GraphWindow.this.ref_maj_graph.setXSlider((TimeZoomSlider)this.slider);
                if (this.dx == mouseEvent.x && mouseEvent.button <= 1) {
                    GraphWindow.this.indicator_graph.setXSlider((TimeZoomSlider)this.slider);
                    Button button = (Button)GraphWindow.this.button_map.get((Object)this.slider);
                    if (button != null && GraphWindow.this.update_thread != null) {
                        if (button.getSelection() && GraphWindow.this.update_thread.isAlive()) {
                            GraphWindow.this.indicator_graph.setIndicatorLocation(Double.MAX_VALUE);
                        } else {
                            GraphWindow.this.indicator_graph.setIndicatorLocation(mouseEvent.x);
                        }
                    } else {
                        GraphWindow.this.indicator_graph.setIndicatorLocation(mouseEvent.x);
                    }
                }
            } else {
                GraphWindow.this.ref_min_graph.setYSlider(this.slider);
                GraphWindow.this.ref_maj_graph.setYSlider(this.slider);
            }
            if (mouseEvent.button > 1 && this.dx == mouseEvent.x) {
                this.initMenuEnabled();
                this.initMenuText();
                GraphWindow.this.selected_slider = (ZoomSlider)mouseEvent.widget;
                GraphWindow.this.selected_slider_value = this.horizontal ? GraphWindow.this.selected_slider.pixel2Value(mouseEvent.x) : GraphWindow.this.selected_slider.pixel2Value(mouseEvent.y);
                this.menu.setVisible(true);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    }

    class BasicAction
    implements SelectionListener {
        String id = "unknown";
        String name;
        Runnable runnable;
        MenuItem menuitem;
        Image image;
        boolean horizontal;

        BasicAction() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.runnable.run();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.runnable.run();
        }
    }

    class CSVExport
    implements IRunnableWithProgress {
        String file;
        long avg;
        long start;
        long finish;

        public CSVExport(String string, long l, long l2, long l3) {
            this.file = string;
            this.avg = l;
            this.start = l2;
            this.finish = l3;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            try {
                iProgressMonitor.beginTask(EditorPlugin.getString("BUILDING_HEADER"), GraphWindow.this.graph_values.length);
                OutputStream outputStream = new FileOutputStream(this.file);
                outputStream = new BufferedOutputStream(outputStream);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd/MMMM/yyyy");
                ColumnPrinter columnPrinter = new ColumnPrinter();
                columnPrinter.setCellPrefix("\"");
                columnPrinter.setCellPostfix("\",");
                int n = 0;
                int n2 = 1;
                int n3 = 2;
                columnPrinter.setHeaderText(n, 0, "Date");
                columnPrinter.setHeaderText(n2, 0, "Time");
                int n4 = 0;
                while (n4 < GraphWindow.this.graph_values.length) {
                    int n5 = 0;
                    columnPrinter.setHeaderText(n3, n5++, "Description: " + GraphWindow.this.graph_values[n4][2]);
                    columnPrinter.setHeaderText(n3, n5++, (String)GraphWindow.this.graph_values[n4][1]);
                    SDDescriptor sDDescriptor = (SDDescriptor)GraphWindow.this.graph_values[n4][9];
                    while (sDDescriptor != null) {
                        if ((sDDescriptor = sDDescriptor.getParent()) == null) continue;
                        columnPrinter.setHeaderText(n3, n5++, sDDescriptor.getName());
                    }
                    ++n3;
                    iProgressMonitor.worked(1);
                    ++n4;
                }
                String string = columnPrinter.toString();
                outputStream.write(string.getBytes());
                EditorPlugin.DBG.info("Wrote headers OK");
                int n6 = (int)(this.finish - this.start);
                int n7 = 0;
                iProgressMonitor.beginTask(EditorPlugin.getString("EXPORTING_DATA"), n6);
                long l = this.start;
                while (l < this.finish) {
                    if ((n7 = (int)((long)n7 + this.avg)) > n6 / 500) {
                        iProgressMonitor.worked(n7);
                        n7 = 0;
                    }
                    outputStream.write("\"".getBytes());
                    outputStream.write(simpleDateFormat2.format(new Date(l)).getBytes());
                    outputStream.write("\",".getBytes());
                    outputStream.write("\"".getBytes());
                    outputStream.write(simpleDateFormat.format(new Date(l)).getBytes());
                    outputStream.write("\",".getBytes());
                    int n8 = 0;
                    while (n8 < GraphWindow.this.graph_values.length) {
                        String string2;
                        BasicGraphSource basicGraphSource;
                        Graph graph = (Graph)GraphWindow.this.graph_values[n8][0];
                        BasicGraphSource basicGraphSource2 = graph.getGraphSource();
                        if (basicGraphSource2 instanceof GraphSource) {
                            basicGraphSource = (GraphSource)basicGraphSource2;
                            string2 = Double.toString(basicGraphSource.getAverageBetween(l, l + this.avg));
                        } else if (basicGraphSource2 instanceof EnumerationGraphSource) {
                            basicGraphSource = (EnumerationGraphSource)basicGraphSource2;
                            string2 = basicGraphSource.getValueAt(l).toString();
                        } else {
                            string2 = "error - " + basicGraphSource2.getClass();
                        }
                        outputStream.write("\"".getBytes());
                        outputStream.write(string2.getBytes());
                        outputStream.write("\",".getBytes());
                        ++n8;
                    }
                    outputStream.write(10);
                    l += this.avg;
                }
                iProgressMonitor.done();
                EditorPlugin.DBG.info("Wrote data OK");
                outputStream.close();
            }
            catch (IOException iOException) {
                EditorPlugin.DBG.error(EditorPlugin.getString("ERROR_CSV_EXPORT_FILE"), iOException);
                EditorPlugin.DBG.logVisibleError(iOException, EditorPlugin.getString("ERROR_CSV_EXPORT_FILE"), true);
            }
        }
    }

    class GraphPopupListener
    implements MouseListener,
    SelectionListener {
        Menu menu;
        MenuItem set_color;
        MenuItem default_color;
        MenuItem match_color;
        MenuItem msep;
        MenuItem export_csv;
        GraphCanvas graph_canvas;

        public void dispose() {
            this.menu.dispose();
            this.set_color.dispose();
            this.default_color.dispose();
            this.export_csv.dispose();
            this.msep.dispose();
            this.match_color.dispose();
        }

        public GraphPopupListener(GraphCanvas graphCanvas) {
            this.graph_canvas = graphCanvas;
            this.initMenu();
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.graph_canvas.addMouseListener(this);
            this.set_color.addSelectionListener((SelectionListener)this);
            this.default_color.addSelectionListener((SelectionListener)this);
            this.export_csv.addSelectionListener((SelectionListener)this);
            this.match_color.addSelectionListener((SelectionListener)this);
        }

        private void initMenu() {
            this.menu = new Menu((Control)this.graph_canvas);
            this.set_color = new MenuItem(this.menu, 0);
            this.default_color = new MenuItem(this.menu, 0);
            this.match_color = new MenuItem(this.menu, 0);
            this.msep = new MenuItem(this.menu, 2);
            this.export_csv = new MenuItem(this.menu, 0);
            this.initMenuText();
        }

        private void initMenuText() {
            this.export_csv.setText(EditorPlugin.getString("EXPORT_GRAPHS_CSV"));
            this.set_color.setText(EditorPlugin.getString("MENUITEM_SET_GRAPH_BACKGROUND_COLOR"));
            this.default_color.setText(EditorPlugin.getString("MENUITEM_DEFAULT_GRAPH_BACKGROUND_COLOR"));
            if (GraphWindow.this.getSlidersMatchGraph()) {
                this.match_color.setText(EditorPlugin.getString("MENUITEM_SEPARATE_SLIDERS_FROM_GRAPH"));
            } else {
                this.match_color.setText(EditorPlugin.getString("MENUITEM_MATCH_SLIDERS_TO_GRAPH"));
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            block8: {
                Object object;
                block10: {
                    block9: {
                        block7: {
                            object = selectionEvent.getSource();
                            if (object != this.set_color) break block7;
                            EditorPlugin.DBG.info("set graph background colour");
                            ColorDialog colorDialog = new ColorDialog(this.graph_canvas.getShell());
                            colorDialog.setRGB(this.graph_canvas.getBackground().getRGB());
                            RGB rGB = colorDialog.open();
                            if (rGB == null) break block8;
                            GraphWindow.this.setGraphBackground(rGB);
                            break block8;
                        }
                        if (object != this.default_color) break block9;
                        EditorPlugin.DBG.info("default graph background colour");
                        GraphWindow.this.setGraphBackground(GraphWindow.this.getDisplay().getSystemColor(25));
                        break block8;
                    }
                    if (object != this.match_color) break block10;
                    EditorPlugin.DBG.info("separate / match sliders to graph");
                    GraphWindow.this.setSlidersMatchGraph(!GraphWindow.this.getSlidersMatchGraph());
                    GraphWindow.this.updateSliderColors();
                    GraphWindow.this.setDirty(true);
                    break block8;
                }
                if (object != this.export_csv) break block8;
                TimeZoomSlider timeZoomSlider = GraphWindow.this.getXSlider(0);
                ExportTimeDialog exportTimeDialog = new ExportTimeDialog(GraphWindow.this.getShell(), (long)timeZoomSlider.getIncrement(), (long)timeZoomSlider.getMinVisible(), (long)timeZoomSlider.getMaxVisible());
                if (exportTimeDialog.open() == 0) {
                    long l = exportTimeDialog.getAveragePeriodMS();
                    long l2 = exportTimeDialog.getStartTime();
                    long l3 = exportTimeDialog.getMaxTime();
                    FileDialog fileDialog = new FileDialog(GraphWindow.this.getShell(), 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.csv"});
                    fileDialog.setFilterNames(new String[]{"Comma Separated Values (*.csv)"});
                    String string = fileDialog.open();
                    if (string != null) {
                        ProgressMonitorDialog progressMonitorDialog;
                        File file;
                        if (string.indexOf(46) == -1) {
                            string = string + ".csv";
                        }
                        if ((file = new File(string)) != null && file.exists()) {
                            progressMonitorDialog = new MessageBox(GraphWindow.this.getShell(), 200);
                            progressMonitorDialog.setText(EditorPlugin.getString("FILE_EXISTS"));
                            progressMonitorDialog.setMessage(EditorPlugin.getString("FILE_EXISTS_MSG"));
                            if (progressMonitorDialog.open() != 64) {
                                return;
                            }
                        }
                        progressMonitorDialog = new ProgressMonitorDialog(GraphWindow.this.getShell());
                        progressMonitorDialog.setCancelable(false);
                        try {
                            progressMonitorDialog.run(true, false, (IRunnableWithProgress)new CSVExport(string, l, l2, l3));
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.logVisibleError(throwable, EditorPlugin.getString("ERROR_CSV_EXPORT_DIALOG"), false);
                        }
                    }
                }
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button > 1) {
                this.initMenuText();
                this.menu.setVisible(true);
            }
            GraphWindow.this.ne_panel.redraw();
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    }

    public class UpdateThread
    extends Thread {
        public void run() {
            GraphCanvasUpdate graphCanvasUpdate = new GraphCanvasUpdate();
            EditorPlugin.DBG.info("Graph Canvas Update - starting updates");
            while (GraphWindow.this.constant_update) {
                try {
                    Thread.sleep(GraphWindow.this.constant_update_ms);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!GraphWindow.this.constant_update) break;
                if (!GraphWindow.this.isDisposed() && !GraphWindow.this.getDisplay().isDisposed()) {
                    GraphWindow.this.getDisplay().syncExec((Runnable)graphCanvasUpdate);
                }
                int n = 0;
                while (n < GraphWindow.this.update_runnables.size()) {
                    try {
                        Runnable runnable = (Runnable)GraphWindow.this.update_runnables.get(n);
                        GraphWindow.this.getDisplay().syncExec(runnable);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            EditorPlugin.DBG.info("Graph Canvas Update - stopping updates");
        }
    }

    public class GraphCanvasUpdate
    extends Thread {
        public void run() {
            try {
                int n = 0;
                while (n < GraphWindow.this.xsliders.size()) {
                    TimeZoomSlider timeZoomSlider = (TimeZoomSlider)((Object)GraphWindow.this.xsliders.get(n));
                    Button button = (Button)GraphWindow.this.button_map.get((Object)timeZoomSlider);
                    if (button != null && button.getSelection()) {
                        GraphWindow.this.jumpToNow(timeZoomSlider);
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.warning("Graph Canvas Update - problem updating", throwable);
            }
            try {
                GraphWindow.this.ne_panel.redraw();
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.warning("Graph Canvas Update - problem redrawing", throwable);
            }
        }
    }
}

