/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.CheckboxTreeAndListGroup;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;

public class StatisticalModelGraphEditorWizard
extends HyadesWizard
implements INewWizard {
    LocationPage location_page;
    ResourceSelectionPage select_page;
    ModulePage[] module_pages;

    public void initPages() {
        EditorPlugin.DBG.info("initialising pages");
        IStructuredSelection iStructuredSelection = this.getSelection();
        this.location_page = new LocationPage("location", iStructuredSelection);
        this.location_page.setTitle(EditorPlugin.getString("CREATE_NEW_STATCON_FILE"));
        this.location_page.setDescription(EditorPlugin.getString("CREATE_NEW_STATCON_FILE_DESC"));
        this.location_page.setFileExtension("statcon");
        this.location_page.setFileName("newfile.statcon");
    }

    public void addPages() {
        EditorPlugin.DBG.info("adding pages");
        this.addPage((IWizardPage)this.location_page);
        this.select_page = new ResourceSelectionPage(EditorPlugin.getString("CHOOSE_MODELS_TO_GRAPH"), new String[]{"trcmxmi", "trcnxmi", "trcpxmi", "trcaxmi"}, EditorPlugin.getString("CHOOSE_MODELS_TO_GRAPH_DESC"));
        this.addPage((IWizardPage)this.select_page);
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConFile");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        this.module_pages = new ModulePage[iExtensionArray.length];
        EditorPlugin.DBG.info("found " + this.module_pages + " module pages");
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            IPluginDescriptor iPluginDescriptor = iExtensionArray[n].getDeclaringPluginDescriptor();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n2].getAttribute("file_extension");
                String string2 = iConfigurationElementArray[n2].getAttribute("element_name");
                String string3 = iConfigurationElementArray[n2].getAttribute("path_attribute");
                String string4 = iConfigurationElementArray[n2].getAttribute("page_title");
                String string5 = iConfigurationElementArray[n2].getAttribute("page_description");
                EditorPlugin.DBG.info("added module page for " + string + " files");
                ModulePage modulePage = new ModulePage();
                modulePage.element = string2;
                modulePage.attribute = string3;
                modulePage.page = new ResourceSelectionPage(string4, new String[]{string}, string5);
                this.addPage((IWizardPage)modulePage.page);
                this.module_pages[n] = modulePage;
                ++n2;
            }
            ++n;
        }
    }

    public boolean performFinish() {
        Object object;
        EditorPlugin.DBG.info("finish - creating new StatCon file");
        IFile iFile = this.location_page.createNewFile();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<!-- Statistical Model Graph Viewer configuration file -->\n");
        stringBuffer.append("<!-- Not intended to be human editable - edit at your own risk -->\n");
        stringBuffer.append("<smgconfig>\n");
        ArrayList arrayList = this.select_page.getSelectedFiles();
        int n = 0;
        while (n < arrayList.size()) {
            IFile iFile2 = (IFile)arrayList.get(n);
            object = URI.createPlatformResourceURI((String)iFile2.getFullPath().toString());
            stringBuffer.append("  <model file=\"").append(object).append("\" />\n");
            ++n;
        }
        int n2 = 0;
        while (n2 < this.module_pages.length) {
            if (this.module_pages[n2] != null) {
                object = this.module_pages[n2].page.getSelectedFiles();
                int n3 = 0;
                while (n3 < ((ArrayList)object).size()) {
                    IFile iFile3 = (IFile)((ArrayList)object).get(n3);
                    URI uRI = URI.createPlatformResourceURI((String)iFile3.getFullPath().toString());
                    stringBuffer.append("  <");
                    stringBuffer.append(this.module_pages[n2].element);
                    stringBuffer.append(" ");
                    stringBuffer.append(this.module_pages[n2].attribute);
                    stringBuffer.append("=\"");
                    stringBuffer.append(uRI);
                    stringBuffer.append("\" />\n");
                    ++n3;
                }
            }
            ++n2;
        }
        stringBuffer.append("</smgconfig>\n");
        object = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        try {
            EditorPlugin.DBG.info("trying to set file contents");
            iFile.setContents((InputStream)object, true, false, null);
        }
        catch (Exception exception) {
            EditorPlugin.DBG.error("unable to set file contents", exception);
            return false;
        }
        StatisticalModelGraphEditorWizard.openEditor(iFile, null, false);
        return true;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchPage iWorkbenchPage = null;
        if (iWorkbench.getActiveWorkbenchWindow() != null) {
            iWorkbenchPage = iWorkbench.getActiveWorkbenchWindow().getActivePage();
        } else if (iWorkbench.getWorkbenchWindows().length > 0) {
            iWorkbenchPage = iWorkbench.getWorkbenchWindows()[0].getActivePage();
        }
        return iWorkbenchPage;
    }

    public static IEditorPart openEditor(IFile iFile, String string, boolean bl) {
        block8: {
            if (iFile == null) {
                return null;
            }
            IWorkbenchPage iWorkbenchPage = StatisticalModelGraphEditorWizard.getActiveWorkbenchPage();
            if (iWorkbenchPage == null) {
                return null;
            }
            if ("".equals(string)) {
                string = null;
            }
            try {
                if (string == null) {
                    return IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IEditorDescriptor[] iEditorDescriptorArray = iWorkbench.getEditorRegistry().getEditors(iFile.getName());
                if (iEditorDescriptorArray == null) break block8;
                boolean bl2 = false;
                int n = 0;
                int n2 = iEditorDescriptorArray.length;
                while (n < n2) {
                    bl2 = bl ? iEditorDescriptorArray[n].getId().startsWith(string) : string.equals(iEditorDescriptorArray[n].getId());
                    if (bl2) {
                        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptorArray[n].getId());
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                EditorPlugin.DBG.error("couldnt open editor", exception);
                EditorPlugin.DBG.logVisibleError(exception, EditorPlugin.getString("ERROR_OPEN_STATCON"), false);
            }
        }
        return null;
    }

    public class SMGFileProvider
    extends WorkbenchContentProvider {
        String[] extensions;

        public SMGFileProvider(String[] stringArray) {
            this.extensions = stringArray;
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IContainer) {
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = ((IContainer)object).members();
                }
                catch (CoreException coreException) {
                    return new Object[0];
                }
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                int n = 0;
                while (n < iResourceArray.length) {
                    if ((iResourceArray[n].getType() & 1) > 0) {
                        String string = iResourceArray[n].getName();
                        string = string.substring(string.lastIndexOf(".") + 1);
                        int n2 = 0;
                        while (n2 < this.extensions.length) {
                            if (string.equalsIgnoreCase(this.extensions[n2])) {
                                arrayList.add(iResourceArray[n]);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
            if (object instanceof ArrayList) {
                return ((ArrayList)object).toArray();
            }
            return new Object[0];
        }
    }

    public class FolderProvider
    extends WorkbenchContentProvider {
        public Object[] getChildren(Object object) {
            int n = 14;
            if (object instanceof IContainer) {
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = ((IContainer)object).members();
                }
                catch (CoreException coreException) {
                    return new Object[0];
                }
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    if ((iResourceArray[n2].getType() & n) > 0) {
                        arrayList.add(iResourceArray[n2]);
                    }
                    ++n2;
                }
                return arrayList.toArray();
            }
            if (object instanceof ArrayList) {
                return ((ArrayList)object).toArray();
            }
            return new Object[0];
        }
    }

    public class ResourceSelectionPage
    extends WizardPage {
        private IAdaptable root;
        private CheckboxTreeAndListGroup main_widget;
        private Control page_control;
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
        String[] extensions;

        public Control getControl() {
            return this.page_control;
        }

        public ResourceSelectionPage(String string, String[] stringArray, String string2) {
            super(string);
            this.setTitle(string);
            this.setDescription(string2);
            this.extensions = stringArray;
            this.root = ResourcesPlugin.getWorkspace().getRoot();
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new FillLayout());
            ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>();
            arrayList.add(this.root);
            this.main_widget = new CheckboxTreeAndListGroup(composite2, arrayList, (ITreeContentProvider)new FolderProvider(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)new SMGFileProvider(this.extensions), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
            composite2.addControlListener(new ControlListener(this){
                private final /* synthetic */ ResourceSelectionPage this$1;
                {
                    this.this$1 = resourceSelectionPage;
                }

                public void controlMoved(ControlEvent controlEvent) {
                }

                public void controlResized(ControlEvent controlEvent) {
                    TableColumn[] tableColumnArray = ResourceSelectionPage.access$000(this.this$1).getListTable().getColumns();
                    int n = 0;
                    while (n < tableColumnArray.length) {
                        tableColumnArray[n].pack();
                        ++n;
                    }
                }
            });
            this.page_control = composite2;
            this.setControl(this.page_control);
        }

        public ArrayList getSelectedFiles() {
            Iterator iterator = this.main_widget.getAllCheckedListItems();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }

        static /* synthetic */ CheckboxTreeAndListGroup access$000(ResourceSelectionPage resourceSelectionPage) {
            return resourceSelectionPage.main_widget;
        }
    }

    class ModulePage {
        ResourceSelectionPage page;
        String element;
        String attribute;

        ModulePage() {
        }
    }
}

