/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.ui.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.CompilerFactory;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ui.ProbekitUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

class DefaultProbeCompileObjectActionDelegate
implements IObjectActionDelegate {
    List selectedFileList;

    DefaultProbeCompileObjectActionDelegate() {
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        Shell shell = new Shell();
        try {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DefaultProbeCompileObjectActionDelegate.this.runWithProgress(iProgressMonitor);
                    }
                    catch (Throwable throwable) {
                        throw new InvocationTargetException(throwable);
                    }
                }
            };
            new ProgressMonitorDialog(shell).run(true, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof ProbekitCompileProblemException)) {
                throw new Error(invocationTargetException);
            }
        }
        catch (InterruptedException interruptedException) {
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(true);
        iAction.setChecked(false);
        this.selectedFileList = new LinkedList();
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                IFile iFile;
                Object e = iterator.next();
                if (!(e instanceof IFile) || !(iFile = (IFile)e).getName().endsWith(".probe")) continue;
                this.selectedFileList.add(iFile);
            }
        }
    }

    private void reportError(String string, IResource iResource) {
        try {
            IMarker iMarker = iResource.createMarker("org.eclipse.hyades.probekit.probekitProblem");
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, "com.ibm.rational.pd.probekit", 0, ProbekitUI.getResourceString("UI.InternalError"), null);
            ProbekitUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void removeProbekitMarkers(IResource iResource) {
        try {
            iResource.deleteMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 0);
        }
        catch (CoreException coreException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithProgress(IProgressMonitor iProgressMonitor) throws Throwable {
        block15: {
            block13: {
                iProgressMonitor.beginTask(ProbekitUI.getResourceString("UI.Compiling"), 3);
                IFile iFile = null;
                try {
                    try {
                        IProbeCompiler iProbeCompiler;
                        String string;
                        block14: {
                            ByteArrayInputStream byteArrayInputStream;
                            IFile iFile2;
                            block17: {
                                block16: {
                                    if (this.selectedFileList == null) break block16;
                                    if (this.selectedFileList.size() != 0) break block17;
                                }
                                Object var14_3 = null;
                                break block13;
                            }
                            iFile = (IFile)this.selectedFileList.get(0);
                            this.removeProbekitMarkers((IResource)iFile);
                            string = this.getBaseName(iFile.getName());
                            iProbeCompiler = CompilerFactory.INSTANCE.createCompiler();
                            string = iProbeCompiler.makeValidJavaIdentifier(string);
                            iProbeCompiler.setClassPrefix(string);
                            Iterator iterator = this.selectedFileList.iterator();
                            while (true) {
                                Object object;
                                if (!iterator.hasNext()) {
                                    iProgressMonitor.subTask(ProbekitUI.getResourceString("UI.Generating"));
                                    iProgressMonitor.worked(1);
                                    object = iProbeCompiler.getGeneratedSource();
                                    iProgressMonitor.subTask(ProbekitUI.getResourceString("UI.SavingJava"));
                                    iProgressMonitor.worked(1);
                                    String string2 = iProbeCompiler.getClassSuffix();
                                    iFile2 = iFile.getParent().getFile((IPath)new Path(string + string2 + ".java"));
                                    byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                                    if (!iFile2.exists()) break;
                                    iFile2.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
                                    break block14;
                                }
                                object = (IFile)iterator.next();
                                this.removeProbekitMarkers((IResource)object);
                                iProbeCompiler.addIFile((IFile)object);
                            }
                            iFile2.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
                        }
                        iProgressMonitor.subTask(ProbekitUI.getResourceString("UI.SavingEngineScript"));
                        iProgressMonitor.worked(1);
                        String string3 = iProbeCompiler.getEngineScript();
                        IFile iFile3 = iFile.getParent().getFile((IPath)new Path(string + ".probescript"));
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
                        if (iFile3.exists()) {
                            iFile3.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
                            break block15;
                        } else {
                            iFile3.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
                        }
                        break block15;
                    }
                    catch (ProbekitCompileProblemException probekitCompileProblemException) {
                        Object var14_5 = null;
                        iProgressMonitor.done();
                        return;
                    }
                    catch (Exception exception) {
                        if (iFile != null) {
                            this.reportError(ProbekitUI.getResourceString("UI.InternalError"), (IResource)iFile);
                        }
                        Status status = new Status(4, "com.ibm.rational.pd.probekit", 0, ProbekitUI.getResourceString("UI.InternalError"), (Throwable)exception);
                        ProbekitUI.getDefault().getLog().log((IStatus)status);
                        Object var14_6 = null;
                        iProgressMonitor.done();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_7 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var14_4 = null;
        iProgressMonitor.done();
    }

    private String getBaseName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }
}

