/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.preferences;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LogInteractionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Text txtPageSize;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(SDLogcPlugin.getString("PAGE_SIZE_NOTE"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 375;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        label2.setLayoutData((Object)gridData);
        Label label3 = new Label(composite2, 0);
        label3.setText(SDLogcPlugin.getString("STR_PAGE_SIZE"));
        this.txtPageSize = new Text(composite2, 2048);
        this.txtPageSize.setTextLimit(5);
        gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(7);
        this.txtPageSize.setLayoutData((Object)gridData);
        this.txtPageSize.setText(this.getPreferenceStore().getString("page_size"));
        this.txtPageSize.addModifyListener((ModifyListener)this);
        return composite2;
    }

    public IPreferenceStore getPreferenceStore() {
        return SDLogcPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        this.txtPageSize.setText(this.getPreferenceStore().getDefaultString("page_size"));
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        IUml2SDLoader iUml2SDLoader = LoadersManager.getLoadersManager().getCurrentLoader();
        if (iUml2SDLoader instanceof ILogInteractionsPreferenceListener) {
            ((ILogInteractionsPreferenceListener)iUml2SDLoader).applyPreferences();
        }
        return true;
    }

    private void storeValues() {
        this.getPreferenceStore().setValue("page_size", this.txtPageSize.getText());
    }

    public void modifyText(ModifyEvent modifyEvent) {
        IStatus iStatus = this.validateInput();
        this.setValid(iStatus.getSeverity() == 0);
        if (iStatus.getSeverity() == 4) {
            this.setErrorMessage(iStatus.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    private IStatus validateInput() {
        String string = this.txtPageSize.getText();
        PreferenceStatus preferenceStatus = new PreferenceStatus();
        if (string.length() == 0) {
            preferenceStatus.setMessage(SDLogcPlugin.getString("EMPTY_FIELD_MSG"));
            preferenceStatus.setSeverity(4);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n <= 0) {
                    preferenceStatus.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"), string));
                    preferenceStatus.setSeverity(4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                preferenceStatus.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"), string));
                preferenceStatus.setSeverity(4);
            }
        }
        return preferenceStatus;
    }

    class PreferenceStatus
    extends Status {
        public PreferenceStatus() {
            super(0, "hyades.sd.logc", 0, "", null);
        }

        protected void setMessage(String string) {
            super.setMessage(string);
        }

        protected void setSeverity(int n) {
            super.setSeverity(n);
        }
    }
}

