/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions;

import java.net.URL;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class Zoom
implements IViewActionDelegate {
    protected SDWidget viewer = null;
    protected SDView view = null;
    protected boolean lastZoomIn = false;
    protected boolean lastZoomOut = false;
    private static Cursor zoomIn = null;
    private static Cursor zoomOut = null;
    private static URL BASIC_URL = null;

    public void init(IViewPart iViewPart) {
        this.view = (SDView)iViewPart;
        if (this.view instanceof SDView) {
            this.viewer = this.view.getSDWidget();
        }
        if (zoomIn != null && !zoomIn.isDisposed()) {
            zoomIn.dispose();
        }
        if (zoomOut != null && !zoomOut.isDisposed()) {
            zoomOut.dispose();
        }
        zoomIn = new Cursor((Device)Display.getCurrent(), this.getImageData("zoomin_source.bmp").getImageData(), this.getImageData("zoom_mask.bmp").getImageData(), 0, 0);
        zoomOut = new Cursor((Device)Display.getCurrent(), this.getImageData("zoomout_source.bmp").getImageData(), this.getImageData("zoom_mask.bmp").getImageData(), 0, 0);
    }

    public void run(IAction iAction) {
        if (iAction.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomOutCoolBar")) {
            if (this.lastZoomOut == iAction.isChecked()) {
                iAction.setChecked(!iAction.isChecked());
            }
            this.viewer.setZoomOutMode(iAction.isChecked());
            this.lastZoomOut = iAction.isChecked();
            if (iAction.isChecked()) {
                this.viewer.setCursor(zoomOut);
            } else {
                this.viewer.setCursor(new Cursor((Device)Display.getDefault(), 0));
            }
        } else if (iAction.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomInCoolBar")) {
            if (this.lastZoomIn == iAction.isChecked()) {
                iAction.setChecked(!iAction.isChecked());
            }
            this.viewer.setZoomInMode(iAction.isChecked());
            this.lastZoomIn = iAction.isChecked();
            if (iAction.isChecked()) {
                this.viewer.setCursor(zoomIn);
            } else {
                this.viewer.setCursor(new Cursor((Device)Display.getDefault(), 0));
            }
        } else if (iAction.getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ResetZoom")) {
            this.viewer.resetZoomFactor();
            iAction.setChecked(false);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public ImageDescriptor getImageData(String string) {
        try {
            URL uRL = new URL(BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/" + string);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return imageDescriptor;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    static {
        try {
            BASIC_URL = new URL("platform", "localhost", "plugin");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

