/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class FilterListDialog
extends Dialog {
    private IViewPart viewer = null;
    private ISDFilterProvider provider = null;
    private ArrayList filters;
    private Button add;
    private Button remove;
    private Button edit;
    private Table table;

    private void addCriteria(Criteria criteria, boolean bl) {
        CriteriaTableItem criteriaTableItem = new CriteriaTableItem(this.table, bl);
        criteriaTableItem.setCriteria(criteria);
    }

    private void replaceSelectedCriteria(Criteria criteria) {
        CriteriaTableItem criteriaTableItem = (CriteriaTableItem)this.table.getSelection()[0].getData();
        criteriaTableItem.setCriteria(criteria);
    }

    private void handleTableSelectionCount() {
        int n = this.table.getSelectionCount();
        this.edit.setEnabled(n == 1);
        this.remove.setEnabled(n > 0);
    }

    public Control createDialogArea(Composite composite) {
        Object object;
        Composite composite2;
        Group group = new Group(composite, 0);
        group.setText(SDViewerPlugin.getResourceString("FILTER_LIST_GROUP_TITLE"));
        WorkbenchHelp.setHelp((Control)group, (String)(SDViewerPlugin.getId() + ".UML2SDFILTER"));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        rowLayout.marginLeft = 4;
        rowLayout.marginTop = 4;
        rowLayout.marginRight = 4;
        rowLayout.marginBottom = 4;
        rowLayout.spacing = 8;
        group.setLayout((Layout)rowLayout);
        this.table = new Table((Composite)group, 34);
        this.table.setLayoutData((Object)new RowData(180, 84));
        this.table.setHeaderVisible(false);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Criteria criteria;
                int n = FilterListDialog.this.table.getSelectionCount();
                if (n == 1 && (criteria = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDViewerPlugin.getResourceString("FILTER_LIST_UPDATE"))) != null) {
                    FilterListDialog.this.replaceSelectedCriteria(criteria);
                }
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        if (this.filters != null) {
            composite2 = this.filters.iterator();
            while (composite2.hasNext()) {
                object = (FilterCriteria)composite2.next();
                this.addCriteria(((FilterCriteria)object).getCriteria(), ((FilterCriteria)object).isActive());
            }
        }
        composite2 = new Composite((Composite)group, 0);
        object = new RowLayout();
        ((RowLayout)object).wrap = false;
        ((RowLayout)object).pack = false;
        ((RowLayout)object).justify = true;
        ((RowLayout)object).type = 512;
        ((RowLayout)object).marginLeft = 0;
        ((RowLayout)object).marginTop = 4;
        ((RowLayout)object).marginRight = 0;
        ((RowLayout)object).marginBottom = 4;
        ((RowLayout)object).spacing = 8;
        composite2.setLayout((Layout)object);
        this.add = new Button(composite2, 0);
        this.add.setText(SDViewerPlugin.getResourceString("FILTER_LIST_ADD"));
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Criteria criteria = new Criteria();
                Criteria criteria2 = FilterListDialog.this.openFilterDialog(criteria, SDViewerPlugin.getResourceString("FILTER_LIST_CREATE"));
                if (criteria2 != null) {
                    FilterListDialog.this.addCriteria(criteria2, true);
                }
            }
        });
        this.edit = new Button(composite2, 0);
        this.edit.setText(SDViewerPlugin.getResourceString("FILTER_LIST_EDIT"));
        this.edit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Criteria criteria = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDViewerPlugin.getResourceString("FILTER_LIST_UPDATE"));
                if (criteria != null) {
                    FilterListDialog.this.replaceSelectedCriteria(criteria);
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = new Button(composite2, 0);
        this.remove.setText(SDViewerPlugin.getResourceString("FILTER_LIST_REMOVE"));
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterListDialog.this.table.remove(FilterListDialog.this.table.getSelectionIndices());
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        this.remove.setEnabled(false);
        this.getShell().setText(SDViewerPlugin.getResourceString("FILTER_LIST_TITLE"));
        return group;
    }

    public FilterListDialog(IViewPart iViewPart, ISDFilterProvider iSDFilterProvider) {
        super(iViewPart.getSite().getShell());
        this.viewer = iViewPart;
        this.provider = iSDFilterProvider;
        this.filters = this.provider.getCurrentFilters();
        this.setShellStyle(67680);
    }

    private Criteria openFilterDialog(Criteria criteria, String string) {
        SearchFilterDialog searchFilterDialog = new SearchFilterDialog((SDView)this.viewer, this.provider, true, 65536);
        searchFilterDialog.setCriteria(criteria);
        searchFilterDialog.setOkText(string);
        searchFilterDialog.setTitle(SDViewerPlugin.getResourceString("FILTER_LIST_CRITERIA_DIALOG"));
        searchFilterDialog.open();
        return searchFilterDialog.getCriteria();
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        return super.open();
    }

    public void okPressed() {
        this.filters = this.table.getItemCount() > 0 ? new ArrayList() : null;
        int n = 0;
        while (n < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(n);
            this.filters.add(new FilterCriteria(((CriteriaTableItem)tableItem.getData()).getCriteria(), tableItem.getChecked()));
            ++n;
        }
        super.close();
        this.provider.filter(this.filters);
    }

    public void setFilters(ArrayList arrayList) {
        this.filters = arrayList;
    }

    public ArrayList getFilters() {
        return this.filters;
    }

    private class CriteriaTableItem {
        private Criteria criteria;
        private TableItem tableItem;

        public CriteriaTableItem(Table table, boolean bl) {
            this.tableItem = new TableItem(table, 0);
            this.tableItem.setData((Object)this);
            this.tableItem.setChecked(bl);
        }

        public CriteriaTableItem(Table table, boolean bl, int n) {
            this.tableItem = new TableItem(table, 0, n);
            this.tableItem.setChecked(bl);
        }

        public void setCriteria(Criteria criteria) {
            this.criteria = criteria;
            this.tableItem.setText(this.criteria.getExpression());
        }

        public Criteria getCriteria() {
            return this.criteria;
        }
    }
}

