/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.TabContents;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchFilterDialog
extends Dialog {
    private static final String FIND_CRITERIA = "findCriteria";
    private static final String FIND_EXPRESSION_LIST = "findExpressionList";
    private static final int MAX_EXPRESSION_LIST = 4;
    private SDView viewer = null;
    private TabFolder tab = null;
    private TabContents content = null;
    private Criteria criteria = null;
    private ISDGraphNodeSupporter provider = null;
    private String okText;
    private String title;
    private String[] expressionList;
    private boolean find;

    public Control createDialogArea(Composite composite) {
        if (this.provider instanceof ISDFindProvider) {
            WorkbenchHelp.setHelp((Control)composite, (String)(SDViewerPlugin.getId() + ".UML2SDFIND"));
        } else if (this.provider instanceof ISDFilterProvider) {
            WorkbenchHelp.setHelp((Control)composite, (String)(SDViewerPlugin.getId() + ".UML2SDFILTER"));
        }
        this.expressionList = SDViewerPlugin.getDefault().getDialogSettings().getArray(FIND_EXPRESSION_LIST);
        if (this.expressionList == null) {
            this.expressionList = new String[0];
        }
        return new TabContents(composite, this.provider, this.getButton(0), this.find ? this.expressionList : null);
    }

    public SearchFilterDialog(SDView sDView, ISDGraphNodeSupporter iSDGraphNodeSupporter, boolean bl, int n) {
        super(sDView.getSDWidget().getShell());
        this.setShellStyle(0x860 | n);
        this.provider = iSDGraphNodeSupporter;
        this.viewer = sDView;
        this.find = !bl;
    }

    public int open() {
        this.create();
        if (this.find) {
            this.loadFindCriteria();
        }
        if (this.criteria != null) {
            this.copyFromCriteria(this.criteria);
        }
        if (this.okText != null) {
            this.getButton(0).setText(this.okText);
        } else {
            this.getButton(0).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_SEARCH_BUTTON"));
        }
        if (this.find) {
            this.getButton(1).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_CLOSE_BUTTON"));
        }
        Button button = this.getButton(0);
        ((TabContents)this.getDialogArea()).setOkButton(button);
        if (!(this.criteria != null && this.criteria.getExpression() != null && !this.criteria.getExpression().equals("") && (this.criteria.isAsyncMessageReturnSelected() || this.criteria.isAsyncMessageSelected() || this.criteria.isLifeLineSelected() || this.criteria.isStopSelected() || this.criteria.isSyncMessageReturnSelected() || this.criteria.isSyncMessageSelected()))) {
            button.setEnabled(false);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_TITLE"));
        }
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.criteria = null;
        return super.open();
    }

    private void loadFindCriteria() {
        DialogSettings dialogSettings = (DialogSettings)SDViewerPlugin.getDefault().getDialogSettings().getSection(FIND_CRITERIA);
        List list = this.viewer.getSDWidget().getSelection();
        if (list == null || list.size() != 1) {
            if (dialogSettings != null) {
                this.criteria = new Criteria();
                this.criteria.load(dialogSettings);
            }
        } else {
            GraphNode graphNode = (GraphNode)list.get(0);
            this.criteria = new Criteria();
            this.criteria.setExpression(graphNode.getName());
            this.criteria.setCaseSenstiveSelected(true);
            if (graphNode instanceof Lifeline) {
                this.criteria.setLifeLineSelected(true);
            } else if (graphNode instanceof SyncMessageReturn || graphNode instanceof SyncMessage) {
                this.criteria.setSyncMessageSelected(true);
            }
        }
    }

    public void okPressed() {
        this.copyToCriteria();
        if (!this.find) {
            super.close();
        }
        if (this.provider != null && this.provider instanceof ISDFindProvider && this.find) {
            boolean bl = ((ISDFindProvider)this.provider).find(this.criteria);
            TabContents tabContents = this.getTabContents();
            tabContents.setResult(bl);
        }
    }

    public void cancelPressed() {
        if (this.find) {
            this.copyToCriteria();
            if (this.provider instanceof ISDFindProvider) {
                ((ISDFindProvider)this.provider).cancel();
            }
            this.saveCriteria();
        }
        super.cancelPressed();
    }

    public void saveCriteria() {
        DialogSettings dialogSettings = (DialogSettings)SDViewerPlugin.getDefault().getDialogSettings();
        DialogSettings dialogSettings2 = (DialogSettings)dialogSettings.getSection(FIND_CRITERIA);
        if (dialogSettings2 == null) {
            dialogSettings2 = (DialogSettings)dialogSettings.addNewSection(FIND_CRITERIA);
        }
        this.criteria.save(dialogSettings2);
        int n = Math.min(this.expressionList.length + 1, 4);
        String[] stringArray = new String[n];
        stringArray[0] = this.criteria.getExpression();
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n3 < n && n4 < this.expressionList.length) {
            if (!this.criteria.getExpression().equals(this.expressionList[n4])) {
                stringArray[n3++] = this.expressionList[n4];
            } else {
                ++n2;
            }
            ++n4;
        }
        if (n2 == 0) {
            this.expressionList = stringArray;
        } else {
            this.expressionList = new String[n - n2];
            int n5 = 0;
            while (n5 < n - n2) {
                this.expressionList[n5] = stringArray[n5];
                ++n5;
            }
        }
        dialogSettings.put(FIND_EXPRESSION_LIST, this.expressionList);
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void copyToCriteria() {
        this.criteria = new Criteria();
        TabContents tabContents = this.getTabContents();
        this.criteria.setLifeLineSelected(tabContents.getLifelineButtonSelection());
        this.criteria.setSyncMessageSelected(tabContents.getSynMessageButtonSelection());
        this.criteria.setSyncMessageReturnSelected(tabContents.getSynMessageReturnButtonSelection());
        this.criteria.setAsyncMessageSelected(tabContents.getAsynMessageButtonSelection());
        this.criteria.setAsyncMessageReturnSelected(tabContents.getAsynMessageReturnButtonSelection());
        this.criteria.setStopSelected(tabContents.getStopButtonSelection());
        this.criteria.setCaseSenstiveSelected(tabContents.getCaseSensitiveSelection());
        this.criteria.setExpression(tabContents.getSearchText());
    }

    private TabContents getTabContents() {
        TabContents tabContents = null;
        tabContents = this.tab == null ? (TabContents)this.getDialogArea() : (TabContents)this.tab.getSelection()[0].getControl();
        return tabContents;
    }

    public void copyFromCriteria(Criteria criteria) {
        TabContents tabContents = this.getTabContents();
        tabContents.setLifelineButtonSelection(criteria.isLifeLineSelected());
        tabContents.setSynMessageButtonSelection(criteria.isSyncMessageSelected());
        tabContents.setSynMessageReturnButtonSelection(criteria.isSyncMessageReturnSelected());
        tabContents.setAsynMessageButtonSelection(criteria.isAsyncMessageSelected());
        tabContents.setAsynMessageReturnButtonSelection(criteria.isSyncMessageReturnSelected());
        tabContents.setStopButtonSelection(criteria.isStopSelected());
        tabContents.setCaseSensitiveSelection(criteria.isCaseSenstiveSelected());
        if (criteria.getExpression() != null) {
            tabContents.setSearchText(criteria.getExpression());
        }
    }

    public void setOkText(String string) {
        this.okText = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

