/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;

public class ExecutionOccurrence
extends BasicExecutionOccurrence
implements ITimeRange {
    protected int[] fillRGB;
    protected int[] strokeRGB;
    protected IImage image;
    protected IImage ellipsesImage;
    protected double startTime;
    protected double endTime;
    protected boolean hasTime;

    public void setLifeline(Lifeline lifeline) {
        super.setLifeline(lifeline);
        if (this.lifeline != null && this.hasTime) {
            this.lifeline.hasTime = true;
            if (this.lifeline.getFrame() != null) {
                this.lifeline.getFrame().setHasTimeInfo(true);
            }
        }
    }

    public void setFillColor(int n, int n2, int n3) {
        this.fillRGB = new int[3];
        this.fillRGB[0] = n;
        this.fillRGB[1] = n2;
        this.fillRGB[2] = n3;
    }

    public void setStrokeColor(int n, int n2, int n3) {
        this.strokeRGB = new int[3];
        this.strokeRGB[0] = n;
        this.strokeRGB[1] = n2;
        this.strokeRGB[2] = n3;
    }

    public void setImage(IImage iImage) {
        this.image = iImage;
    }

    public void setTopEllipsesImage(IImage iImage) {
        this.ellipsesImage = iImage;
    }

    public void setStartTime(double d) {
        this.startTime = d;
        this.hasTime = true;
        if (this.lifeline != null) {
            this.lifeline.setTimeInfo(true);
        }
    }

    public void setEndTime(double d) {
        this.endTime = d;
        this.hasTime = true;
        if (this.lifeline != null) {
            this.lifeline.setTimeInfo(true);
        }
    }

    public double getFirstTime() {
        return this.startTime;
    }

    public double getLastTime() {
        return this.endTime;
    }

    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    public void draw(IGC iGC) {
        super.draw(iGC);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.image != null) {
            iGC.drawImage(this.image, n + n3 - 4, n2 + n4 - 11, 8, 11);
        }
        if (this.ellipsesImage != null) {
            iGC.drawImage(this.ellipsesImage, n + n3, n2, 40, 10);
        }
    }

    protected IColor setUnselectedFillColor(IGC iGC) {
        if (this.fillRGB != null) {
            IColor iColor = iGC.createColor(this.fillRGB[0], this.fillRGB[1], this.fillRGB[2]);
            if (Frame.getUserPref().useGradienColor()) {
                iGC.setGradientColor(iColor);
                iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_EXEC"));
                iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
            } else {
                iGC.setBackground(iColor);
            }
            return iColor;
        }
        return super.setUnselectedFillColor(iGC);
    }

    protected IColor setUnselectedStrokeColor(IGC iGC) {
        if (this.strokeRGB != null) {
            IColor iColor = iGC.createColor(this.strokeRGB[0], this.strokeRGB[1], this.strokeRGB[2]);
            iGC.setForeground(iColor);
            return iColor;
        }
        return super.setUnselectedStrokeColor(iGC);
    }
}

