/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagramToolTip
implements PaintListener {
    protected Control parent = null;
    protected Shell toolTipShell = null;
    protected String text = null;

    public DiagramToolTip(Control control) {
        this.parent = control;
        this.toolTipShell = new Shell(this.parent.getShell(), 540672);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(10, 10);
        this.toolTipShell.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 13;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = DiagramToolTip.this.text;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 4;
            }
        });
    }

    public void showToolTip(String string) {
        if (string == null || string.equalsIgnoreCase("")) {
            this.toolTipShell.setVisible(false);
            return;
        }
        this.text = string;
        int n = this.toolTipShell.getBounds().width;
        int n2 = this.toolTipShell.getBounds().height;
        Point point = Display.getDefault().getCursorLocation();
        int n3 = 32;
        int n4 = 0;
        while (n4 < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[n4].y < n3) {
                n3 = Display.getDefault().getCursorSizes()[n4].y;
            }
            ++n4;
        }
        if (point.x + n > Display.getDefault().getBounds().width) {
            int n5 = point.x + n - Display.getDefault().getBounds().width;
            if (n5 > Display.getDefault().getBounds().width) {
                point.x = 0;
            }
            point.x -= n5;
        }
        this.toolTipShell.setLocation(point.x, point.y + n3);
        this.toolTipShell.setVisible(true);
        this.toolTipShell.getAccessible().setFocus(this.parent.handle);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent paintEvent) {
        Point point = paintEvent.gc.textExtent(this.text);
        paintEvent.gc.drawText(this.text, 2, 0, true);
        this.toolTipShell.setSize(point.x + 6, point.y + 2);
    }
}

