/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class NGC
implements IGC {
    protected GC context;
    protected SDWidget view;
    private Font tempFont = null;
    private IColor gradientColor = null;
    private IColor backGround = null;
    private IColor foreGround = null;
    private int y_;
    private int x_;
    private int yx;
    private int xx;
    private static int vscreen_bounds = 5;

    public NGC(SDWidget sDWidget, GC gC) {
        this.context = gC;
        this.view = sDWidget;
    }

    public void setLineStyle(int n) {
        this.context.setLineStyle(n);
    }

    public int getLineStyle() {
        return this.context.getLineStyle();
    }

    public int getContentsX() {
        return Math.round((float)this.view.getContentsX() / this.view.zoomValue);
    }

    public int getContentsY() {
        return Math.round((float)this.view.getContentsY() / this.view.zoomValue);
    }

    public int getVisibleWidth() {
        return Math.round((float)this.view.getVisibleWidth() / this.view.zoomValue);
    }

    public int getVisibleHeight() {
        return Math.round((float)this.view.getVisibleHeight() / this.view.zoomValue);
    }

    public int contentsToViewX(int n) {
        return this.view.contentsToViewX(n);
    }

    public int contentsToViewY(int n) {
        return this.view.contentsToViewY(n);
    }

    private byte code(int n, int n2) {
        byte by = 0;
        this.y_ = vscreen_bounds;
        this.x_ = vscreen_bounds;
        this.yx = this.view.getVisibleHeight() + vscreen_bounds;
        this.xx = this.view.getVisibleWidth() + vscreen_bounds;
        if (n2 > this.yx) {
            by = (byte)(by | 1);
        } else if (n2 < this.y_) {
            by = (byte)(by | 2);
        }
        if (n > this.xx) {
            by = (byte)(by | 4);
        } else if (n < this.x_) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        n = this.view.contentsToViewX(n);
        n2 = this.view.contentsToViewY(n2);
        n3 = this.view.contentsToViewX(n3);
        n4 = this.view.contentsToViewY(n4);
        byte by = this.code(n, n2);
        byte by2 = this.code(n3, n4);
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        do {
            byte by3;
            if (by == 0 && by2 == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            if ((by & by2) != 0) {
                bl2 = true;
                continue;
            }
            byte by4 = by3 = by != 0 ? by : by2;
            if ((by3 & 1) != 0) {
                n5 = n + (n3 - n) * (this.yx - n2) / (n4 - n2);
                n6 = this.yx;
            } else if ((by3 & 2) != 0) {
                n5 = n + (n3 - n) * (this.y_ - n2) / (n4 - n2);
                n6 = this.y_;
            } else if ((by3 & 4) != 0) {
                n6 = n2 + (n4 - n2) * (this.xx - n) / (n3 - n);
                n5 = this.xx;
            } else if ((by3 & 8) != 0) {
                n6 = n2 + (n4 - n2) * (this.x_ - n) / (n3 - n);
                n5 = this.x_;
            }
            if (by3 == by) {
                n = n5;
                n2 = n6;
                by = this.code(n, n2);
                continue;
            }
            n3 = n5;
            n4 = n6;
            by2 = this.code(n3, n4);
        } while (!bl2);
        if (bl) {
            this.context.drawLine(n, n2, n3, n4);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        if (n2 != this.getContentsY()) {
            n2 = Math.round((float)n2 * this.view.zoomValue);
            n2 = this.view.contentsToViewY(n2);
        } else {
            n2 = 0;
        }
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        n = this.view.contentsToViewX(n);
        if (n < -vscreen_bounds) {
            n3 = n3 + n + vscreen_bounds;
            n = -vscreen_bounds;
        }
        if (n2 < -vscreen_bounds) {
            n4 = n4 + n2 + vscreen_bounds;
            n2 = -vscreen_bounds;
        }
        if (n3 < -vscreen_bounds && n + n3 < -vscreen_bounds) {
            n3 = -vscreen_bounds;
        } else if (n3 + n > this.view.getVisibleWidth() + vscreen_bounds) {
            n3 = this.view.getVisibleWidth() + vscreen_bounds - n;
        }
        if (n4 < -vscreen_bounds && n2 + n4 < -vscreen_bounds) {
            n4 = -vscreen_bounds;
        } else if (n4 + n2 > this.view.getVisibleHeight() + vscreen_bounds) {
            n4 = this.view.getVisibleHeight() + vscreen_bounds - n2;
        }
        this.context.drawRectangle(n, n2, n3, n4);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        this.context.drawFocus(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4);
    }

    public void fillPolygon(int[] nArray) {
        int n = nArray.length / 2 * 2;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.view.contentsToViewX(Math.round((float)nArray[n2] * this.view.zoomValue));
            nArray2[++n2] = this.view.contentsToViewY(Math.round((float)nArray[n2] * this.view.zoomValue));
            ++n2;
        }
        this.context.fillPolygon(nArray2);
    }

    public void drawPolygon(int[] nArray) {
        int n = nArray.length / 2 * 2;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.view.contentsToViewX(Math.round((float)nArray[n2] * this.view.zoomValue));
            nArray2[++n2] = this.view.contentsToViewY(Math.round((float)nArray[n2] * this.view.zoomValue));
            ++n2;
        }
        this.context.drawPolygon(nArray2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        if (n2 != this.getContentsY()) {
            n2 = Math.round((float)n2 * this.view.zoomValue);
            n2 = this.view.contentsToViewY(n2) + 1;
        } else {
            n2 = 1;
        }
        n3 = Math.round((float)n3 * this.view.zoomValue) - 1;
        n4 = Math.round((float)n4 * this.view.zoomValue) - 1;
        n = this.view.contentsToViewX(n) + 1;
        if (n < -vscreen_bounds) {
            n3 = n3 + n + vscreen_bounds;
            n = -vscreen_bounds;
        }
        if (n2 < -vscreen_bounds) {
            n4 = n4 + n2 + vscreen_bounds;
            n2 = -vscreen_bounds;
        }
        if (n3 < -vscreen_bounds && n + n3 < -vscreen_bounds) {
            n3 = -vscreen_bounds;
        } else if (n3 + n > this.view.getVisibleWidth() + vscreen_bounds) {
            n3 = this.view.getVisibleWidth() + vscreen_bounds - n;
        }
        if (n4 < -vscreen_bounds && n2 + n4 < -vscreen_bounds) {
            n4 = -vscreen_bounds;
        } else if (n4 + n2 > this.view.getVisibleHeight() + vscreen_bounds) {
            n4 = this.view.getVisibleHeight() + vscreen_bounds - n2;
        }
        this.context.fillRectangle(n, n2, n3, n4);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        IColor iColor = this.foreGround;
        this.setForeground(this.gradientColor);
        n = this.view.contentsToViewX(n);
        n2 = this.view.contentsToViewY(n2);
        if (bl) {
            n4 = n4 > 0 ? ++n4 : --n4;
            this.context.fillGradientRectangle(n, n2, n3, n4, bl);
            this.setForeground(iColor);
        } else {
            if (n < -vscreen_bounds) {
                n3 = n3 + n + vscreen_bounds;
                n = -vscreen_bounds;
            }
            if (n2 < -vscreen_bounds) {
                n4 = n4 + n2 + vscreen_bounds;
                n2 = -vscreen_bounds;
            }
            if (n3 < -vscreen_bounds && n + n3 < -vscreen_bounds) {
                n3 = -vscreen_bounds;
            } else if (n3 + n > this.view.getVisibleWidth() + vscreen_bounds) {
                n3 = this.view.getVisibleWidth() + vscreen_bounds - n;
            }
            if (n4 < -vscreen_bounds && n2 + n4 < -vscreen_bounds) {
                n4 = -vscreen_bounds;
            } else if (n4 + n2 > this.view.getVisibleHeight() + vscreen_bounds) {
                n4 = this.view.getVisibleHeight() + vscreen_bounds - n2;
            }
            this.context.fillGradientRectangle(n + n3, n2, -n3, n4 + 1, bl);
            this.setForeground(iColor);
        }
    }

    public int textExtent(String string) {
        return this.context.textExtent((String)string).x;
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(n), this.view.contentsToViewY(n2), bl);
    }

    public void drawText(String string, int n, int n2) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(n), this.view.contentsToViewY(n2), true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        this.context.fillOval(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4);
    }

    public IColor getBackground() {
        if (this.backGround != null && this.backGround.getColor() instanceof Color && !((Color)this.backGround.getColor()).isDisposed()) {
            return this.backGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public IColor getForeground() {
        if (this.foreGround != null && this.foreGround.getColor() instanceof Color && !((Color)this.foreGround.getColor()).isDisposed()) {
            return this.foreGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public void setBackground(IColor iColor) {
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color) {
            this.context.setBackground((Color)iColor.getColor());
            this.backGround = iColor;
        }
    }

    public void setForeground(IColor iColor) {
        Color color;
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color && !(color = (Color)iColor.getColor()).isDisposed()) {
            this.context.setForeground(color);
            this.foreGround = iColor;
        }
    }

    public void setGradientColor(IColor iColor) {
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color) {
            this.gradientColor = iColor;
        }
    }

    public void setLineWidth(int n) {
        this.context.setLineWidth(n);
    }

    public int getLineWidth() {
        return this.context.getLineWidth();
    }

    private void localDrawText(String string, int n, int n2, boolean bl) {
        Point point = this.context.textExtent(string);
        if (!bl) {
            this.context.fillRectangle(n, n2, point.x, point.y);
        }
        this.context.drawText(string, n, n2, bl);
    }

    public void drawTextTruncatedCentred(String string, int n, int n2, int n3, int n4, boolean bl) {
        Point point = this.context.textExtent(string);
        n = Math.round((float)n * this.view.zoomValue);
        int n5 = 0;
        if (n2 != this.getContentsY()) {
            n2 = Math.round((float)n2 * this.view.zoomValue);
            n5 = this.view.contentsToViewY(n2);
        }
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        int n6 = this.view.contentsToViewX(n);
        if (point.y > n4) {
            return;
        }
        if (point.x <= n3) {
            this.localDrawText(string, n6 + 1 + (n3 - point.x) / 2, n5 + 1 + (n4 - point.y) / 2, bl);
        } else {
            String string2 = string;
            int n7 = string.length() - 1;
            while (n7 >= 0 && this.context.textExtent((String)string2).x >= n3) {
                string2 = string.substring(0, n7);
                --n7;
            }
            int n8 = 0;
            int n9 = 1;
            while (n9 <= 3 && string2.length() - n9 > 0) {
                ++n8;
                ++n9;
            }
            string2 = string2.substring(0, string2.length() - n8);
            int n10 = 0;
            while (n10 < n8) {
                string2 = string2 + ".";
                ++n10;
            }
            this.localDrawText(string2, n6 + 1 + (n3 - this.context.textExtent((String)string2).x) / 2, n5 + 1 + (n4 - this.context.textExtent((String)string2).y) / 2, bl);
        }
    }

    public void drawTextTruncated(String string, int n, int n2, int n3, int n4, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        int n5 = this.view.contentsToViewX(n);
        int n6 = this.view.contentsToViewY(n2);
        if (this.context.textExtent((String)string).x <= n3) {
            this.localDrawText(string, n5 + 1, n6 + 1 + n4, bl);
        } else {
            String string2 = string;
            int n7 = string.length() - 1;
            while (n7 >= 0 && this.context.textExtent((String)string2).x >= n3) {
                string2 = string.substring(0, n7);
                --n7;
            }
            int n8 = 0;
            int n9 = 1;
            while (n9 <= 3 && string2.length() - n9 > 0) {
                ++n8;
                ++n9;
            }
            string2 = string2.substring(0, string2.length() - n8);
            int n10 = 0;
            while (n10 < n8) {
                string2 = string2 + ".";
                ++n10;
            }
            this.localDrawText(string2, n5 + 1, n6 + 1 + n4, bl);
        }
    }

    public void drawImage(IImage iImage, int n, int n2, int n3, int n4) {
        if (!(iImage.getImage() instanceof Image)) {
            return;
        }
        Image image = (Image)iImage.getImage();
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        int n5 = this.view.contentsToViewX(n);
        int n6 = this.view.contentsToViewY(n2);
        Rectangle rectangle = ((Image)iImage.getImage()).getBounds();
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        if (n7 > n3) {
            n7 = n3;
        }
        if (n8 > n4) {
            n8 = n4;
        }
        float f = this.view.zoomValue;
        n7 = Math.round((float)n7 * f);
        n8 = Math.round((float)n8 * f);
        this.context.drawImage(image, 0, 0, rectangle.width, rectangle.height, n5, n6, n7, n8);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        this.context.drawArc(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4, n5, n6);
    }

    public void setFont(IFont iFont) {
        if (iFont.getFont() != null && ((Font)iFont.getFont()).getFontData().length > 0) {
            FontData fontData = ((Font)iFont.getFont()).getFontData()[0];
            if (SDViewPref.getInstance().fontLinked()) {
                fontData.setHeight(Math.round((float)fontData.getHeight() * this.view.zoomValue));
            }
            if (this.tempFont != null) {
                this.tempFont.dispose();
            }
            this.tempFont = new Font((Device)Display.getCurrent(), fontData);
            this.context.setFont(this.tempFont);
        }
    }

    public int getFontHeight(IFont iFont) {
        if (iFont.getFont() != null && iFont.getFont() instanceof Font && ((Font)iFont.getFont()).getFontData().length > 0) {
            FontData fontData = ((Font)iFont.getFont()).getFontData()[0];
            Font font = this.context.getFont();
            this.context.setFont((Font)iFont.getFont());
            int n = this.context.textExtent((String)"lp").y;
            this.context.setFont(font);
            return n;
        }
        return 0;
    }

    public int getFontWidth(IFont iFont) {
        if (iFont.getFont() != null && iFont.getFont() instanceof Font) {
            Font font = this.context.getFont();
            this.context.setFont((Font)iFont.getFont());
            int n = this.context.getFontMetrics().getAverageCharWidth();
            this.context.setFont(font);
            return n;
        }
        return 0;
    }

    public void dispose() {
        if (this.tempFont != null) {
            this.tempFont.dispose();
        }
        this.tempFont = null;
        if (this.context != null) {
            this.context.dispose();
        }
        this.context = null;
    }

    public float getZoom() {
        if (this.view != null) {
            return this.view.zoomValue;
        }
        return 1.0f;
    }

    public int getLineDotStyle() {
        return 3;
    }

    public int getLineDashStyle() {
        return 2;
    }

    public int getLineSolidStyle() {
        return 1;
    }

    public IColor createColor(int n, int n2, int n3) {
        return new ColorImpl(Display.getDefault(), n, n2, n3);
    }
}

