/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class ScrollView
extends Composite {
    public static final int AUTO = 0;
    public static final int ALWAYS_OFF = 2;
    public static final int ALWAYS_ON = 1;
    private int contents_height_ = 0;
    private int contents_width_ = 0;
    private int contents_x_ = 0;
    private int contents_y_ = 0;
    private int h_scrollbar_mode_ = 0;
    private int v_scrollbar_mode_ = 0;
    private int h_scrollbar_increment_ = 1;
    private int v_scrollbar_increment_ = 1;
    private boolean auto_scroll_enabled_ = true;
    private int auto_scroll_period_ = 75;
    private PaintListener localPaintListener = null;
    private MouseMoveListener localMouseMoveListener = null;
    private MouseListener localMouseListener = null;
    private ControlListener localControlListener = null;
    private KeyListener localKeyListener = null;
    private Canvas vertsb_;
    private Canvas horzsb_ = new Canvas((Composite)this, 256);
    private Canvas viewcontrol_;
    protected Control corner_control_;
    private int overview_size_ = 100;
    private int mouse_down_x_ = -1;
    private int mouse_down_y_ = -1;
    private AutoScroll auto_scroll_ = null;
    private Timer auto_scroll_timer_ = null;
    public static final int VBAR = 1;
    public static final int HBAR = 2;
    private static Cursor overview_cursor_;

    public ScrollView(Composite composite, int n) {
        super(composite, 0);
        this.viewcontrol_ = new Canvas((Composite)this, n & 0xFFFFFCFF);
        this.viewcontrol_.setBackground(this.getBackground());
        this.vertsb_ = new Canvas((Composite)this, 512);
        this.setLayout(new SVLayout());
        this.localPaintListener = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = paintEvent.gc.getClipping();
                int n = ScrollView.this.viewToContentsX(rectangle.x);
                int n2 = ScrollView.this.viewToContentsY(rectangle.y);
                ScrollView.this.drawContents(paintEvent.gc, n, n2, rectangle.width, rectangle.height);
            }
        };
        this.viewcontrol_.addPaintListener(this.localPaintListener);
        this.localMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseMoveEvent(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }
        };
        this.viewcontrol_.addMouseMoveListener(this.localMouseMoveListener);
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseEnter(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }

            public void mouseHover(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseHover(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }

            public void mouseExit(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseExit(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }
        };
        this.viewcontrol_.addMouseTrackListener(mouseTrackListener);
        this.localMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseDoubleClickEvent(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }

            public void mouseDown(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.mouse_down_x_ = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.mouse_down_y_ = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseDownEvent(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                int n = mouseEvent.x;
                int n2 = mouseEvent.y;
                mouseEvent.x = ScrollView.this.viewToContentsX(mouseEvent.x);
                mouseEvent.y = ScrollView.this.viewToContentsY(mouseEvent.y);
                ScrollView.this.contentsMouseUpEvent(mouseEvent);
                mouseEvent.x = n;
                mouseEvent.y = n2;
                ScrollView.this.mouse_down_x_ = (ScrollView.this.mouse_down_y_ = -1);
            }
        };
        this.viewcontrol_.addMouseListener(this.localMouseListener);
        this.localKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                ScrollView.this.keyPressedEvent(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ScrollView.this.keyReleasedEvent(keyEvent);
            }
        };
        this.addKeyListener(this.localKeyListener);
        this.viewcontrol_.addKeyListener(this.localKeyListener);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScrollView.this.setContentsPos(ScrollView.this.contents_x_, ScrollView.this.getVerticalBar().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScrollView.this.setContentsPos(ScrollView.this.getHorizontalBar().getSelection(), ScrollView.this.contents_y_);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScrollView.this.viewcontrol_.forceFocus();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public boolean setFocus() {
        return this.viewcontrol_.forceFocus();
    }

    public void setCursor(Cursor cursor) {
        this.viewcontrol_.setCursor(cursor);
    }

    public void dispose() {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
        if (this.viewcontrol_ != null) {
            this.viewcontrol_.dispose();
        }
        this.viewcontrol_ = null;
        if (this.vertsb_ != null) {
            this.vertsb_.dispose();
        }
        this.vertsb_ = null;
        if (this.horzsb_ != null) {
            this.horzsb_.dispose();
        }
        this.horzsb_ = null;
        if (this.corner_control_ != null) {
            Object object = this.corner_control_.getData();
            if (object instanceof Overview) {
                ((Overview)object).dispose();
            }
            this.corner_control_.dispose();
            this.corner_control_ = null;
        }
        super.dispose();
    }

    public Rectangle getClientArea() {
        return this.viewcontrol_.getClientArea();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.viewcontrol_.setBackground(color);
    }

    public void setToolTipText(String string) {
        this.viewcontrol_.setToolTipText(string);
    }

    protected void drawOverview(GC gC, Rectangle rectangle) {
        int n = (int)((float)(rectangle.width * this.contents_x_) / (float)this.contents_width_);
        int n2 = (int)((float)(rectangle.height * this.contents_y_) / (float)this.contents_height_);
        int n3 = this.getVisibleWidth();
        int n4 = this.getVisibleHeight();
        int n5 = rectangle.width - 1;
        if (this.contents_width_ > n3) {
            n5 = (int)((float)(rectangle.width * n3) / (float)this.contents_width_);
        }
        int n6 = rectangle.height - 1;
        if (this.contents_height_ > n4) {
            n6 = (int)((float)(rectangle.height * n4) / (float)this.contents_height_);
        }
        gC.setForeground(this.getForeground());
        if (n5 < 5 || n6 < 5) {
            gC.drawLine(n, 0, n, rectangle.height);
            gC.drawLine(0, n2, rectangle.width, n2);
        } else {
            gC.drawRectangle(n, n2, n5, n6);
        }
    }

    public void replaceControlListener(ControlListener controlListener) {
        if (this.localControlListener != null) {
            this.removeControlListener(this.localControlListener);
            this.localControlListener = null;
        }
        this.addControlListener(controlListener);
    }

    public void replaceKeyListener(KeyListener keyListener) {
        if (this.localKeyListener != null) {
            this.removeKeyListener(this.localKeyListener);
            this.localKeyListener = null;
        }
        this.addKeyListener(keyListener);
    }

    public void replaceMouseListener(MouseListener mouseListener) {
        if (this.localMouseListener != null) {
            this.removeMouseListener(this.localMouseListener);
            this.localMouseListener = null;
        }
        this.viewcontrol_.addMouseListener(mouseListener);
    }

    public void replaceMouseMoveListener(MouseMoveListener mouseMoveListener) {
        if (this.localMouseMoveListener != null) {
            this.removeMouseMoveListener(this.localMouseMoveListener);
            this.localMouseMoveListener = null;
        }
        this.viewcontrol_.addMouseMoveListener(mouseMoveListener);
    }

    public void replacePaintListener(PaintListener paintListener) {
        if (this.localPaintListener != null) {
            this.removePaintListener(this.localPaintListener);
            this.localPaintListener = null;
        }
        this.viewcontrol_.addPaintListener(paintListener);
    }

    public int getContentsHeight() {
        return this.contents_height_;
    }

    public int getContentsWidth() {
        return this.contents_width_;
    }

    public int getContentsX() {
        return this.contents_x_;
    }

    public int getContentsY() {
        return this.contents_y_;
    }

    public boolean getDragAutoScroll() {
        return this.auto_scroll_enabled_;
    }

    public void setDragAutoScroll(boolean bl) {
        this.auto_scroll_enabled_ = bl;
        if (!this.auto_scroll_enabled_ && this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    public void setDragAutoScrollPeriod(int n) {
        this.auto_scroll_period_ = Math.max(0, n);
    }

    public int getDragAutoScrollPeriod() {
        return this.auto_scroll_period_;
    }

    public int getHScrollBarMode() {
        return this.h_scrollbar_mode_;
    }

    public void setHScrollBarMode(int n) {
        this.h_scrollbar_mode_ = n;
    }

    public int getVScrollBarMode() {
        return this.v_scrollbar_mode_;
    }

    public void setVScrollBarMode(int n) {
        this.v_scrollbar_mode_ = n;
    }

    public int getHScrollBarIncrement() {
        return this.h_scrollbar_increment_;
    }

    public int getVScrollBarIncrement() {
        return this.v_scrollbar_increment_;
    }

    public void setHScrollBarIncrement(int n) {
        this.h_scrollbar_increment_ = Math.max(1, n);
    }

    public void setVScrollBarIncrement(int n) {
        this.v_scrollbar_increment_ = Math.max(1, n);
    }

    public void setOverviewEnabled(boolean bl) {
        if (this.getOverviewEnabled() == bl) {
            return;
        }
        Button button = null;
        if (bl) {
            Button button2 = new Button((Composite)this, 0);
            button2.setText("+");
            Overview overview = new Overview();
            overview.useControl((Control)button2);
            button2.setData((Object)overview);
            button = button2;
            button2.setToolTipText(SDViewerPlugin.getResourceString("SCROOLVIEW_TOOLTIP"));
        }
        this.setCornerControl((Control)button);
    }

    public void setOverviewSize(int n) {
        this.overview_size_ = Math.abs(n);
    }

    public boolean getOverviewEnabled() {
        Object object;
        return this.corner_control_ instanceof Button && (object = ((Button)this.corner_control_).getData()) instanceof Overview;
    }

    public int getOverviewSize() {
        return this.overview_size_;
    }

    public Control getViewControl() {
        return this.viewcontrol_;
    }

    protected void contentsMouseExit(MouseEvent mouseEvent) {
    }

    protected void contentsMouseHover(MouseEvent mouseEvent) {
    }

    protected void contentsMouseEnter(MouseEvent mouseEvent) {
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent mouseEvent) {
    }

    protected void contentsMouseDownEvent(MouseEvent mouseEvent) {
        this.mouse_down_x_ = mouseEvent.x;
        this.mouse_down_y_ = mouseEvent.y;
    }

    protected void contentsMouseMoveEvent(MouseEvent mouseEvent) {
        if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
            if (!this.auto_scroll_enabled_) {
                this.scrollBy(-(mouseEvent.x - this.mouse_down_x_), -(mouseEvent.y - this.mouse_down_y_));
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = this.getContentsX() + this.getVisibleWidth();
            int n4 = this.getContentsY() + this.getVisibleHeight();
            if (mouseEvent.x < this.getContentsX()) {
                n = this.getContentsX() - mouseEvent.x;
                this.mouse_down_x_ = this.getContentsX();
            } else if (mouseEvent.x > n3) {
                n = -mouseEvent.x + n3;
                this.mouse_down_x_ = n3;
            }
            if (mouseEvent.y < this.getContentsY()) {
                n2 = this.getContentsY() - mouseEvent.y;
                this.mouse_down_y_ = this.getContentsY();
            } else if (mouseEvent.y > n4) {
                n2 = -mouseEvent.y + n4;
                this.mouse_down_y_ = n4;
            }
            if (n != 0 || n2 != 0) {
                if (this.auto_scroll_ == null) {
                    if (this.auto_scroll_timer_ == null) {
                        this.auto_scroll_timer_ = new Timer(true);
                    }
                    this.auto_scroll_ = new AutoScroll(this, n, n2);
                    this.auto_scroll_timer_.schedule((TimerTask)this.auto_scroll_, 0L, (long)this.auto_scroll_period_);
                } else {
                    this.auto_scroll_.dx_ = n;
                    this.auto_scroll_.dy_ = n2;
                }
            } else {
                if (this.auto_scroll_ != null) {
                    this.auto_scroll_.cancel();
                    this.auto_scroll_ = null;
                }
                this.scrollBy(-(mouseEvent.x - this.mouse_down_x_), -(mouseEvent.y - this.mouse_down_y_));
            }
        }
    }

    protected void contentsMouseUpEvent(MouseEvent mouseEvent) {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    protected void drawContents(GC gC, int n, int n2, int n3, int n4) {
    }

    public void resizeContents(int n, int n2) {
        int n3;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = this.contents_width_;
        int n5 = this.contents_height_;
        if (n == n4 && n2 == n5) {
            return;
        }
        this.contents_width_ = n;
        this.contents_height_ = n2;
        if (n4 > n) {
            n3 = n;
            n = n4;
            n4 = n3;
        }
        n3 = this.getVisibleWidth();
        int n6 = this.getVisibleHeight();
        if (n4 < n3) {
            if (n > n3) {
                n = n3;
            }
            this.viewcontrol_.redraw(this.getContentsX() + n4, 0, n - n4, n6, true);
        }
        if (n5 > n2) {
            int n7 = n2;
            n2 = n5;
            n5 = n7;
        }
        if (n5 < n6) {
            if (n2 > n6) {
                n2 = n6;
            }
            this.viewcontrol_.redraw(0, this.getContentsY() + n5, n3, n2 - n5, true);
        }
        if (this.updateScrollBarVisiblity()) {
            this.layout();
        } else {
            this.updateScrollBarsValues();
        }
    }

    public void redraw() {
        super.redraw();
        this.viewcontrol_.redraw();
    }

    public void scrollBy(int n, int n2) {
        this.setContentsPos(this.getContentsX() + n, this.getContentsY() + n2);
    }

    public void ensureVisible(int n, int n2) {
        int n3 = this.getContentsX();
        int n4 = this.getContentsY();
        int n5 = this.getContentsX() + this.getVisibleWidth();
        int n6 = this.getContentsY() + this.getVisibleHeight();
        if (n < this.getContentsX()) {
            n3 = n;
        } else if (n > n5) {
            n3 = n - this.getVisibleWidth();
        }
        if (n2 < this.getContentsY()) {
            n4 = n2;
        } else if (n2 > n6) {
            n4 = n2 - this.getVisibleHeight();
        }
        this.setContentsPos(n3, n4);
    }

    public void ensureVisible(int n, int n2, int n3, int n4, int n5) {
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        int n6 = this.getContentsX();
        int n7 = this.getContentsY();
        int n8 = this.getContentsX() + this.getVisibleWidth();
        int n9 = this.getContentsY() + this.getVisibleHeight();
        boolean bl = false;
        boolean bl2 = false;
        if (n < this.getContentsX()) {
            n6 = n;
        } else if (n + n3 > n8) {
            n6 = n - n3;
        }
        if (n2 < this.getContentsY()) {
            n7 = n2;
        } else if (n2 + n4 > n9) {
            n7 = n2 - n4;
        }
        if (n3 > this.getVisibleWidth()) {
            bl = true;
        }
        if (n4 > this.getVisibleHeight()) {
            bl2 = true;
        }
        if (bl) {
            n6 = (n5 & 0x4000) != 0 ? n : ((n5 & 0x20000) != 0 ? n8 - n3 : n + (n3 - this.getVisibleWidth()) / 2);
        }
        if (bl2) {
            n7 = (n5 & 0x80) != 0 ? n2 : ((n5 & 0x400) != 0 ? n9 - n4 : n2 + (n4 - this.getVisibleHeight()) / 2);
        }
        this.setContentsPos(n6, n7);
    }

    public boolean isVisible(int n, int n2) {
        if (n < this.getContentsX()) {
            return false;
        }
        if (n2 < this.getContentsY()) {
            return false;
        }
        if (n > this.getContentsX() + this.getVisibleWidth()) {
            return false;
        }
        return n2 <= this.getContentsY() + this.getVisibleHeight();
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        if (n + n3 < this.getContentsX()) {
            return false;
        }
        if (n2 + n4 < this.getContentsY()) {
            return false;
        }
        int n5 = this.getContentsX() + this.getVisibleWidth();
        int n6 = this.getContentsY() + this.getVisibleHeight();
        if (n > n5) {
            return false;
        }
        return n2 <= n6;
    }

    public Rectangle getVisiblePart(int n, int n2, int n3, int n4) {
        if (n + n3 < this.getContentsX()) {
            return null;
        }
        if (n2 + n4 < this.getContentsY()) {
            return null;
        }
        int n5 = this.getContentsX() + this.getVisibleWidth();
        int n6 = this.getContentsY() + this.getVisibleHeight();
        if (n > n5) {
            return null;
        }
        if (n2 > n6) {
            return null;
        }
        int n7 = n + n3;
        int n8 = n2 + n4;
        int n9 = Math.max(n, this.getContentsX());
        int n10 = Math.max(n2, this.getContentsY());
        int n11 = Math.min(n7, n5);
        int n12 = Math.min(n8, n6);
        Rectangle rectangle = new Rectangle(n9, n10, n11 - n9, n12 - n10);
        return rectangle;
    }

    public final Rectangle getVisiblePart(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        return this.getVisiblePart(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean setContentsPos(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this.getVisibleWidth() >= this.getContentsWidth()) {
            n3 = 0;
        } else if (n < 0) {
            n3 = 0;
        } else if (n + this.getVisibleWidth() > this.getContentsWidth()) {
            n3 = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (this.getVisibleHeight() >= this.getContentsHeight()) {
            n4 = 0;
        } else if (n2 <= 0) {
            n4 = 0;
        } else if (n2 + this.getVisibleHeight() > this.getContentsHeight()) {
            n4 = this.getContentsHeight() - this.getVisibleHeight();
        }
        if (n3 == this.contents_x_ && n4 == this.contents_y_) {
            return false;
        }
        this.contents_x_ = n3;
        this.contents_y_ = n4;
        this.updateScrollBarsValues();
        this.viewcontrol_.redraw();
        return true;
    }

    public ScrollBar getVerticalBar() {
        return this.vertsb_.getVerticalBar();
    }

    public ScrollBar getHorizontalBar() {
        return this.horzsb_.getHorizontalBar();
    }

    public int computeBarVisibility(int n, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        switch (this.v_scrollbar_mode_) {
            case 2: {
                break;
            }
            case 1: {
                n3 |= 1;
                break;
            }
            case 0: {
                if (this.getContentsHeight() <= n2) break;
                n3 = 1;
                if (bl2) break;
                n -= this.getVerticalBarWidth();
            }
        }
        switch (this.h_scrollbar_mode_) {
            case 2: {
                break;
            }
            case 1: {
                n3 |= 2;
                break;
            }
            case 0: {
                if (this.getContentsWidth() <= n) break;
                n3 |= 2;
                if (bl || this.getContentsHeight() <= n2 - this.getHorizontalBarHeight()) break;
                n3 |= 1;
            }
        }
        return n3;
    }

    private boolean updateScrollBarVisiblity() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = this.vertsb_.getVisible();
        boolean bl4 = this.horzsb_.getVisible();
        int n = this.computeBarVisibility(this.getVisibleWidth(), this.getVisibleHeight(), bl4, bl3);
        boolean bl5 = (n & 1) != 0;
        boolean bl6 = bl = (n & 2) != 0;
        if (bl3 ^ bl5) {
            this.vertsb_.setVisible(bl5);
            bl2 = true;
        }
        if (bl4 ^ bl) {
            this.horzsb_.setVisible(bl);
            bl2 = true;
        }
        if (this.corner_control_ != null && bl2) {
            boolean bl7;
            boolean bl8 = bl7 = bl5 || bl;
            if (bl7 ^ this.corner_control_.getVisible()) {
                this.corner_control_.setVisible(bl7);
                bl2 = true;
            }
        }
        return bl2;
    }

    private void updateScrollBarsValues() {
        ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.setMinimum(0);
        scrollBar.setMaximum(this.getContentsHeight());
        scrollBar.setThumb(this.getVisibleHeight());
        scrollBar.setPageIncrement(this.getVisibleHeight());
        scrollBar.setIncrement(this.v_scrollbar_increment_);
        scrollBar.setSelection(this.getContentsY());
        scrollBar = this.getHorizontalBar();
        scrollBar.setMaximum(this.getContentsWidth());
        scrollBar.setThumb(this.getVisibleWidth());
        scrollBar.setSelection(this.getContentsX());
        scrollBar.setPageIncrement(this.getVisibleWidth());
        scrollBar.setIncrement(this.h_scrollbar_increment_);
    }

    public void setCornerControl(Control control) {
        if (this.corner_control_ != null) {
            this.corner_control_.dispose();
        }
        this.corner_control_ = control;
        if (this.corner_control_ != null) {
            ScrollBar scrollBar = this.getVerticalBar();
            ScrollBar scrollBar2 = this.getHorizontalBar();
            boolean bl = scrollBar.getVisible() || scrollBar2.getVisible();
            this.corner_control_.setVisible(bl);
        }
    }

    public final Point viewToContents(int n, int n2) {
        Point point = new Point(this.viewToContentsX(n), this.viewToContentsY(n2));
        return point;
    }

    public int viewToContentsX(int n) {
        return this.contents_x_ + n;
    }

    public int viewToContentsY(int n) {
        return this.contents_y_ + n;
    }

    public final Point contentsToView(int n, int n2) {
        Point point = new Point(this.contentsToViewX(n), this.contentsToViewY(n2));
        return point;
    }

    public int contentsToViewX(int n) {
        return n - this.contents_x_;
    }

    public int contentsToViewY(int n) {
        return n - this.contents_y_;
    }

    public int getVisibleHeight() {
        Rectangle rectangle = this.viewcontrol_.getClientArea();
        return rectangle.height;
    }

    public int getVisibleWidth() {
        Rectangle rectangle = this.viewcontrol_.getClientArea();
        return rectangle.width;
    }

    protected void keyPressedEvent(KeyEvent keyEvent) {
        switch (keyEvent.keyCode) {
            case 0x1000001: {
                this.scrollBy(0, -this.getVisibleHeight());
                break;
            }
            case 0x1000002: {
                this.scrollBy(0, this.getVisibleHeight());
                break;
            }
            case 0x1000003: {
                this.scrollBy(-this.getVisibleWidth(), 0);
                break;
            }
            case 0x1000004: {
                this.scrollBy(this.getVisibleWidth(), 0);
            }
        }
    }

    protected void keyReleasedEvent(KeyEvent keyEvent) {
    }

    protected void viewResized() {
        if (!this.setContentsPos(this.getContentsX(), this.getContentsY())) {
            // empty if block
        }
    }

    public int getVerticalBarWidth() {
        int n = this.vertsb_.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        return n + 1;
    }

    public int getHorizontalBarHeight() {
        int n = this.horzsb_.computeTrim((int)0, (int)0, (int)0, (int)0).height;
        return n + 1;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = this.computeBarVisibility(n3, n4, false, false);
        if ((n5 & 1) != 0) {
            rectangle.width += this.getVerticalBarWidth();
        }
        if ((n5 & 2) != 0) {
            rectangle.height += this.getHorizontalBarHeight();
        }
        return rectangle;
    }

    private class Overview {
        private float overview_factor_x_;
        private float overview_factor_y_;
        private Shell overview;
        private int save_cursor_x;
        private int save_cursor_y;
        private int last_gml_x_;
        private int last_gml_y_;

        private Overview() {
        }

        public void useControl(Control control) {
            control.addMouseListener(new MouseListener(this){
                private final /* synthetic */ Overview this$1;
                {
                    this.this$1 = overview;
                }

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseDown(MouseEvent mouseEvent) {
                    Overview.access$1200(this.this$1, mouseEvent.x, mouseEvent.y);
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    Overview.access$1300(this.this$1);
                }
            });
            control.addMouseMoveListener(new MouseMoveListener(this){
                private final /* synthetic */ Overview this$1;
                {
                    this.this$1 = overview;
                }

                public void mouseMove(MouseEvent mouseEvent) {
                    if (Overview.access$1400(this.this$1)) {
                        Overview.access$1500(this.this$1, mouseEvent);
                    }
                }
            });
        }

        public void dispose() {
            if (this.overview != null) {
                this.overview.dispose();
            }
        }

        private boolean overviewing() {
            return this.overview != null && this.overview.isVisible();
        }

        private void overviewAppear(int n, int n2) {
            int n3;
            int n4;
            if (this.overview == null) {
                this.overview = new Shell(ScrollView.this.getShell(), 16384);
                this.overview.addPaintListener(new PaintListener(this){
                    private final /* synthetic */ Overview this$1;
                    {
                        this.this$1 = overview;
                    }

                    public void paintControl(PaintEvent paintEvent) {
                        Overview.access$1700(this.this$1).drawOverview(paintEvent.gc, Overview.access$1600(this.this$1).getClientArea());
                    }
                });
            }
            this.overview.setBackground(ScrollView.this.viewcontrol_.getBackground());
            this.overview.setForeground(ScrollView.this.viewcontrol_.getForeground());
            Point point = this.toGlobalCoordinates(ScrollView.this.corner_control_, 0, 0);
            int n5 = point.x;
            int n6 = point.y;
            int n7 = n4 = ScrollView.this.overview_size_;
            Rectangle rectangle = ScrollView.this.getDisplay().getBounds();
            Point point2 = ScrollView.this.corner_control_.getSize();
            try {
                float f;
                if (ScrollView.this.contents_width_ > ScrollView.this.contents_height_) {
                    f = (float)ScrollView.this.contents_height_ / (float)ScrollView.this.contents_width_;
                    n4 = (int)((float)n7 * f);
                    if (n4 < point2.y) {
                        n4 = point2.y;
                    } else if (n4 >= rectangle.height / 2) {
                        n4 = rectangle.height / 2;
                    }
                } else {
                    f = (float)ScrollView.this.contents_width_ / (float)ScrollView.this.contents_height_;
                    n7 = (int)((float)n4 * f);
                    if (n7 < point2.x) {
                        n7 = point2.x;
                    } else if (n7 >= rectangle.width / 2) {
                        n7 = rectangle.width / 2;
                    }
                }
                this.overview_factor_x_ = (float)ScrollView.this.contents_width_ / (float)n7;
                this.overview_factor_y_ = (float)ScrollView.this.contents_height_ / (float)n4;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (n5 <= 0) {
                n5 = 1;
            }
            if (n6 <= 0) {
                n6 = 1;
            }
            n5 = n5 - n7 + point2.x;
            n6 = n6 - n4 + point2.y;
            this.overview.setBounds(n5, n6, n7, n4);
            this.overview.setVisible(true);
            this.overview.redraw();
            if (overview_cursor_ == null) {
                RGB[] rGBArray = new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0)};
                PaletteData paletteData = new PaletteData(rGBArray);
                n3 = 1;
                byte[] byArray = new byte[n3 * n3];
                byte[] byArray2 = new byte[n3 * n3];
                int n8 = 0;
                while (n8 < n3 * n3) {
                    byArray[n8] = -1;
                    ++n8;
                }
                ImageData imageData = new ImageData(n3, n3, 1, paletteData, 1, byArray);
                ImageData imageData2 = new ImageData(n3, n3, 1, paletteData, 1, byArray2);
                overview_cursor_ = new Cursor(null, imageData, imageData2, 0, 0);
            }
            ScrollView.this.corner_control_.setCursor(overview_cursor_);
            point = this.toGlobalCoordinates(ScrollView.this.corner_control_, n, n2);
            this.save_cursor_x = point.x;
            this.save_cursor_y = point.y;
            Rectangle rectangle2 = this.overview.getClientArea();
            int n9 = (int)((float)(rectangle2.width * ScrollView.this.contents_x_) / (float)ScrollView.this.contents_width_);
            n3 = (int)((float)(rectangle2.height * ScrollView.this.contents_y_) / (float)ScrollView.this.contents_height_);
            point = this.toGlobalCoordinates((Control)this.overview.getParent(), n9, n3);
            n9 = point.x;
            n3 = point.y;
            ScrollView.this.getDisplay().setCursorLocation(n9, n3);
            this.last_gml_x_ = n9;
            this.last_gml_y_ = n3;
        }

        private void overviewDisappear() {
            if (this.overview == null) {
                return;
            }
            this.overview.setVisible(false);
            ScrollView.this.corner_control_.setCursor(null);
            ScrollView.this.getDisplay().setCursorLocation(this.save_cursor_x, this.save_cursor_y);
        }

        private void overviewMove(MouseEvent mouseEvent) {
            Point point = this.toGlobalCoordinates(ScrollView.this.corner_control_, mouseEvent.x, mouseEvent.y);
            int n = point.x - this.last_gml_x_;
            int n2 = point.y - this.last_gml_y_;
            this.last_gml_x_ = point.x;
            this.last_gml_y_ = point.y;
            int n3 = ScrollView.this.contents_x_;
            int n4 = ScrollView.this.contents_y_;
            boolean bl = (mouseEvent.stateMask & 0x40000) != 0;
            boolean bl2 = (mouseEvent.stateMask & 0x20000) != 0;
            float f = this.overview_factor_x_;
            float f2 = this.overview_factor_y_;
            if (bl && bl2) {
                f2 = 1.0f;
                f = 1.0f;
            } else if (bl) {
                f *= 0.1f;
                f2 *= 0.1f;
            } else if (bl2) {
                f *= 0.25f;
                f2 *= 0.25f;
            }
            ScrollView.this.scrollBy((int)(f * (float)n), (int)(f2 * (float)n2));
            if (n3 != ScrollView.this.contents_x_ || n4 != ScrollView.this.contents_y_) {
                this.overview.redraw();
                this.overview.update();
            }
        }

        protected Point toGlobalCoordinates(Control control, int n, int n2) {
            Point point = new Point(n, n2);
            Control control2 = control;
            while (control2 != null) {
                int n3 = 0;
                int n4 = 0;
                if (control2 instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)control2;
                    Rectangle rectangle = scrollable.getClientArea();
                    Rectangle rectangle2 = scrollable.computeTrim(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    n3 = rectangle.x - rectangle2.x;
                    n4 = rectangle.y - rectangle2.y;
                }
                point.x += control2.getLocation().x + n3;
                point.y += control2.getLocation().y + n4;
                control2 = control2.getParent();
            }
            return point;
        }

        static /* synthetic */ void access$1200(Overview overview, int n, int n2) {
            overview.overviewAppear(n, n2);
        }

        static /* synthetic */ void access$1300(Overview overview) {
            overview.overviewDisappear();
        }

        static /* synthetic */ boolean access$1400(Overview overview) {
            return overview.overviewing();
        }

        static /* synthetic */ void access$1500(Overview overview, MouseEvent mouseEvent) {
            overview.overviewMove(mouseEvent);
        }

        static /* synthetic */ Shell access$1600(Overview overview) {
            return overview.overview;
        }

        static /* synthetic */ ScrollView access$1700(Overview overview) {
            return overview.ScrollView.this;
        }
    }

    private class SVLayout
    extends Layout {
        private boolean first_layout = true;
        int seek = 0;
        boolean dont_layout = false;

        private SVLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point = new Point(250, 250);
            if (ScrollView.this.contents_width_ < point.x) {
                point.x = ScrollView.this.contents_width_;
            }
            if (ScrollView.this.contents_height_ < point.y) {
                point.y = ScrollView.this.contents_height_;
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            if (this.dont_layout) {
                return;
            }
            ++this.seek;
            if (this.seek > 10) {
                this.dont_layout = true;
            }
            Point point = composite.getSize();
            int n = ScrollView.this.computeBarVisibility(point.x, point.y, false, false);
            boolean bl2 = (n & 1) != 0;
            boolean bl3 = (n & 2) != 0;
            ScrollView.this.vertsb_.setVisible(bl2);
            ScrollView.this.horzsb_.setVisible(bl3);
            int n2 = ScrollView.this.getVerticalBarWidth();
            int n3 = ScrollView.this.getHorizontalBarHeight();
            int n4 = bl2 ? n2 : 0;
            int n5 = bl3 ? n3 : 0;
            int n6 = 0;
            int n7 = 0;
            if (ScrollView.this.corner_control_ != null && (bl2 || bl3)) {
                ScrollView.this.corner_control_.setVisible(true);
                n6 = n2;
                n7 = n3;
                if (n4 == 0) {
                    n4 = n2;
                }
                if (n5 == 0) {
                    n5 = n3;
                }
            } else if (bl2 && bl3) {
                if (ScrollView.this.corner_control_ != null) {
                    ScrollView.this.corner_control_.setVisible(false);
                }
                n6 = n2;
                n7 = n3;
            }
            if (bl2 || bl3) {
                ScrollView.this.updateScrollBarsValues();
            }
            int n8 = point.x - (bl2 ? n2 : 0);
            int n9 = point.y - (bl3 ? n3 : 0);
            int n10 = point.x - n4;
            int n11 = point.y - n5;
            Rectangle rectangle = ScrollView.this.viewcontrol_.getClientArea();
            int n12 = rectangle.width;
            int n13 = rectangle.height;
            ScrollView.this.viewcontrol_.setBounds(0, 0, n8, n9);
            boolean bl4 = false;
            rectangle = ScrollView.this.viewcontrol_.getClientArea();
            if (n12 != rectangle.width || n13 != rectangle.height) {
                bl4 = true;
            }
            if (bl2) {
                ScrollView.this.vertsb_.setBounds(n10, 0, n4, point.y - n7);
            }
            if (bl3) {
                ScrollView.this.horzsb_.setBounds(0, n11, point.x - n6, n5);
            }
            if (ScrollView.this.corner_control_ != null && ScrollView.this.corner_control_.getVisible()) {
                ScrollView.this.corner_control_.setBounds(n10, n11, n2, n3);
            }
            ScrollView.this.updateScrollBarsValues();
            if (bl4) {
                ScrollView.this.viewResized();
            }
            --this.seek;
            if (this.seek == 0) {
                this.dont_layout = false;
            }
        }
    }

    private static class AutoScroll
    extends TimerTask {
        public int dx_;
        public int dy_;
        public ScrollView sv_;

        public AutoScroll(ScrollView scrollView, int n, int n2) {
            this.sv_ = scrollView;
            this.dx_ = n;
            this.dy_ = n2;
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ AutoScroll this$0;
                {
                    this.this$0 = autoScroll;
                }

                public void run() {
                    this.this$0.sv_.scrollBy(this.this$0.dx_, this.this$0.dy_);
                }
            });
        }
    }
}

