/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.loaders.util.RegistryReader;

class HyadesResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_FACTORY = "hyadesResourceFactory";
    static final String ATT_FILE_POSTFIX = "filePostfix";
    static final String ATT_CLASS = "class";

    public HyadesResourceRegistryReader() {
        super("hyades_resource_factory");
    }

    protected boolean readElement(HyadesConfigurationElement hyadesConfigurationElement) {
        if (hyadesConfigurationElement.getName().equals(TAG_RESOURCE_FACTORY)) {
            String string = hyadesConfigurationElement.getAttribute(ATT_FILE_POSTFIX);
            if (string == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_FILE_POSTFIX);
            } else if (hyadesConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_CLASS);
            } else if (HyadesResourceExtensions.getInstance().containsKey(string)) {
                this.logError(hyadesConfigurationElement, "A Hyades resource extension for this \"" + string + "\" already exists, this extension will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor iHyadesPluginClassDescriptor = this.createPluginClassDescriptor(hyadesConfigurationElement, ATT_CLASS);
                    HyadesResourceExtensions.getInstance().put(string, (IHyadesResourceFactory)iHyadesPluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

