/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

class LoaderRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "loader";
    static final String ATT_ELEMENT_NAME = "elementName";
    static final String ATT_CLASS = "class";

    public LoaderRegistryReader() {
        super("fragment_loader");
    }

    protected boolean readElement(HyadesConfigurationElement hyadesConfigurationElement) {
        if (hyadesConfigurationElement.getName().equals(TAG_LOADER)) {
            String string = hyadesConfigurationElement.getAttribute(ATT_ELEMENT_NAME);
            if (string == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_ELEMENT_NAME);
            } else if (hyadesConfigurationElement.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(hyadesConfigurationElement, ATT_CLASS);
            } else if (LoaderExtensions.getInstance().containsKey(string)) {
                this.logError(hyadesConfigurationElement, "A loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor iHyadesPluginClassDescriptor = this.createPluginClassDescriptor(hyadesConfigurationElement, ATT_CLASS);
                    LoaderExtensions.getInstance().put(string, (XMLFragmentLoader)iHyadesPluginClassDescriptor.createInstance());
                }
                catch (Exception exception) {
                    this.logError(hyadesConfigurationElement, exception.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

