/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLevel;

public final class CommonBaseEventLogRecord
extends LogRecord
implements IExternalizableToXml {
    private CommonBaseEvent commonBaseEvent = null;
    private static EventFactory eventFactory = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory("org.eclipse.hyades.logging.java.CommonBaseEventLogRecord");
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL = "level";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME = "name";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE = "value";
    public static final String EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME = "loggerName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER = "sequenceNumber";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME = "sourceClassName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME = "sourceMethodName";
    public static final String EXTENDED_DATA_ELEMENT_NAME_THREAD_ID = "threadID";
    public static final String EXTENDED_DATA_ELEMENT_NAME_THROWN = "stackTrace";

    public CommonBaseEventLogRecord(CommonBaseEvent commonBaseEvent) {
        super(Level.OFF, null);
        if (commonBaseEvent != null) {
            this.commonBaseEvent = commonBaseEvent;
            short s = commonBaseEvent.getSeverity();
            if (s >= 50) {
                this.setLevel(Level.SEVERE);
            } else if (s >= 30 && s <= 49) {
                this.setLevel(Level.WARNING);
            } else {
                this.setLevel(Level.INFO);
            }
            this.setSequenceNumber(super.getSequenceNumber());
            this.setThreadID(super.getThreadID());
            if (!commonBaseEvent.isSetCreationTime()) {
                commonBaseEvent.setCreationTimeAsLong(System.currentTimeMillis());
            }
        }
    }

    public CommonBaseEventLogRecord(Level level, String string) {
        super(level, string);
    }

    public CommonBaseEventLogRecord(Level level) {
        super(level, null);
    }

    public CommonBaseEventLogRecord(LogRecord logRecord) {
        super(logRecord.getLevel(), logRecord.getMessage());
        super.setMillis(logRecord.getMillis());
        super.setSequenceNumber(logRecord.getSequenceNumber());
        super.setThreadID(logRecord.getThreadID());
        super.setLoggerName(logRecord.getLoggerName());
        super.setParameters(logRecord.getParameters());
        super.setResourceBundle(logRecord.getResourceBundle());
        super.setResourceBundleName(logRecord.getResourceBundleName());
        super.setSourceClassName(logRecord.getSourceClassName());
        super.setSourceMethodName(logRecord.getSourceMethodName());
        super.setThrown(logRecord.getThrown());
    }

    public void setCommonBaseEvent(CommonBaseEvent commonBaseEvent) {
        this.commonBaseEvent = commonBaseEvent;
    }

    public void setLevel(Level level) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            extendedDataElement.addChild(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME, level.getName());
            extendedDataElement.addChildWithIntValue(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE, level.intValue());
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setLevel(level);
        }
    }

    public void setLoggerName(String string) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            extendedDataElement.setValuesAsString(string);
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setLoggerName(string);
        }
    }

    public void setMessage(String string) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = eventFactory.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalogId(string);
        } else {
            super.setMessage(string);
        }
    }

    public void setMillis(long l) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.setCreationTimeAsLong(l);
        } else {
            super.setMillis(l);
        }
    }

    public void setParameters(Object[] objectArray) {
        super.setParameters(objectArray);
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (objectArray != null) {
                if (msgDataElement == null) {
                    msgDataElement = eventFactory.createMsgDataElement();
                    this.commonBaseEvent.setMsgDataElement(msgDataElement);
                }
                MsgCatalogToken[] msgCatalogTokenArray = new MsgCatalogToken[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    msgCatalogTokenArray[n] = eventFactory.createMsgCatalogToken();
                    msgCatalogTokenArray[n].setValue(String.valueOf(objectArray[n]));
                    ++n;
                }
                msgDataElement.setMsgCatalogTokens(msgCatalogTokenArray);
            } else {
                msgDataElement.clearMsgCatalogTokens();
            }
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        super.setResourceBundle(resourceBundle);
    }

    public void setResourceBundleName(String string) {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement == null) {
                msgDataElement = eventFactory.createMsgDataElement();
                this.commonBaseEvent.setMsgDataElement(msgDataElement);
            }
            msgDataElement.setMsgCatalog(string);
            msgDataElement.setMsgCatalogType("Java");
        } else {
            super.setResourceBundleName(string);
        }
    }

    public void setSequenceNumber(long l) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            extendedDataElement.setValuesAsLong(l);
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setSequenceNumber(l);
        }
    }

    public void setSourceClassName(String string) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            extendedDataElement.setValuesAsString(string);
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setSourceClassName(string);
        }
    }

    public void setSourceMethodName(String string) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            extendedDataElement.setValuesAsString(string);
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setSourceMethodName(string);
        }
    }

    public void setThreadID(int n) {
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            extendedDataElement.setValuesAsInt(n);
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        } else {
            super.setThreadID(n);
        }
    }

    public void setThrown(Throwable throwable) {
        super.setThrown(throwable);
        if (this.commonBaseEvent != null) {
            this.commonBaseEvent.removeExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THROWN);
            ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
            extendedDataElement.setName(EXTENDED_DATA_ELEMENT_NAME_THROWN);
            extendedDataElement.setValuesAsString(String.valueOf(throwable));
            this.commonBaseEvent.addExtendedDataElement(extendedDataElement);
        }
    }

    public CommonBaseEvent getCommonBaseEvent() {
        return this.commonBaseEvent;
    }

    public Level getLevel() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LEVEL);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                EList eList2 = extendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_NAME);
                EList eList3 = extendedDataElement.getChildren(EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE);
                if (eList2 != null && eList2.size() > 0 && eList3 != null && eList3.size() > 0) {
                    ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
                    ExtendedDataElement extendedDataElement3 = (ExtendedDataElement)eList3.get(0);
                    String string = extendedDataElement2.getValuesAsString();
                    if (string != null) {
                        try {
                            return Level.parse(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    return new CommonBaseEventLevel(string, extendedDataElement3.getValuesAsInt());
                }
            }
            return Level.INFO;
        }
        return super.getLevel();
    }

    public String getLoggerName() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                return extendedDataElement.getValuesAsString();
            }
        } else {
            return super.getLoggerName();
        }
        return null;
    }

    public String getMessage() {
        if (this.commonBaseEvent != null) {
            String string;
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null && (string = msgDataElement.getMsgCatalogId()) != null) {
                return string;
            }
        } else {
            return super.getMessage();
        }
        return this.commonBaseEvent.getMsg();
    }

    public long getMillis() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.getCreationTimeAsLong();
        }
        return super.getMillis();
    }

    public Object[] getParameters() {
        Object[] objectArray;
        MsgDataElement msgDataElement;
        Object[] objectArray2 = super.getParameters();
        if (objectArray2 != null) {
            return objectArray2;
        }
        if (this.commonBaseEvent != null && (msgDataElement = this.commonBaseEvent.getMsgDataElement()) != null && (objectArray = msgDataElement.getMsgCatalogTokensAsStrings()) != null && objectArray.length > 0) {
            return objectArray;
        }
        return null;
    }

    public ResourceBundle getResourceBundle() {
        return super.getResourceBundle();
    }

    public String getResourceBundleName() {
        if (this.commonBaseEvent != null) {
            MsgDataElement msgDataElement = this.commonBaseEvent.getMsgDataElement();
            if (msgDataElement != null) {
                return msgDataElement.getMsgCatalog();
            }
        } else {
            return super.getResourceBundleName();
        }
        return null;
    }

    public long getSequenceNumber() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SEQUENCE_NUMBER);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                return extendedDataElement.getValuesAsLong();
            }
        } else {
            return super.getSequenceNumber();
        }
        return 0L;
    }

    public String getSourceClassName() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                return extendedDataElement.getValuesAsString();
            }
        } else {
            return super.getSourceClassName();
        }
        return null;
    }

    public String getSourceMethodName() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                return extendedDataElement.getValuesAsString();
            }
        } else {
            return super.getSourceMethodName();
        }
        return null;
    }

    public int getThreadID() {
        if (this.commonBaseEvent != null) {
            EList eList = this.commonBaseEvent.getExtendedDataElements(EXTENDED_DATA_ELEMENT_NAME_THREAD_ID);
            if (eList != null && eList.size() > 0) {
                ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(0);
                return extendedDataElement.getValuesAsInt();
            }
        } else {
            return super.getThreadID();
        }
        return 0;
    }

    public Throwable getThrown() {
        return super.getThrown();
    }

    public String externalizeCanonicalXmlString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLString((CommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    public String externalizeCanonicalXmlDocString() {
        if (this.commonBaseEvent != null) {
            return EventFormatter.toCanonicalXMLDocString((CommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    public String toString() {
        if (this.commonBaseEvent != null) {
            return this.commonBaseEvent.toString();
        }
        return super.toString();
    }
}

