/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.java.XmlFormatter;

public class LoggingAgentHandler
extends Handler {
    public static final String DEFAULT_LOGGER_NAME = "Default Logging IRemoteEntity";
    private HashMap loggingAgents = new HashMap();
    private Object currentThreadLock = new Object();

    public LoggingAgentHandler() {
        Class<?> clazz;
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        String string2 = logManager.getProperty(string.concat(".level"));
        if (string2 == null) {
            this.setLevel(Level.INFO);
        } else {
            try {
                this.setLevel(Level.parse(string2.trim()));
            }
            catch (Throwable throwable) {
                this.setLevel(Level.INFO);
            }
        }
        string2 = logManager.getProperty(string.concat(".filter"));
        if (string2 == null) {
            this.setFilter(null);
        } else {
            try {
                clazz = ClassLoader.getSystemClassLoader().loadClass(string2.trim());
                this.setFilter((Filter)clazz.newInstance());
            }
            catch (Throwable throwable) {
                this.setFilter(null);
            }
        }
        string2 = logManager.getProperty(string.concat(".formatter"));
        if (string2 == null) {
            this.setFormatter(new XmlFormatter());
        } else {
            try {
                clazz = ClassLoader.getSystemClassLoader().loadClass(string2.trim());
                this.setFormatter((Formatter)clazz.newInstance());
            }
            catch (Throwable throwable) {
                this.setFormatter(new XmlFormatter());
            }
        }
        string2 = logManager.getProperty(string.concat(".encoding"));
        if (string2 == null) {
            try {
                this.setEncoding(null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            try {
                this.setEncoding(string2.trim());
            }
            catch (Throwable throwable) {
                try {
                    this.setEncoding(null);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            String string = null;
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                try {
                    string = formatter.format(logRecord);
                }
                catch (Exception exception) {
                    this.writeError(null, exception, 5);
                    return;
                }
            } else {
                string = logRecord.toString();
            }
            LoggingAgent loggingAgent = null;
            String string2 = logRecord.getLoggerName();
            if (string2 != null && string2.trim().length() != 0) {
                Object object = this.currentThreadLock;
                synchronized (object) {
                    if (this.loggingAgents.containsKey(string2)) {
                        loggingAgent = (LoggingAgent)this.loggingAgents.get(string2);
                    } else {
                        loggingAgent = new LoggingAgent(string2);
                        this.loggingAgents.put(string2, loggingAgent);
                    }
                }
            }
            Object object = this.currentThreadLock;
            synchronized (object) {
                if (this.loggingAgents.containsKey(DEFAULT_LOGGER_NAME)) {
                    loggingAgent = (LoggingAgent)this.loggingAgents.get(DEFAULT_LOGGER_NAME);
                } else {
                    loggingAgent = new LoggingAgent(DEFAULT_LOGGER_NAME);
                    this.loggingAgents.put(DEFAULT_LOGGER_NAME, loggingAgent);
                }
            }
            loggingAgent.write(string);
        }
    }

    public void flush() {
        Iterator iterator = this.loggingAgents.values().iterator();
        while (iterator.hasNext()) {
            ((LoggingAgent)iterator.next()).flush();
        }
    }

    public void close() {
        Iterator iterator = this.loggingAgents.values().iterator();
        while (iterator.hasNext()) {
            LoggingAgent loggingAgent = (LoggingAgent)iterator.next();
            loggingAgent.flush();
            loggingAgent.deregister();
        }
    }

    private void writeError(String string, Exception exception, int n) {
        try {
            this.getErrorManager().error(string, exception, n);
        }
        catch (Throwable throwable) {
            System.err.println("Error: " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

