/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.preference;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorter
extends ViewerSorter {
    private static final String ASC_SYMBOL = "^";
    private static final String DESC_SYMBOL = ".";
    private TableViewer tableViewer;
    private int currentColumn;
    private boolean asc;
    private boolean addDirectionSymbol;
    private SelectionListener headerListener;

    public TableViewerSorter(TableViewer tableViewer, int n, boolean bl, boolean bl2, boolean bl3) {
        this.tableViewer = tableViewer;
        this.addDirectionSymbol = bl2;
        this.setSort(n, bl);
        tableViewer.setSorter((ViewerSorter)this);
        if (bl3) {
            this.addColumnHeaderListeners();
        }
    }

    public static void setTableSorter(TableViewer tableViewer, int n, boolean bl) {
        new TableViewerSorter(tableViewer, n, bl, false, true);
    }

    private void initializeHeaderListener() {
        this.headerListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn;
                String string = null;
                if (TableViewerSorter.this.currentColumn >= 0) {
                    tableColumn = TableViewerSorter.this.tableViewer.getTable().getColumn(TableViewerSorter.this.currentColumn);
                    if (TableViewerSorter.this.addDirectionSymbol && tableColumn != null && (string = tableColumn.getText()) != null && (string.startsWith(TableViewerSorter.ASC_SYMBOL) || string.startsWith(TableViewerSorter.DESC_SYMBOL))) {
                        string = string.substring(1);
                        tableColumn.setText(string);
                    }
                }
                tableColumn = (TableColumn)selectionEvent.widget;
                string = tableColumn.getText();
                int n = TableViewerSorter.this.tableViewer.getTable().indexOf(tableColumn);
                if (n == TableViewerSorter.this.currentColumn) {
                    TableViewerSorter.this.asc = !TableViewerSorter.this.asc;
                } else {
                    TableViewerSorter.this.asc = true;
                    TableViewerSorter.this.currentColumn = n;
                }
                if (TableViewerSorter.this.addDirectionSymbol && string != null) {
                    string = TableViewerSorter.this.asc ? TableViewerSorter.ASC_SYMBOL + string : TableViewerSorter.DESC_SYMBOL + string;
                    tableColumn.setText(string);
                }
                TableViewerSorter.this.tableViewer.getTable().setRedraw(false);
                TableViewerSorter.this.tableViewer.refresh();
                TableViewerSorter.this.tableViewer.getTable().setRedraw(true);
            }
        };
    }

    public void addColumnHeaderListeners() {
        int n = 0;
        int n2 = this.tableViewer.getTable().getColumnCount();
        while (n < n2) {
            TableColumn tableColumn = this.tableViewer.getTable().getColumn(n);
            tableColumn.removeSelectionListener(this.getHeaderListener());
            tableColumn.addSelectionListener(this.getHeaderListener());
            ++n;
        }
    }

    public void setSort(int n) {
        this.currentColumn = n;
    }

    public void setSort(int n, boolean bl) {
        this.setSort(n);
        this.setSort(bl);
    }

    public void setSort(boolean bl) {
        this.asc = bl;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public SelectionListener getHeaderListener() {
        if (this.headerListener == null) {
            this.initializeHeaderListener();
        }
        return this.headerListener;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        if (viewer != this.tableViewer) {
            return super.compare(viewer, object, object2);
        }
        int n = this.compareAsc(object, object2);
        return this.asc ? n : -1 * n;
    }

    protected int compareAsc(Object object, Object object2) {
        int n = super.compare((Viewer)this.tableViewer, object, object2);
        IBaseLabelProvider iBaseLabelProvider = this.tableViewer.getLabelProvider();
        if (iBaseLabelProvider == null || !(iBaseLabelProvider instanceof ITableLabelProvider)) {
            return n;
        }
        ITableLabelProvider iTableLabelProvider = (ITableLabelProvider)iBaseLabelProvider;
        String string = iTableLabelProvider.getColumnText(object, this.currentColumn);
        String string2 = iTableLabelProvider.getColumnText(object2, this.currentColumn);
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return this.compareAsc(string, string2);
    }

    protected int compareAsc(String string, String string2) {
        return string.compareToIgnoreCase(string2);
    }
}

