/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateProperties
extends Dialog {
    private String alias;
    private Object cert;

    public CertificateProperties(Shell shell) {
        super(shell);
    }

    public void init(String string, Object object) {
        this.alias = string;
        this.cert = object;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 450;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(SecurityPlugin.getResourceString("STR_PROP_ALIAS_LBL"));
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText(this.alias);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        label2.setLayoutData((Object)gridData);
        Label label3 = new Label(composite2, 0);
        label3.setText(SecurityPlugin.getResourceString("STR_CERTIF_VERSION_LBL"));
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label3.setLayoutData((Object)gridData);
        Label label4 = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        label4.setLayoutData((Object)gridData);
        Label label5 = new Label(composite2, 0);
        label5.setText(SecurityPlugin.getResourceString("STR_ISSUED_TO_LBL"));
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.horizontalIndent = 5;
        label5.setLayoutData((Object)gridData);
        Text text = new Text(composite2, 2120);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.horizontalIndent = 5;
        text.setLayoutData((Object)gridData);
        Label label6 = new Label(composite2, 0);
        label6.setText(SecurityPlugin.getResourceString("STR_ISSUED_BY_LBL"));
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.verticalAlignment = 1;
        label6.setLayoutData((Object)gridData);
        Text text2 = new Text(composite2, 2120);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        gridData.heightHint = 60;
        text2.setLayoutData((Object)gridData);
        Label label7 = new Label(composite2, 0);
        label7.setText(SecurityPlugin.getResourceString("STR_VALIDITY_LBL"));
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label7.setLayoutData((Object)gridData);
        Label label8 = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        label8.setLayoutData((Object)gridData);
        Label label9 = new Label(composite2, 0);
        label9.setText(SecurityPlugin.getResourceString("STR_ALGORITHM_LBL"));
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label9.setLayoutData((Object)gridData);
        Label label10 = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        label10.setLayoutData((Object)gridData);
        if (this.cert instanceof X509Certificate) {
            label4.setText(((X509Certificate)this.cert).getType() + " V." + ((X509Certificate)this.cert).getVersion());
            text.setText(((X509Certificate)this.cert).getSubjectDN().getName());
            text2.setText(((X509Certificate)this.cert).getIssuerDN().getName());
            DateFormat dateFormat = DateFormat.getDateInstance(1);
            String string = SecurityPlugin.getResourceString("STR_VALIDITY_PERIOD");
            string = TString.change(string, "%1", dateFormat.format(((X509Certificate)this.cert).getNotBefore()));
            string = TString.change(string, "%2", dateFormat.format(((X509Certificate)this.cert).getNotAfter()));
            label8.setText(string);
            label10.setText(((X509Certificate)this.cert).getSigAlgName());
        } else if (this.cert instanceof Key) {
            label4.setText(((Key)this.cert).getFormat());
            label10.setText(((Key)this.cert).getAlgorithm());
        }
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }
}

