/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class DirectiveDetails
extends Composite
implements IDetails,
Listener {
    private CCombo cmbDirective;
    private Text txtInfo;
    private Text txtFFDC;
    private ArrayList directiveRegistry = null;
    private SymptomDBEditor editor;
    private SDBFactoryImpl objFactory = null;
    private SDBDirective currentSel = null;
    private boolean isDisplaying = false;
    private final String NL = System.getProperties().getProperty("line.separator");

    public DirectiveDetails(RASWidgetFactory rASWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_DIRECTIVE_LABEL"), 0);
        this.cmbDirective = rASWidgetFactory.createCombo(this, 8);
        GridData gridData = new GridData(768);
        gridData.widthHint = 350;
        this.cmbDirective.setLayoutData((Object)gridData);
        rASWidgetFactory.createCompositeSeparator(this);
        Label label2 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_DIRECTIVE_DESC_LABEL"), 0);
        GridData gridData2 = new GridData(768);
        label2.setLayoutData((Object)gridData2);
        this.txtInfo = rASWidgetFactory.createText(this, "", 770);
        GridData gridData3 = new GridData(1808);
        gridData3.widthHint = 350;
        this.txtInfo.setLayoutData((Object)gridData3);
        Label label3 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_FFDC_LABEL"), 0);
        gridData2 = new GridData(768);
        label3.setLayoutData((Object)gridData2);
        this.txtFFDC = rASWidgetFactory.createText(this, "", 0);
        gridData3 = new GridData(768);
        gridData3.widthHint = 350;
        this.txtFFDC.setLayoutData((Object)gridData3);
        WorkbenchHelp.setHelp((Control)this.cmbDirective, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE);
        WorkbenchHelp.setHelp((Control)this.txtInfo, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE_DESCRIPTION);
        WorkbenchHelp.setHelp((Control)this.txtFFDC, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE_FFDC);
        this.cmbDirective.addListener(13, (Listener)this);
        this.txtInfo.addListener(24, (Listener)this);
        this.txtFFDC.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.editor = symptomDBEditor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        EList eList = symptomDBEditor.getModel().getDirectives();
        this.cmbDirective.add(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
        int n = 0;
        while (n < eList.size()) {
            this.cmbDirective.add(this.getFirstLineFrom(((SDBDirective)eList.get(n)).getDescription()));
            ++n;
        }
        this.directiveRegistry = new ArrayList();
        SDBDirective sDBDirective = this.objFactory.createSDBDirective();
        sDBDirective.setDescription(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
        sDBDirective.setDirectiveString("");
        this.directiveRegistry.add(0, sDBDirective);
        this.directiveRegistry.addAll(eList);
    }

    public void display(EObject eObject) {
        this.isDisplaying = true;
        this.currentSel = (SDBDirective)eObject;
        String string = this.currentSel.getDescription();
        this.txtInfo.setText(string);
        this.cmbDirective.setText(this.getFirstLineFrom(string));
        this.txtFFDC.setText(this.currentSel.getDirectiveString());
        if (this.directiveRegistry.indexOf(this.currentSel) > -1) {
            this.txtInfo.setText(string);
            this.cmbDirective.setText(this.getFirstLineFrom(string));
            this.cmbDirective.setEnabled(false);
            this.txtFFDC.setText(this.currentSel.getDirectiveString());
        } else {
            this.cmbDirective.setEnabled(true);
            this.cmbDirective.select(0);
        }
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtInfo.setFocus();
        this.txtInfo.setSelection(0, this.txtInfo.getText().length());
    }

    public boolean updateCurrentSelection(EObject eObject) {
        if (this.cmbDirective.getSelectionIndex() == 0) {
            this.currentSel = (SDBDirective)eObject;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            if (this.directiveRegistry.indexOf(this.currentSel) < 0) {
                this.updateDirectiveRegistry(this.currentSel, true);
            }
        } else if (this.cmbDirective.isEnabled()) {
            SDBSolution sDBSolution = (SDBSolution)this.editor.detailsPage.getParentOfCurrentSel();
            SDBRuntime sDBRuntime = (SDBRuntime)this.editor.detailsPage.getTreeRoot();
            this.updateDirectiveRegistry(this.currentSel, false);
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            this.currentSel.getSolutions().add((Object)sDBSolution);
            this.updateDirectiveRegistry(this.currentSel, true);
            this.removeNewDirective((SDBDirective)eObject, sDBSolution, sDBRuntime);
        } else {
            this.updateDirectiveRegistry(this.currentSel, false);
            this.currentSel = (SDBDirective)eObject;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            this.updateDirectiveRegistry(this.currentSel, true);
        }
        return true;
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.cmbDirective || widget == this.txtInfo || widget == this.txtFFDC) {
            boolean bl = false;
            if (widget == this.cmbDirective) {
                int n = this.cmbDirective.getSelectionIndex();
                this.currentSel = (SDBDirective)this.directiveRegistry.get(n);
                this.txtInfo.setText(this.currentSel.getDescription());
                this.txtFFDC.setText(this.currentSel.getDirectiveString());
            }
            if (widget == this.txtInfo && !this.isDisplaying) {
                bl = this.editor.validateState((Widget)this.txtInfo, this, this.currentSel.getDescription());
            }
            if (widget == this.txtFFDC && !this.isDisplaying) {
                bl = this.editor.validateState((Widget)this.txtFFDC, this, this.currentSel.getDirectiveString());
            }
            if (this.currentSel != null && !this.isDisplaying && bl) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    private void removeNewDirective(SDBDirective sDBDirective, SDBSolution sDBSolution, SDBRuntime sDBRuntime) {
        sDBSolution.getDirectives().remove((Object)sDBDirective);
        sDBRuntime.getDirectives().remove((Object)sDBDirective);
        sDBDirective.getSolutions().remove((Object)sDBSolution);
        this.directiveRegistry.remove(sDBDirective);
    }

    protected void updateDirectiveRegistry(SDBDirective sDBDirective, boolean bl) {
        if (bl) {
            this.directiveRegistry.add(sDBDirective);
            this.cmbDirective.add(this.getFirstLineFrom(sDBDirective.getDescription()));
        } else if (this.directiveRegistry.indexOf(sDBDirective) > -1) {
            this.cmbDirective.remove(this.directiveRegistry.indexOf(sDBDirective));
            this.directiveRegistry.remove(sDBDirective);
        }
    }

    private String getFirstLineFrom(String string) {
        int n = 0;
        String string2 = string;
        n = string.indexOf("\r\n");
        if (n > -1) {
            string2 = string.substring(0, n);
        } else {
            n = string.indexOf("\n");
            if (n > -1) {
                string2 = string.substring(0, n);
            }
        }
        return string2;
    }

    private String getDirectiveStringFrom(String string) {
        int n = 0;
        String string2 = "";
        n = string.indexOf("\r\n");
        if (n > -1) {
            string2 = string.substring(n + 2);
        } else {
            n = string.indexOf("\n");
            if (n > -1) {
                string2 = string.substring(n + 1);
            }
        }
        return string2;
    }
}

