/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.extractors.SimpleExtractor;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class RegularExpressionExtractor
extends SimpleExtractor {
    private Pattern compiledStartPattern;
    private Pattern compiledEndPattern;

    public void update() throws AdapterInvalidConfig {
        super.update();
        if (this.getStartPattern() != null && !this.getStartPattern().equals("")) {
            try {
                this.compiledStartPattern = Pattern.compile(this.getStartPattern(), 8);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_Start_Pattern_Invalid_ERROR_", patternSyntaxException.getMessage()));
            }
        }
        if (this.getEndPattern() != null && !this.getEndPattern().equals("")) {
            try {
                this.compiledEndPattern = Pattern.compile(this.getEndPattern(), 8);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_End_Pattern_Invalid_ERROR_", patternSyntaxException.getMessage()));
            }
        }
    }

    protected void search(SimpleExtractor.StringPosition stringPosition, String string, String string2, int n) {
        String string3;
        boolean bl = false;
        Pattern pattern = null;
        pattern = string == this.getStartPattern() ? this.compiledStartPattern : this.compiledEndPattern;
        Matcher matcher = pattern.matcher(string3 = string2.substring(n));
        bl = matcher.find();
        if (bl) {
            if (matcher.start() == matcher.end()) {
                int n2 = n + matcher.start();
                stringPosition.setStartPosition(n2);
                stringPosition.setEndPosition(n2);
            } else {
                stringPosition.setStartPosition(n + matcher.start());
                stringPosition.setEndPosition(n + matcher.end() - 1);
            }
            stringPosition.setValid(true);
        }
    }
}

