/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.Extractor;

public class SimpleExtractor
extends Extractor {
    private static final int MESSAGE_STRING_ARRAY_SIZE = 8;
    protected StringArray inputs;
    private String localLineSeparator = System.getProperty("line.separator");

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.inputs = new StringArray();
    }

    public MessageString[] processStrings(String[] stringArray) {
        MessageString[] messageStringArray = null;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.inputs.enqueueString(stringArray[n]);
                }
                stringArray[n] = null;
                ++n;
            }
        }
        if (this.inputs == null || this.inputs.lastAddedString == this.inputs.lastRemovedString) {
            return null;
        }
        messageStringArray = !this.getContainsLineBreaks() ? this.processSeparateLines() : this.processMultipleLines();
        return messageStringArray;
    }

    private MessageString[] processSeparateLines() {
        return this.processMultipleLines();
    }

    private MessageString[] processMultipleLines() {
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        String string = this.buildString(this.inputs, this.inputs.lastRemovedString + 1, 0, this.inputs.lastAddedString, this.inputs.contents[this.inputs.lastAddedString].length() - 1);
        StringPosition stringPosition = new StringPosition();
        StringPosition stringPosition2 = new StringPosition();
        string = this.processSearchString(arrayList, string, stringPosition, stringPosition2);
        String string2 = null;
        if (stringPosition.isValid()) {
            if (!stringPosition2.isValid() && !this.flushingMode) {
                string2 = string.substring(stringPosition.getStartPosition(), string.length());
            }
        } else {
            string2 = string;
        }
        this.inputs.flush();
        if (string2 != null) {
            this.inputs.enqueueString(string2);
        }
        if ((objectArray = arrayList.toArray()).length > 0) {
            MessageString[] messageStringArray = new MessageString[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                messageStringArray[n] = (MessageString)objectArray[n];
                ++n;
            }
            return messageStringArray;
        }
        return null;
    }

    private String buildString(StringArray stringArray, int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n5 == n ? n2 : 0;
            int n7 = n5 == n3 ? n4 + 1 : stringArray.contents[n5].length();
            if (n5 != n) {
                if (this.getLineBreakSymbol() != null && !this.getLineBreakSymbol().equals("")) {
                    stringBuffer.append(this.getLineBreakSymbol());
                } else {
                    stringBuffer.append(this.localLineSeparator);
                }
            }
            stringBuffer.append(stringArray.contents[n5].substring(n6, n7));
            ++n5;
        }
        return stringBuffer.toString();
    }

    private String processSearchString(List list, String string, StringPosition stringPosition, StringPosition stringPosition2) {
        int n = 0;
        int n2 = string.length() - 1;
        while (true) {
            if (this.getStartPattern() != null && !this.getStartPattern().equals("")) {
                this.search(stringPosition, this.getStartPattern(), string, n);
                if (!stringPosition.isValid()) {
                    return string;
                }
            } else {
                stringPosition.setStartPosition(n);
                stringPosition.setEndPosition(n);
                stringPosition.setValid(true);
            }
            if (stringPosition.isValid() && stringPosition.getEndPosition() < n2) {
                if (this.getEndPattern() == null || this.getEndPattern().equals("")) {
                    this.search(stringPosition2, this.getStartPattern(), string, stringPosition.getEndPosition() + 1);
                } else {
                    this.search(stringPosition2, this.getEndPattern(), string, stringPosition.getEndPosition() + 1);
                }
            }
            if (!stringPosition2.isValid()) {
                if (this.flushingMode) {
                    stringPosition2.setStartPosition(n2);
                    stringPosition2.setEndPosition(n2);
                    list.add(this.adjustMessage(string, stringPosition, stringPosition2));
                    string = null;
                }
                return string;
            }
            if (!stringPosition.isValid() || !stringPosition2.isValid()) continue;
            list.add(this.adjustMessage(string, stringPosition, stringPosition2));
            n = this.getEndPattern() == null || this.getEndPattern().equals("") ? stringPosition2.getStartPosition() : stringPosition2.getEndPosition() + 1;
            if (n > n2) {
                return null;
            }
            string = string.substring(n, string.length());
            n = 0;
            n2 = string.length() - 1;
            stringPosition.setValid(false);
            stringPosition2.setValid(false);
        }
    }

    protected MessageString adjustMessage(String string, StringPosition stringPosition, StringPosition stringPosition2) {
        int n = string.length() - 1;
        int n2 = this.getIncludeStartPattern() ? stringPosition.getStartPosition() : stringPosition.getEndPosition() + 1;
        int n3 = this.getIncludeEndPattern() ? stringPosition2.getEndPosition() + 1 : (stringPosition2.getStartPosition() == n ? stringPosition2.getStartPosition() + 1 : stringPosition2.getStartPosition());
        MessageString messageString = new MessageString();
        messageString.setValue(string.substring(n2, n3));
        return messageString;
    }

    protected void search(StringPosition stringPosition, String string, String string2, int n) {
        int n2 = -1;
        if (string != null) {
            n2 = string2.indexOf(string, n);
        }
        if (n2 > -1 && n2 < string2.length()) {
            stringPosition.setStartPosition(n2);
            if (string.length() > 1) {
                stringPosition.setEndPosition(n2 + string.length() - 1);
            } else {
                stringPosition.setEndPosition(n2 + string.length());
            }
            stringPosition.setValid(true);
        }
    }

    class StringPosition
    implements Cloneable {
        private int startPosition;
        private int endPosition;
        private boolean valid = false;

        StringPosition() {
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int n) {
            this.startPosition = n;
        }

        int getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(int n) {
            this.endPosition = n;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        protected Object clone() throws CloneNotSupportedException {
            StringPosition stringPosition = new StringPosition();
            stringPosition.startPosition = this.startPosition;
            stringPosition.endPosition = this.endPosition;
            stringPosition.valid = this.valid;
            return stringPosition;
        }
    }

    class StringArray {
        public String[] contents = new String[8];
        public int offset = 0;
        public int lastAddedString = -1;
        public int lastRemovedString = -1;

        private void increaseStringArraySize() {
            String[] stringArray = new String[this.contents.length * 2];
            System.arraycopy(this.contents, 0, stringArray, 0, this.contents.length);
            this.contents = stringArray;
        }

        public void enqueueString(String string) {
            if (this.offset + 1 >= this.contents.length) {
                this.increaseStringArraySize();
            }
            this.contents[this.offset++] = string;
            this.lastAddedString = this.offset - 1;
        }

        public void flush() {
            int n = 0;
            while (n < this.contents.length) {
                this.contents[n] = null;
                ++n;
            }
            this.offset = 0;
            this.lastRemovedString = -1;
            this.lastAddedString = -1;
        }
    }
}

