/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class GlaTaskOutputter
extends Outputter
implements IOutputter {
    IFile resource;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return objectArray;
        }
        return this.processCBEs((CommonBaseEvent[])objectArray);
    }

    public void update() throws AdapterInvalidConfig {
        String string;
        super.update();
        Hashtable hashtable = this.getProperties();
        if (hashtable != null && !hashtable.isEmpty() && (string = (String)hashtable.get("resourceName")) != null && !string.equals("")) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.resource = iWorkspaceRoot.getFileForLocation((IPath)new Path(string));
        }
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] commonBaseEventArray) {
        short s = this.getLoggingLevel();
        if (this.resource != null) {
            int n = 0;
            while (n < commonBaseEventArray.length) {
                IMarker iMarker;
                CommonBaseEvent commonBaseEvent = commonBaseEventArray[n];
                short s2 = commonBaseEvent.getSeverity();
                if (commonBaseEventArray[n] != null && s2 >= s && (iMarker = this.createProblemMarker((IResource)this.resource)).exists()) {
                    try {
                        iMarker.setAttribute("message", (Object)commonBaseEventArray[n].getMsg());
                        if (commonBaseEventArray[n].getSeverity() >= 50) {
                            iMarker.setAttribute("severity", 2);
                        } else if (commonBaseEventArray[n].getSeverity() >= 20) {
                            iMarker.setAttribute("severity", 1);
                        } else if (commonBaseEventArray[n].getSeverity() > 0) {
                            iMarker.setAttribute("severity", 0);
                        }
                        iMarker.setAttribute("userEditable", true);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        return commonBaseEventArray;
    }

    public Object[] testEventInterface(Object[] objectArray) throws AdapterInvalidConfig {
        return this.testProcessCBEs((CommonBaseEvent[])objectArray);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] commonBaseEventArray) {
        return commonBaseEventArray;
    }

    private IMarker createProblemMarker(IResource iResource) {
        try {
            IMarker iMarker = iResource.createMarker("org.eclipse.hyades.logging.adapter.glaproblemmarker");
            return iMarker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

