/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;

public class CBEFileOutputter
extends Outputter
implements IOutputter {
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;
    private File outputFile = null;
    protected FileWriter fw = null;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])objectArray);
    }

    protected void writeToFile(String string) throws IOException {
        this.fw.write(string);
        this.fw.write("\n");
        this.fw.flush();
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] commonBaseEventArray) {
        if (commonBaseEventArray == null) {
            return commonBaseEventArray;
        }
        int n = 0;
        while (n < commonBaseEventArray.length) {
            if (commonBaseEventArray[n] != null) {
                try {
                    String string = EventFormatter.toCanonicalXMLString((CommonBaseEvent)commonBaseEventArray[n], (boolean)false);
                    if (string != null) {
                        this.writeToFile(string);
                    }
                }
                catch (IOException iOException) {
                    CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                    commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                    commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
                    commonBaseEvent.setSeverity((short)60);
                    this.log(commonBaseEvent);
                }
                catch (NullPointerException nullPointerException) {
                    CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                    commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                    commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
                    commonBaseEvent.setSeverity((short)60);
                    this.log(commonBaseEvent);
                }
            }
            ++n;
        }
        return commonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])objectArray);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] commonBaseEventArray) {
        return commonBaseEventArray;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String string) {
        this.directory = string;
    }

    public final void setFileName(String string) {
        this.fileName = string;
    }

    public void update() throws AdapterInvalidConfig {
        Object object;
        super.update();
        String string = null;
        String string2 = null;
        Element element = this.getConfiguration();
        Element element2 = null;
        Hashtable hashtable = this.getProperties();
        if (hashtable != null && !hashtable.isEmpty()) {
            string = (String)hashtable.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            string2 = (String)hashtable.get(Messages.getString("HyadesGAfileNameAttributeName"));
        } else {
            object = element.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                Element element3;
                if (object.item(n).getNodeType() == 1 && (element3 = (Element)object.item(n)).getTagName().equals(Messages.getString("HyadesGASingleFileOutputterTypeTagName"))) {
                    element2 = element3;
                    if (element2.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        string = element2.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (element2.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        string2 = element2.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                }
                ++n;
            }
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileOutputter_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(string);
        this.setFileName(string2);
        object = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith((String)object) ? this.getDirectory() + this.getFileName() : this.getDirectory() + (String)object + this.getFileName();
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException iOException) {
            CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
            commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
            commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName});
            commonBaseEvent.setSeverity((short)60);
            this.log(commonBaseEvent);
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_"));
        }
    }
}

