/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.util.Iterator;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

public class DeploymentUtilities {
    public static String getTestMachine(CFGClass cFGClass, IImplementor iImplementor, TPFDeployment tPFDeployment) {
        CFGArtifactLocationPair cFGArtifactLocationPair;
        String string = null;
        if (!tPFDeployment.getArtifactLocations().isEmpty() && (cFGArtifactLocationPair = DeploymentUtilities.searchPairWithTestAsset(cFGClass, tPFDeployment)) != null) {
            CFGLocation cFGLocation = cFGArtifactLocationPair.getLocation();
            if (cFGLocation instanceof CFGMachineConstraint) {
                string = ((CFGMachineConstraint)cFGLocation).getHostname();
            } else if (cFGLocation != null) {
                string = cFGLocation.getName();
            }
        }
        return string;
    }

    public static CFGArtifactLocationPair searchPairWithTestAsset(CFGClass cFGClass, TPFDeployment tPFDeployment) {
        CFGArtifactLocationPair cFGArtifactLocationPair = null;
        CFGArtifact cFGArtifact = null;
        Iterator iterator = tPFDeployment.getArtifactLocations().iterator();
        while (iterator.hasNext()) {
            cFGArtifactLocationPair = (CFGArtifactLocationPair)iterator.next();
            cFGArtifact = cFGArtifactLocationPair.getArtifact();
            if (cFGArtifact == null || cFGArtifact.getDeployableInstances().isEmpty()) continue;
            Iterator iterator2 = cFGArtifact.getDeployableInstances().iterator();
            while (iterator2.hasNext()) {
                CFGClass cFGClass2 = (CFGClass)iterator2.next();
                if (cFGClass2.getId() == null || !cFGClass2.getId().equals(cFGClass.getId())) continue;
                return cFGArtifactLocationPair;
            }
        }
        return null;
    }
}

