/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.util.HashMap;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapter;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class ExecutionAdapterUtilities {
    public static Object getAdapterInstance(String string, String string2, boolean bl, HashMap hashMap, ISystemUtility iSystemUtility) throws ClassNotFoundException {
        Object object;
        Object v = hashMap.get(string);
        if (v != null && v instanceof HashMap) {
            object = (HashMap)v;
            v = ((HashMap)object).get(string2);
            try {
                if (bl) {
                    if (v != null && v instanceof String) {
                        return Class.forName((String)v).newInstance();
                    }
                } else if (v != null && v instanceof ConfigurationElement) {
                    return ((ConfigurationElement)v).createExecutableExtension("class");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = iSystemUtility.getString("EXEC_NOT_FOUND_ERR_");
        object = StringUtil.change((String)object, (String)"%1", (String)string);
        object = StringUtil.change((String)object, (String)"%2", (String)string2);
        throw new ClassNotFoundException((String)object);
    }

    public static boolean adaptExecutableObject(IExecutableObject iExecutableObject, CFGClass cFGClass, IImplementor iImplementor, boolean bl, String string, TPFDeployment tPFDeployment, StringBuffer stringBuffer, ISystemUtility iSystemUtility, HashMap hashMap) {
        IExecutableObjectAdapter iExecutableObjectAdapter = null;
        try {
            iExecutableObjectAdapter = (IExecutableObjectAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTABLE_OBJECT_ADAPTER", string, bl, hashMap, iSystemUtility);
        }
        catch (Exception exception) {
            iSystemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)iSystemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutableObjectAdapter != null) {
            iExecutableObjectAdapter.setupExecutableObject(iExecutableObject, cFGClass, iImplementor, tPFDeployment);
        }
        if (iExecutableObject instanceof JavaProcessExecutableObjectStub) {
            JavaProcessExecutableObjectStub javaProcessExecutableObjectStub = (JavaProcessExecutableObjectStub)iExecutableObject;
            String string2 = javaProcessExecutableObjectStub.getArgs();
            string2 = string2 + " org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
            javaProcessExecutableObjectStub.setArgs(string2);
        }
        return true;
    }

    public static boolean adaptExecutionEnvironment(IExecutionEnvironment iExecutionEnvironment, CFGClass cFGClass, IImplementor iImplementor, boolean bl, String string, TPFDeployment tPFDeployment, StringBuffer stringBuffer, ISystemUtility iSystemUtility, HashMap hashMap) {
        IExecutionEnvironmentAdapter iExecutionEnvironmentAdapter = null;
        try {
            iExecutionEnvironmentAdapter = (IExecutionEnvironmentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_ENVIRONMENT_ADAPTER", string, bl, hashMap, iSystemUtility);
        }
        catch (Exception exception) {
            iSystemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)iSystemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutionEnvironmentAdapter != null) {
            iExecutionEnvironmentAdapter.setupExecutionEnvironment(iExecutionEnvironment, cFGClass, iImplementor, tPFDeployment);
        }
        return true;
    }

    public static boolean adaptExecutionDeployment(INode iNode, TPFDeployment tPFDeployment, boolean bl, String string, StringBuffer stringBuffer, ISystemUtility iSystemUtility, HashMap hashMap) {
        IExecutionDeploymentAdapter iExecutionDeploymentAdapter = null;
        try {
            iExecutionDeploymentAdapter = (IExecutionDeploymentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", string, bl, hashMap, iSystemUtility);
        }
        catch (Exception exception) {
            iSystemUtility.logError(exception);
            return false;
        }
        if (iExecutionDeploymentAdapter != null) {
            iExecutionDeploymentAdapter.deployTestAssets(iNode, tPFDeployment, bl);
        }
        return true;
    }

    public static boolean adaptExecutionDeploymentCleanup(INode iNode, TPFDeployment tPFDeployment, boolean bl, String string, StringBuffer stringBuffer, ISystemUtility iSystemUtility, HashMap hashMap) {
        IExecutionDeploymentAdapter iExecutionDeploymentAdapter = null;
        try {
            iExecutionDeploymentAdapter = (IExecutionDeploymentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", string, bl, hashMap, iSystemUtility);
        }
        catch (Exception exception) {
            iSystemUtility.logError(exception);
            return false;
        }
        if (iExecutionDeploymentAdapter != null) {
            iExecutionDeploymentAdapter.cleanUpTestAssets(iNode, tPFDeployment, bl);
        }
        return true;
    }
}

