/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractAccessLogParser
extends Parser {
    protected String clientIP = null;
    protected String method = null;
    protected String fileName = null;
    protected String returnCode = null;
    protected String fileSize = null;
    protected String userID = null;
    protected String message = null;
    protected StringBuffer currentTimeStamp = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = "";
    private long duplicateTimeStampCounter = 0L;

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] commonBaseEventArray = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0) {
                    if (this.parseLogRecord()) {
                        if (this.cgiDebuggingOutput.length() > 0) {
                            this.createCGIDebuggingOutputCBE();
                            ++this.arrayIndex;
                            if (this.arrayIndex == this.MessageArraySize) {
                                this.increaseMsgArraySize();
                            }
                            ++this.recordCount;
                        }
                        this.reinitializeCBE();
                        if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                            this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                        } else {
                            this.previousTimeStamp = this.currentTimeStamp.toString();
                            this.duplicateTimeStampCounter = 0L;
                        }
                        this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                        this.messages[this.arrayIndex].setMsg(this.message);
                        this.messages[this.arrayIndex].setSeverity((short)10);
                        if (this.method != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("method", this.method));
                        }
                        if (this.clientIP != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                        }
                        if (this.fileName != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                        }
                        if (this.returnCode != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("return_code", this.returnCode));
                        }
                        if (this.fileSize != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file_size", this.fileSize));
                        }
                        if (this.userID != null) {
                            this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("userid", this.userID));
                        }
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.arrayIndex = 0;
                            ++this.recordCount;
                            this.reset();
                            return this.messages;
                        }
                        ++this.recordCount;
                        this.reset();
                    } else {
                        this.cgiDebuggingOutput.append(this.curLine);
                        this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
                    }
                }
                this.curLine = this.readLine();
            }
            if (this.cgiDebuggingOutput.length() > 0) {
                if (this.recordCount == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString("INVALID_ACCESS_LOG_ERROR_", this.file_path));
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                commonBaseEventArray = null;
            } else {
                int n = this.arrayIndex;
                while (n < this.MessageArraySize) {
                    this.messages[n] = null;
                    ++n;
                }
                commonBaseEventArray = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException logParserException) {
            throw logParserException;
        }
        catch (Throwable throwable) {
            ParserUtilities.exceptionHandler(throwable, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"));
        }
        return commonBaseEventArray;
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification componentIdentification = Parser.eventFactory.createComponentIdentification();
        componentIdentification.setLocation(this.localHostId);
        componentIdentification.setLocationType(this.localHostIdFormat);
        componentIdentification.setComponent(this.sourceID);
        componentIdentification.setSubComponent("Unknown");
        componentIdentification.setComponentType("ApacheHTTPServer");
        componentIdentification.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(componentIdentification);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation situation = Parser.eventFactory.createSituation();
        ReportSituation reportSituation = Parser.eventFactory.createReportSituation();
        reportSituation.setReasoningScope("INTERNAL");
        reportSituation.setReportCategory("LOG");
        situation.setCategoryName("ReportSituation");
        situation.setSituationType((SituationType)reportSituation);
        return situation;
    }

    protected boolean parseDate(int n, int n2) {
        if (this.curLine.charAt(n) == '[' && this.curLine.charAt(n2) == ']') {
            int n3 = this.curLine.indexOf(45, n);
            if (!(n3 != -1 && n3 <= n2 || (n3 = this.curLine.indexOf(43, n)) != -1 && n3 <= n2)) {
                return false;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
            Date date = simpleDateFormat.parse(this.curLine.substring(n + 1, n3).trim(), new ParsePosition(0));
            if (date != null) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.currentTimeStamp = new StringBuffer(simpleDateFormat.format(date).trim());
                this.currentTimeStamp.replace(10, 11, "T");
                this.currentTimeStamp.append(".000000");
                this.currentTimeStamp.append(this.curLine.charAt(n3));
                this.currentTimeStamp.append(this.curLine.substring(n3 + 1, n3 + 3));
                this.currentTimeStamp.append(":");
                this.currentTimeStamp.append(this.curLine.substring(n3 + 3, n3 + 5));
                return true;
            }
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int n = 0;
        int n2 = this.curLine.indexOf(" ");
        if (n2 == -1) {
            return false;
        }
        this.clientIP = this.curLine.substring(n, n2).trim();
        if (!ParserUtilities.isValidIPAddress(this.clientIP)) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        this.userID = this.curLine.substring(n, n2).trim();
        if (this.userID.equals("-")) {
            this.userID = null;
        }
        if ((n2 = this.curLine.indexOf("[", n = n2)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("]", n)) == -1) {
            return false;
        }
        if (!this.parseDate(n, n2)) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf("\"", n)) == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n)) == -1) {
            return false;
        }
        this.method = this.curLine.substring(n + 1, n2).trim();
        this.message = this.curLine.substring(n).trim();
        int n3 = this.curLine.lastIndexOf("\"");
        if (n3 == -1 || n3 == n) {
            return false;
        }
        n = n2;
        n2 = this.curLine.lastIndexOf(" ", n3);
        if (n2 == n) {
            this.fileName = this.curLine.substring(n, n3).trim();
            n = n3;
        } else {
            this.fileName = this.curLine.substring(n, n2).trim();
            n = n2;
        }
        n2 = this.curLine.indexOf(" ", n + 1);
        if (n2 == -1) {
            return false;
        }
        n = n2;
        if ((n2 = this.curLine.indexOf(" ", n + 1)) == -1) {
            return false;
        }
        this.returnCode = this.curLine.substring(n, n2).trim();
        this.fileSize = this.curLine.substring(n2).trim();
        return true;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    protected void reset() {
        this.userID = null;
        this.method = null;
        this.returnCode = null;
        this.clientIP = null;
        this.fileName = null;
        this.fileSize = null;
        this.message = null;
        this.currentTimeStamp = null;
        this.cgiDebuggingOutput = new StringBuffer();
    }
}

