/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class Parser
implements IParser {
    protected static final String UNKNOWN_HOST = "Unknown Host";
    public static final int defaultArraySize = 50;
    protected int MessageArraySize = 50;
    protected CommonBaseEvent[] messages;
    protected int arrayIndex;
    protected int recordCount = 0;
    protected String originLocale;
    protected String localHostId;
    protected String localHostIdFormat;
    protected String localHostName;
    protected String file_path;
    protected RandomAccessFile logFile;
    protected String curLine = "";
    protected static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.parsers.Parser");
    protected Log logger;
    protected long curLineNumber = 0L;

    public void parse(Log log) throws LogParserException {
        try {
            this.logger = log;
            this.preParse();
            CommonBaseEvent[] commonBaseEventArray = this.parseNext();
            while (commonBaseEventArray != null) {
                int n = 0;
                while (n < commonBaseEventArray.length) {
                    if (commonBaseEventArray[n] != null) {
                        this.logger.trace((Object)commonBaseEventArray[n]);
                    }
                    ++n;
                }
                commonBaseEventArray = this.parseNext();
            }
            this.postParse();
        }
        catch (Throwable throwable) {
            this.postParse();
            LogParserException logParserException = new LogParserException(throwable);
            logParserException.fillInStackTrace();
            throw logParserException;
        }
    }

    public abstract CommonBaseEvent[] parseNext() throws LogParserException;

    public abstract String getName();

    public abstract String getVersion();

    public CommonBaseEvent[] getMessages() {
        return this.messages;
    }

    public void preParse() throws LogParserException {
        this.getLocalHostId();
        this.originLocale = this.getLocale();
    }

    public void setUserInput(Hashtable hashtable) throws LogParserException {
        this.setConfiguration(hashtable);
    }

    public void setConfiguration(Hashtable hashtable) throws LogParserException {
        this.file_path = null;
        try {
            Integer n;
            this.file_path = (String)hashtable.get("file_path");
            if (this.file_path != null) {
                this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                File file = new File(this.file_path);
                if (!file.isFile()) {
                    throw new FileNotFoundException("The file: " + this.file_path + " does not exist");
                }
                if (!file.canRead()) {
                    throw new IOException("The file: " + this.file_path + " cannot be read");
                }
                this.logFile = new RandomAccessFile(file, "r");
            }
            if ((n = (Integer)hashtable.get("array_size")) != null) {
                this.MessageArraySize = n;
            }
            this.messages = new CommonBaseEvent[this.MessageArraySize];
            int n2 = 0;
            while (n2 < this.MessageArraySize) {
                this.messages[n2] = eventFactory.createCommonBaseEvent();
                ++n2;
            }
        }
        catch (Throwable throwable) {
            ParserUtilities.exceptionHandler(throwable, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    protected void increaseMsgArraySize() {
        CommonBaseEvent[] commonBaseEventArray = new CommonBaseEvent[++this.MessageArraySize];
        System.arraycopy(this.messages, 0, commonBaseEventArray, 0, this.messages.length);
        this.messages = commonBaseEventArray;
        this.messages[this.MessageArraySize - 1] = eventFactory.createCommonBaseEvent();
    }

    protected void getLocalHostId() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? "IPV6" : "IPV4";
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = "None";
        }
        try {
            this.localHostName = InetAddress.getByName(this.localHostId).getHostName();
        }
        catch (Exception exception) {
            this.localHostName = null;
        }
    }

    protected String getLocale() {
        String string = System.getProperty("user.language");
        String string2 = System.getProperty("user.region");
        if (string != null && string2 != null) {
            return string.concat("-").concat(string2);
        }
        return "";
    }

    protected boolean isNum(String string, int n) {
        try {
            return Character.isDigit(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isNum(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isNum(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isLet(String string, int n) {
        try {
            return Character.isLetter(string.charAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLet(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.isLet(string, n + n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected boolean isChar(String string, int n, char c) {
        try {
            return string.charAt(n) == c;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.logFile != null) {
                this.logFile.close();
            }
        }
        catch (Exception exception) {
            ParserUtilities.exceptionHandler(exception, "");
        }
    }

    protected String readLine() {
        String string = null;
        try {
            if (ParserConstants.IS_ZOS_PLATFORM) {
                int n = (int)(this.logFile.length() - this.logFile.getFilePointer()) + 1;
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    byte by = (byte)this.logFile.read();
                    if (by == -1) {
                        n2 = -1;
                        break;
                    }
                    if (by == 21) break;
                    byArray[n3] = by;
                    ++n2;
                    ++n3;
                }
                string = n2 == -1 ? null : new String(byArray, 0, n2);
            } else {
                string = this.logFile.readLine();
            }
            ++this.curLineNumber;
        }
        catch (IOException iOException) {}
        return string;
    }

    protected static ExtendedDataElement createStringEDE(String string, String string2) {
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(string);
        int n = 0;
        if (string2 != null && (n = string2.trim().length()) > 1024) {
            extendedDataElement.setTypeAsInt(16);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(string2.substring(n2, Math.min(n2 + 1024, n)));
                n2 += 1024;
            }
            extendedDataElement.setValues(arrayList.toArray(new String[arrayList.size()]));
        } else {
            extendedDataElement.setTypeAsInt(7);
            extendedDataElement.setValues(new String[]{string2});
        }
        return extendedDataElement;
    }
}

