/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _restoreDefaults;
    private ArrayList _data;
    private String _defaultColumnsTemplate;
    private Item _oldSelection;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _title;

    public ColumnsDialog(Shell shell, String string, Image image, ArrayList arrayList, String string2) {
        super(shell);
        this._title = string;
        this._defaultColumnsTemplate = string2;
        Window.setDefaultImage((Image)image);
        this._data = new ArrayList(arrayList.size());
        this._data.addAll(arrayList);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        Label label = new Label(composite2, 0);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(TraceUIPlugin.getString("STR_COL_DLG_TEXT"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        this._list = new Table(composite3, 2336);
        gridData = GridUtil.createFill();
        this._list.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        composite4.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite4.setLayout((Layout)gridLayout2);
        this._moveUp = new Button(composite4, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)gridData);
        this._moveUp.setText(TraceUIPlugin.getString("STR_COL_DLG_UP"));
        this._moveDown = new Button(composite4, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)gridData);
        this._moveDown.setText(TraceUIPlugin.getString("STR_COL_DLG_DOWN"));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this.populateList();
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, TraceUIPlugin.getString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(composite);
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this._data.clear();
            this._data.addAll(ColumnData.createColumnDataFromString(this._defaultColumnsTemplate));
            this.populateList();
        } else {
            super.buttonPressed(n);
        }
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int n) {
        TableItem tableItem = this._list.getItem(n);
        ColumnData columnData = (ColumnData)tableItem.getData();
        if (!columnData.isMovable()) {
            return;
        }
        TableItem tableItem2 = new TableItem(this._list, 32, n + 2);
        tableItem2.setChecked(tableItem.getChecked());
        tableItem2.setText(tableItem.getText());
        tableItem2.setData((Object)columnData);
        tableItem2.setGrayed(tableItem.getGrayed());
        this._list.remove(n);
        this._list.select(n + 1);
    }

    protected void moveUp(int n) {
        TableItem tableItem;
        ColumnData columnData;
        TableItem tableItem2 = this._list.getItem(n);
        ColumnData columnData2 = (ColumnData)tableItem2.getData();
        if (!columnData2.isMovable()) {
            return;
        }
        if (n > 0 && !(columnData = (ColumnData)(tableItem = this._list.getItem(n - 1)).getData()).isMovable()) {
            return;
        }
        tableItem = new TableItem(this._list, 32, n - 1);
        tableItem.setChecked(tableItem2.getChecked());
        tableItem.setText(tableItem2.getText());
        tableItem.setData((Object)columnData2);
        tableItem.setGrayed(tableItem2.getGrayed());
        this._list.remove(n + 1);
        this._list.select(n - 1);
    }

    protected void okPressed() {
        if (!this.validate()) {
            String string = TraceUIPlugin.getString("STR_TRACE_MSG");
            String string2 = TraceUIPlugin.getString("ERR_SELECT_COLS");
            MessageDialog.openError((Shell)this.getShell(), (String)string, (String)string2);
            return;
        }
        this._data.clear();
        int n = 0;
        while (n < this._list.getItemCount()) {
            TableItem tableItem = this._list.getItem(n);
            ColumnData columnData = (ColumnData)tableItem.getData();
            int n2 = columnData.getStyle();
            n2 = tableItem.getChecked() ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
            this._data.add(new ColumnData(columnData.name(), columnData.getInitalPos(), n2, columnData.getAlignment(), columnData.width()));
            ++n;
        }
        super.okPressed();
    }

    private void populateList() {
        this._list.removeAll();
        int n = 0;
        while (n < this._data.size()) {
            ColumnData columnData = (ColumnData)this._data.get(n);
            TableItem tableItem = new TableItem(this._list, 0);
            tableItem.setText(columnData.name());
            tableItem.setChecked(columnData.visible());
            tableItem.setGrayed(columnData.isNonDeletable());
            tableItem.setData((Object)columnData);
            ++n;
        }
    }

    private boolean validate() {
        boolean bl = false;
        int n = 0;
        while (n < this._list.getItemCount()) {
            TableItem tableItem = this._list.getItem(n);
            if (tableItem.getChecked()) {
                return true;
            }
            ++n;
        }
        return bl;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._moveUp) {
            int n = this._list.getSelectionIndex();
            if (n > 0) {
                this.moveUp(n);
            }
        } else if (selectionEvent.widget == this._moveDown) {
            int n = this._list.getSelectionIndex();
            if (n != -1 && n < this._list.getItemCount() - 1) {
                this.moveDown(n);
            }
        } else if (selectionEvent.widget instanceof Table) {
            TableItem[] tableItemArray = this._list.getItems();
            int n = 0;
            while (n < tableItemArray.length) {
                boolean bl = tableItemArray[n].getChecked();
                ColumnData columnData = (ColumnData)tableItemArray[n].getData();
                if (!bl && columnData.isNonDeletable()) {
                    tableItemArray[n].setChecked(true);
                }
                ++n;
            }
        }
        int n = this._list.getSelectionIndex();
        ColumnData columnData = null;
        ColumnData columnData2 = null;
        if (n > 0) {
            columnData2 = (ColumnData)this._list.getItem(n - 1).getData();
        }
        if (n != -1) {
            columnData = (ColumnData)this._list.getItem(n).getData();
        }
        this._moveUp.setEnabled(columnData != null && columnData.isMovable() && columnData2 != null && columnData2.isMovable());
        this._moveDown.setEnabled(columnData != null && columnData.isMovable() && n < this._list.getItemCount() - 1);
    }
}

