/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

public class CoverageUtil {
    private static String getSourceSig(TRCSourceInfo tRCSourceInfo) {
        return tRCSourceInfo != null ? tRCSourceInfo.getLocation() + ":" : "";
    }

    public static String getFullSig(TRCMethod tRCMethod) {
        return CoverageUtil.getSourceSig(tRCMethod.getSourceInfo()) + tRCMethod.getLineNo() + ":" + CoverageUtil.getSig(tRCMethod.getDefiningClass()) + "." + tRCMethod.getName() + tRCMethod.getSignature();
    }

    public static String getFullSig(TRCClass tRCClass) {
        return CoverageUtil.getSourceSig(tRCClass.getSourceInfo()) + tRCClass.getLineNo() + ":" + CoverageUtil.getSig(tRCClass);
    }

    public static String getFullSig(TRCPackage tRCPackage) {
        return tRCPackage.getName();
    }

    private static String getSig(TRCClass tRCClass) {
        return (tRCClass.getPackage().getName() == null ? "" : tRCClass.getPackage().getName() + ".") + tRCClass.getName();
    }

    public static boolean isFiltered(TRCPackage tRCPackage) {
        if (tRCPackage.getClasses() == null || tRCPackage.getClasses().size() == 0) {
            return true;
        }
        Object[] objectArray = tRCPackage.getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        return CoverageUtil.filtersMatch(objectArray, tRCPackage.getName());
    }

    public static boolean isFiltered(TRCClass tRCClass) {
        return tRCClass.getMethods() == null || tRCClass.getMethods().size() == 0;
    }

    private static boolean filtersMatch(Object[] objectArray, String string) {
        int n = 0;
        while (n < objectArray.length) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)objectArray[n];
            if (tRCConfiguration.isActive()) {
                Object[] objectArray2 = tRCConfiguration.getFilters().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    TRCFilter tRCFilter = (TRCFilter)objectArray2[n2];
                    String string2 = tRCFilter.getPattern();
                    if (string2.indexOf("*") != -1) {
                        string2 = string2.substring(0, string2.indexOf("*"));
                    }
                    if (string.startsWith(string2)) {
                        return !tRCFilter.getMode().equals("INCLUDE");
                    }
                    ++n2;
                }
                return false;
            }
            ++n;
        }
        return false;
    }
}

