/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.jface.dialogs.IDialogSettings;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;

/**
 * Extends the TestSuiteNewWizard to create the Http Test Suite.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public class HttpTestSuiteNewWizard 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public HttpTestSuiteNewWizard()
	{
		super();
		setWindowTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor(TestHttpImages.IMG_WIZBAN_NEW_HTTP_TESTSUITE));

		IDialogSettings dialogSettings = TestHttpPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("HttpTestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("HttpTestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		getLocationPage().setDescription(TestHttpPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
		
		getAttributeWizardPage().setTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		getAttributeWizardPage().setDescription(TestHttpPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
		
		super.addPages();
	}	
}
