/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpTestLaunchConfigurationFacade
		extends TestLaunchConfigurationFacade {
	
	public final static String LAUNCH_CONFIGURATION_TYPE =  "org.eclipse.hyades.test.http.launch.urlTest"; //$NON-NLS-1$
	
	public static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE);
	}
	
	private final static String PROPERTY_URLTEST = PROPERTY_PREFIX + ".urlTest"; //$NON-NLS-1$
	private final static String PROPERTY_TEST = PROPERTY_PREFIX + ".test";
	public final static String PROPERTY_USERS = PROPERTY_URLTEST + ".users";

	/**
	 * Retrieves the Test property of a Hyades Launch Configuration. This property defines
	 * which Test will be run by the Launch Configuration.
	 */
	public static TPFTest getTest(ILaunchConfiguration configuration) throws CoreException {
		EObject eObject = resolveEMFReference(configuration, PROPERTY_TEST);
		if (eObject != null && eObject instanceof TPFTest) {
			return (TPFTest)eObject;
		}
		return null;
	}
	
	/**
	 * Define the Test property of a Hyades Launch Configuration. This property defines
	 * which Test will be run by the Launch Configuration.
	 */	
	public static void setTest(ILaunchConfigurationWorkingCopy configuration, TPFTest test) {
		storeEMFReference(configuration, PROPERTY_TEST, test);
	}
}
