/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.launch.HttpTestLaunchConfigurationFacade;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class LoadTestUserTab extends AbstractLaunchConfigurationTab 
{

	private String title = TestHttpPlugin.getString("LoadTestUserTab.Title");
	private Text _numUsers = null;
	private int _nUsers = 1;
	
	private Listener modifyListener = new Listener() {
		public void handleEvent(Event e) {
			if (e.widget == _numUsers)
			{
				String txt = _numUsers.getText();
				try {
					int n = Integer.parseInt(txt);
					if (n > 1)
					{
						setErrorMessage(null);
						_nUsers = n;
						setDirty(true);
						updateLaunchConfigurationDialog();
					}
				}
				catch (NumberFormatException nfe) {
					_nUsers = 1;
					setErrorMessage(TestHttpPlugin.getString("LoadTestUserTab.InvalidUsers"));
				}
			}
		}
	};
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.horizontalSpacing = 25;
        gl.verticalSpacing = 25;
        composite.setLayout(gl);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        composite.setFont(parent.getFont());
        Label users = new Label(composite, SWT.NONE);
		users.setText(TestHttpPlugin.getString("LoadTestUserTab.Users"));
		
		_numUsers = new Text(composite, SWT.BORDER);
		_numUsers.setText(Integer.toString(_nUsers));
		_numUsers.addListener(SWT.Modify, modifyListener);
		_numUsers.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setMessage("Hello World");
		setControl(composite);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		// TODO Auto-generated method stub
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
    	
		
		try {
    		TPFTest test = HttpTestLaunchConfigurationFacade.getTest(configuration);
    		int n = configuration.getAttribute(HttpTestLaunchConfigurationFacade.PROPERTY_USERS, 1);
    		if (n > 0 && n != _nUsers && _numUsers != null)
    		{
    			_numUsers.removeListener(SWT.Modify, modifyListener);  //don't want this event to be handled
    			_nUsers = n;
    			_numUsers.setText(Integer.toString(_nUsers));
    			_numUsers.addListener(SWT.Modify, modifyListener);
    		}
    	}
    	catch (CoreException e)
		{
    		TestHttpPlugin.logError(e);
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(HttpTestLaunchConfigurationFacade.PROPERTY_USERS, _nUsers);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#getName()
	 */
	public String getName() {
		return title;
	}
	/**
	 * @return Returns the _nUsers.
	 */
	public int get_nUsers() {
		return _nUsers;
	}
	/**
	 * @param users The _nUsers to set.
	 */
	public void set_nUsers(int users) {
		_nUsers = users;
	}
	
	public Image getImage() {
		return TestHttpImages.INSTANCE.getImage(TestHttpImages.IMG_HTTP_TEST_CASE);
	}
}
