/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.ImageOverlayIcon;
import org.eclipse.hyades.log.ui.internal.util.RecordTableElement;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEContextDataElement;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl;
import org.eclipse.hyades.models.cbe.impl.CBEComponentIdentificationImpl;
import org.eclipse.hyades.models.cbe.impl.CBEContextDataElementImpl;
import org.eclipse.hyades.models.cbe.impl.CBEDefaultElementImpl;
import org.eclipse.hyades.models.cbe.impl.CBEExtendedDataElementImpl;
import org.eclipse.hyades.models.cbe.impl.CBEMsgDataElementImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/**
* This class is used for displaying both the Default events under TRCMonitor and TRCAgent
*/
public class LogLabelProvider extends LabelProvider
									implements ILabelDecorator
{
	private RecordPaneContentProvider timeStampProvider = new RecordPaneContentProvider();
	private Hashtable registry = new Hashtable();     

	public Image getImage(Object element)
	{		

		if(element instanceof CBEDefaultEvent){
			
			if(!((CBEDefaultEvent)element).isAnalyzed()){
				if(element instanceof CBECommonBaseEvent){
					return getLogImage(((CBECommonBaseEvent)element).getSeverity());
					
				}else{
					return LogUIPluginImages.getImage(LogUIPluginImages.IMG_UI_ENTRY);				
				}
			}
			else{
				if (((CBEDefaultEvent) element).getSymptoms().size()>0){
					return LogUIPluginImages.getImage(LogUIPluginImages.IMG_ANALYZE_FOUND);
				}
				else{
					return LogUIPluginImages.getImage(LogUIPluginImages.IMG_ANALYZE_NOT_FOUND);
				}
				
			}
			
		}else if(element instanceof EObject){
			
			if(isContainedInCBEPackage(((EObject)element).eClass())){
				return LogUIPluginImages.getImage(LogUIPluginImages.IMG_UI_ENTRY);			
			}
		}
		else if(element instanceof FeatureNode || element instanceof TerminalNode){
			return LogUIPluginImages.getImage(LogUIPluginImages.IMG_UI_ENTRY);		
		}
		return null;		
	}

	/*
	 * @see ILabelDecorator#decorateImage(Image, Object)
	 */
	public Image decorateImage(Image image, Object element) {

        if(!(element instanceof CBEDefaultEvent))
           return null;
           
		if (((CBEDefaultEvent) element).isAnalyzed()) {
			if(element instanceof CBECommonBaseEvent){
				return findImage(image, getDescriptor(((CBECommonBaseEvent)element).getSeverity()));
			}
			else{
				return findImage(image, LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_UI_ENTRY));				
			}				
		}

		return null;
	}

	/*
	 * @see IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		for (Enumeration enum = registry.elements(); enum.hasMoreElements();) {
			Image image = (Image) enum.nextElement();
			if (image.isDisposed() == false)
				image.dispose();
		}
		registry.clear();
		super.dispose();
	}

	private Image findImage(Image srcImage, ImageDescriptor desc) {
		String key1 = String.valueOf(srcImage.hashCode());
		String key2 = String.valueOf(desc.hashCode());
		Image image = (Image) registry.get(key1.concat(key2));
		if (image == null) {
			ImageDescriptor overDesc =
				new ImageOverlayIcon(srcImage, new ImageDescriptor[][] { {
				}, {
				}, {
				}, {
					desc }
			});
			image = overDesc.createImage();
			registry.put(key1.concat(key2), image);
		}
		return image;
	}

	/*
	 * @see ILabelDecorator#decorateText(String, Object)
	 */
	public String decorateText(String text, Object element) {
		return text;
	}

	/*
	 * 
	 */
	public String getText(Object element) {

		Class cls = element.getClass();
		if(element instanceof EObject && isContainedInCBEPackage(((EObject)element).eClass())){	   

			return provideLabelFor((EObject)element);			
		}
		else if(cls==FeatureNode.class)
		{
			return ((FeatureNode)element).getFeature().getName();
			
		}else if(cls==TerminalNode.class){
			
			return ((TerminalNode)element).getDescription();
		}
				
		return LogUIPlugin.getResourceBundle().getString("UNKNOWN_LABEL");
	}
	
	
	protected ImageDescriptor getDescriptor(short sev){
				
		if(sev >=50 && sev<=70)
			return LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_HIGH_SEV);
		else if(sev>=30 && sev< 50)
			return LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_MED_SEV);
		else if(sev>=0 && sev< 30)
			return LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_LOW_SEV);
			
		return null;	
	
	}
	
	protected Image getLogImage(short sev){
				
		 if(sev >=50 && sev<=70)
		 {
			return LogUIPluginImages.getImage(LogUIPluginImages.IMG_HIGH_SEV);
		 }
		 else if(sev>=30 && sev< 50)
		 {
			return LogUIPluginImages.getImage(LogUIPluginImages.IMG_MED_SEV);
		 }
		 else if(sev>=0 && sev< 30)		   	      	 
		 {   	
			return LogUIPluginImages.getImage(LogUIPluginImages.IMG_LOW_SEV);
		 }
		return null;
	
	}
	
	private boolean isContainedInCBEPackage(EClass cls){
		
		if(cls.getEPackage()==CBEPackage.eINSTANCE){
			return true;			
		}
		
		return false;
		
	}
	
	private String provideLabelFor(EObject element){
		
		Class cls = element.getClass();
		if(cls==CBECommonBaseEventImpl.class){
			
			// msg field is optional - display "<empty> [timestamp]" if null
			if (((CBECommonBaseEvent)element).getMsg() == null) {
				Object[] attributes = timeStampProvider.getElements(element);
				for (int i=0;i<attributes.length;++i) {
					RecordTableElement e = (RecordTableElement)attributes[i];
					if (e.getName() != null && e.getName().equals("creationTime"))
						return LogUIPlugin.getResourceString("STR_EMPTY_MSG") + e.getValue();
				}
				return LogUIPlugin.getResourceString("STR_EMPTY_MSG");				
			}
			return truncateString(((CBECommonBaseEvent)element).getMsg());
		}
		else if (cls==CBEExtendedDataElementImpl.class){
			
			return ((CBEDefaultElement)element).getName();
		}
		else if(cls==CBEDefaultElementImpl.class){
			
			return ((CBEDefaultElement)element).getName();
		}
		else if(cls==CBEComponentIdentificationImpl.class){
			
			return ((CBEComponentIdentification)element).getComponent();
		}
		else if(cls==CBEMsgDataElementImpl.class){
			
			return ((CBEMsgDataElement)element).getMsgIdType();		
		}
		else if(cls==CBEContextDataElementImpl.class){
			return ((CBEContextDataElement)element).getName();			
		}
		else if(element instanceof CBESituation)
		{
			return element.eClass().getName().substring(3);
		}
		else{
			int index = -1;
			if(((EObject)element).eContainer().eGet(((EObject)element).eContainmentFeature()) instanceof EList){
				index = ((EList)((EObject)element).eContainer().eGet(((EObject)element).eContainmentFeature())).indexOf((EObject)element);
			}

			return index > -1 ? ((EObject)element).eClass().getName() + "[" + index + "]": ((EObject)element).eClass().getName();
		
		}
			
	}
	
	private String truncateString(String input){	
		int i;
		if((i=input.indexOf('\n'))>-1){
			input = input.substring(0,i);
		}
		if((i=input.indexOf('\r'))>-1){
			input = input.substring(0,i);
		}
		if(input.length() > 50){
			input.substring(0, 50);
		}
		return input;
	}
}