/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Jul 30, 2003
 *
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

/**
 * @author apnan
 *
 */
public class LogFileDetailsUI extends Dialog implements SelectionListener{
	
	private ImportLogWizardPage page;
	private Table logsTable;	
	private TabFolder details;
	
	private TabItem hostTab;
	private TabItem logLocationTab;
	private TabItem destinationTab;

	private LogParserUI parserUI;
	private LogHostUI hostUI;
	private LogLocationUI locationUI;
	private LogDestinationUI destinationUI;
	private ArrayList logs = new ArrayList();
	private Button addBtn;
	private Button removeBtn;
	//private LogFileElement element;
	private LogParserItem parser;
	private String title="";
	private int type;
		
	
	public LogFileDetailsUI(Shell shell, ImportLogWizardPage page, int type) {
		super(shell);
		this.page = page;
		this.type = type;				
	}
	
	/**
	 *
	 * @param parent com.ibm.swt.widgets.Composite
	 */
	protected Control createDialogArea(Composite parent)
	{		
		getShell().setText(title);
		Composite result = new Composite(parent, SWT.NONE);
		GridData data = GridUtil.createFill();
		result.setLayoutData(data);
		result.setLayout(new GridLayout());
		
		parserUI = new LogParserUI(this);
		parserUI.createControl(result);
		
		createSpace(result);
		
		Label lblProp = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		lblProp.setLayoutData(data);
		lblProp.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PROPERTIES"));

		details = new TabFolder(result, SWT.NONE);
		data = GridUtil.createFill();
		data.widthHint = 400;
		details.setLayoutData(data);
		details.addSelectionListener(this);

		hostTab = new TabItem(details, SWT.NONE);
		hostTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST_TAB"));
		hostUI = new LogHostUI(page);
		hostTab.setControl(hostUI.createControl(details));

		logLocationTab = new TabItem(details, SWT.NONE);
		logLocationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DETAILS_TAB"));
		locationUI = new LogLocationUI(page, this);
		logLocationTab.setControl(locationUI.createControl(details));

		destinationTab = new TabItem(details, SWT.NONE);
		destinationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DEST_TAB"));
		destinationUI = new LogDestinationUI(page);
		destinationTab.setControl(destinationUI.createControl(details));
		
		if(type==ImportLogWizardPage.ADD)
			initializeUI();
		else if(type==ImportLogWizardPage.EDIT)	
			initializeUIFromLogElement();
		return result;
	}
	
	private void createSpace(Composite parent){
		Label space = new Label(parent, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		space.setLayoutData(data);
	}

	public String getHostName(){ 
		return hostUI.getHost();
	}
	
	public boolean isLocalHost(){
		String host = hostUI.getHost();
		if(host==null){
			return false;
		}
		return hostUI.isLocalHost(host);
	}
	
	public int getParserCount(){
		return parserUI.getParserCount();
	}
	
	public int getPort(){
		return hostUI.getPort();
	}
	
	public Hashtable getUserInput(LogParserItem item) {
		return locationUI.getUserInput(item);
	}
	
	public int indexOf(LogParserItem item){
		return parserUI.indexOf(item);
	}
	
	public void initializeUI(){
		
		hostUI.initialize(page.getSelectedElement());
		initializeLocation();
		destinationUI.initialize();
		setOKButtonEnabled(isTabFolderComplete());

	}
	
	public void initializeLocation(){
		Composite composite = locationUI.getCompositeFor(parser);
		if(composite == null){
			composite = locationUI.createControl(details, parser);
			
			/* set the widgets and the listeners served */
			parser.setWidgets(locationUI.getWidgets());
			parser.setListenersServed(locationUI.getListenersServed());
		}
		else
		{
			if (parser.getWidgets() != null)
				locationUI.setWidgets(parser.getWidgets());
			if (parser.getListenersServed() != null)
				locationUI.setListenersServed(parser.getListenersServed());
		}
			
		locationUI.initialize(composite, page.getSelectedElement());
		logLocationTab.setControl(composite);		
		//TODO find a better way of validating location page input values 
		//when a parser doesn't have a path input requirement (the location page doesn't have text input fields) 
		//the OK button remains disabled!!!
		setOKButtonEnabled(isTabFolderComplete());	

	}
	
	public void initializeUIFromLogElement(){
		
		LogParserItem parser = page.getSelectedElement().getParser();
		hostUI.initialize(page.getSelectedElement());
		Composite composite = locationUI.getCompositeFor(parser);
		if(composite == null){
			composite = locationUI.createControl(details, parser);
			
			/* set the widgets and the listeners served */
			parser.setWidgets(locationUI.getWidgets());
			parser.setListenersServed(locationUI.getListenersServed());
		}
		else
		{
			if (parser.getWidgets() != null)
				locationUI.setWidgets(parser.getWidgets());
			if (parser.getListenersServed() != null)
				locationUI.setListenersServed(parser.getListenersServed());
		}
			
		locationUI.initializeUIFromLogElement(composite, page.getSelectedElement());

		logLocationTab.setControl(composite);		

		destinationUI.initializeUIFromLogElement(page.getSelectedElement());
	}
		
	public boolean isTabFolderComplete(){
		return parser!=null && hostUI.isTabItemComplete() && locationUI.isTabItemComplete() && destinationUI.isTabItemComplete();
	}
	
	public void setOKButtonEnabled(boolean enabled){
		Button button = getButton(IDialogConstants.OK_ID);
		if(button!=null){
			button.setEnabled(enabled);
		}
		
	}
	
	public LogParserItem getSelectedParser(){
		return parser;
	}
	
	public Map getParserRegistry(){
		return page.getLogSetManager().getParserRegistry();	
	}
	
	public void setSelectedParser(LogParserItem newParser){
		
		//page.getSelectedElement().setParser(newParser);
		if(parser!=newParser && parser!=null){
			parser=newParser;
			initializeLocation();
		}
		parser = newParser;
	}

	public void setWindowTitle(String title){
		this.title=title;	
	}

	public boolean finish(){
		getLogFileElement().setParser(parser);
		return hostUI.finish() && locationUI.finish() && destinationUI.finish();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if(e.item==logLocationTab){		
			locationUI.enableButtons(locationUI.getCompositeFor(parser));
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		
		if(!finish()){		
			return;
		}
		parserUI.dispose();
			
		super.okPressed();
		
	}
	
	protected void cancelPressed(){
		parserUI.dispose();
		super.cancelPressed();
	}


	/**
	 * Updates the list of the listeners that are served
	 * 
	 * @param listenersServed - An updated list of the listeners served 
	 */
	public void updateListenersServed(Vector listenersServed) {
		page.getSelectedElement().getParser().setListenersServed(listenersServed);		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		
		Control control = super.createContents(parent);
		LogFileElement logElem = page.getSelectedElement();		
		setOKButtonEnabled(isTabFolderComplete());
		return control;
	}

	/**
	 * 
	 */
	public LogFileElement getLogFileElement() {
		return page.getSelectedElement();
	}

}
