/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon;

import org.eclipse.emf.common.notify.impl.*;
import org.eclipse.emf.common.notify.*;

import org.eclipse.emf.common.util.*;

import org.eclipse.hyades.internal.execution.local.control.*;

import org.eclipse.hyades.model.statistical.*;

import org.eclipse.hyades.models.hierarchy.*;

import java.util.*;

import org.eclipse.hyades.statistical.ui.widgets.internal.*;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;

import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class PerfmonCounterDialog extends Dialog implements MouseListener, SelectionListener {

TRCAgent trcagent;
Agent agent;

Shell thisshell;
Shell parentshell;

Composite buttonpanel;
Button okbutton;
Button refresh;
	
Tree tree;

Menu tree_menu;
MenuItem get_children;
MenuItem start_tracing;

HashMap descriptor_to_item = new HashMap();
HashMap item_to_descriptor = new HashMap();

PerfmonCommandUtil command;

ModelListener adapter = new ModelListener();

	public PerfmonCounterDialog(Shell parent, TRCAgent trcagent, Agent agent) {
		super (parent, 0);
		this.parentshell = parent;
		this.trcagent = trcagent;
		this.agent = agent;
		
		try {
			command = new PerfmonCommandUtil(agent);
		} catch (Exception e) {
			PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_COMMAND_UTIL"),true);
		}

		//add EMF listeners to the agent and the all the sample windows (should catch adds for descriptors and observations)
		trcagent.eAdapters().add(adapter);
		if (trcagent.getView() != null) {
			trcagent.getView().eAdapters().add(adapter);
			
			EList windows = trcagent.getView().eContents();
			for (int k = 0; k < windows.size(); k++) {
				SDSampleWindow window = (SDSampleWindow)windows.get(k);
				window.eAdapters().add(adapter);
			}
		}
	}


	public Object open () {
		
		Shell parent = getParent();
		Shell shell = new Shell(parent, SWT.RESIZE | SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(PerfmonPlugin.getString("CONFIGURE_PERFMON")); //$NON-NLS-1$
		shell.setBounds(0,0,400,400);
		shell.setLayout(new FillLayout());
		thisshell = shell;

		PerfmonPlugin.DBG.info("initialising graphics");
		init(shell);

		Rectangle r = parentshell.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < 400) z.width = 400;
		if (z.height < 400) z.height = 400;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		

		PerfmonPlugin.DBG.info("opening dialog");
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		//
		// get stuff from gui here
		//
		return null;
	}
	
	public void init(Shell parent) {
		GridLayout glayout = new GridLayout();
		glayout.numColumns = 1;

		Composite mainpanel = new Composite(parent,0);
		mainpanel.setLayout(glayout);
		
		tree = new Tree(mainpanel,SWT.BORDER);
		tree.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		tree_menu = new Menu(tree);
		get_children = new MenuItem(tree_menu,0);
		start_tracing = new MenuItem(tree_menu,0);
		
		get_children.setText(PerfmonPlugin.getString("UPDATE_TREE"));
		get_children.setImage(PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_UPDATE_TREE));
		start_tracing.setText(PerfmonPlugin.getString("START_TRACING"));
		start_tracing.setImage(PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_START));

		try {
			rebuildTree();
		} catch (Throwable t) {
			t.printStackTrace();
		}

		glayout = new GridLayout();
		glayout.numColumns = 2;
		
		buttonpanel = new Composite(mainpanel,0);
		buttonpanel.setLayout(glayout);
		buttonpanel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.FILL));
		
		okbutton = new Button(buttonpanel,0);
		okbutton.setText(" "+PerfmonPlugin.getString("OK")+" "); //$NON-NLS-1$
		okbutton.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

		refresh = new Button(buttonpanel,0);
		refresh.setText(PerfmonPlugin.getString("REFRESH")); //$NON-NLS-1$
		refresh.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));

		okbutton.addSelectionListener(this);
		refresh.addSelectionListener(this);
		get_children.addSelectionListener(this);
		start_tracing.addSelectionListener(this);
		
		tree.addMouseListener(this);
	}
	
	private void refreshTree() {
		EList models = trcagent.getDescriptor();
		
		for (int i = 0; i < models.size(); i++) {
			SDDescriptor descriptor = (SDDescriptor)models.get(i);
			addToTree(descriptor);
		}
	}
	
	private void rebuildTree() {
		tree.removeAll();
		
		EList models = trcagent.getDescriptor();
		
		for (int i = 0; i < models.size(); i++) {
			SDDescriptor descriptor = (SDDescriptor)models.get(i);
			addToTree(descriptor);
		}
	}
	
	private int findIndex(String name, TreeItem[] items) {
		if (name != null) {
			for (int i = 0; i < items.length; i++) {
				if (items[i] != null) {
					if (name.compareTo(items[i].getText()) < 0) {
						return i;
					}
				}
			}
		}
		return items.length;
	}
	
	private void addToTree(SDDescriptor descriptor) {
		TreeItem item = null;
		
		if (descriptor.getName() == null) return;
		
		item = (TreeItem)descriptor_to_item.get(descriptor);

		//if it's not there then add it
		if (item == null) {
			if (descriptor.getParent() == null) {
				int index = findIndex(descriptor.getName(),tree.getItems());
				item = new TreeItem(tree,0,index);
			} else {
				TreeItem parent = (TreeItem)descriptor_to_item.get(descriptor.getParent());
				int index = findIndex(descriptor.getName(),parent.getItems());
				item = new TreeItem(parent,0,index);
			}

			descriptor_to_item.put(descriptor,item);
			item_to_descriptor.put(item,descriptor);
		}
		
		//update its info
		if (descriptor.getDescription() == null) {
			item.setText(descriptor.getName());
		} else {
			item.setText(descriptor.getName()+" - "+descriptor.getDescription());
		}
		item.setImage(org.eclipse.hyades.statistical.ui.EditorPlugin.img.getImage(org.eclipse.hyades.statistical.ui.ImageManager.IMG_SMODEL_DESCRIPTOR));
		if (descriptor instanceof SDMemberDescriptor) {
			SDMemberDescriptor mem = (SDMemberDescriptor)descriptor;
			if (mem.getSnapshotObservation().size() > 0) {
				item.setImage(PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_START));
			}
		}
		
		//same for its children
		for (int i = 0; i < descriptor.getChildren().size(); i++) {
			SDDescriptor child = (SDDescriptor)descriptor.getChildren().get(i);
			addToTree(child);
		}
	}
	
	///////////////////////////////////////
	// Selection listener
	///////////////////////////////////////
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	} 
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == refresh) {
			refreshTree();
		} else if (o == okbutton) {
			thisshell.close();
		} else if (o == get_children) {
			try {
				command.getUpdatedTree(selected_descriptor);
			} catch (Exception x) {
				PerfmonPlugin.DBG.logVisibleError(x,PerfmonPlugin.getString("ERROR_UPDATE_TREE"),false);
			}
		} else if (o == start_tracing) {
			try {
				command.startTracing(selected_descriptor);
			} catch (Exception x) {
				PerfmonPlugin.DBG.logVisibleError(x,PerfmonPlugin.getString("ERROR_ISSUE_COMMAND"),false);
			}
		}
	}

	//////////////////////////////
	// tree popup listener (MouseListener)
	//////////////////////////////

	SDDescriptor selected_descriptor;

	public void mouseDoubleClick(MouseEvent e) {}
	public void mouseDown(MouseEvent e) {}
	public void mouseUp(MouseEvent e) {
		Point pt = new Point(e.x,e.y);
		TreeItem item = tree.getItem(pt);

		if (item != null) {
			selected_descriptor = (SDDescriptor)item_to_descriptor.get(item);
			
			if (selected_descriptor != null) {

				//right mouse button click
				if (e.button > 1) {
					tree_menu.setVisible(true);
				}
			}
		}		
	}	
	
	
	/////////////////////////////////
	// thing to listen for new descriptors etc
	/////////////////////////////////
	class ModelListener extends AdapterImpl implements Runnable {
		public void notifyChanged(Notification notification) {
//			PerfmonPlugin.DBG.info("NOTIFICATION RECEIVED "+notification);
			if(notification.getEventType() == Notification.ADD) {
				Object newValue = notification.getNewValue();

				boolean notify = false;
//				SDDescriptor parent = null;

				if (newValue instanceof SDDescriptor) {
					notify = true;
//					parent = ((SDDescriptor)newValue).getParent();
				} else if (newValue instanceof SDSnapshotObservation) {
					notify = true;
//					parent = ((SDSnapshotObservation)newValue).getMemberDescriptor();
				}				
				
				if (notify) {
					Display display = Display.getCurrent();
					if (display == null) {
						display = Display.getDefault();
					}
					if (display == null) {
						thisshell.getDisplay().syncExec(ModelListener.this);
					} else {
						display.syncExec(ModelListener.this);
					}
				}
			}
		}	
		
		public void run() {
			try {
				refreshTree();
			} catch (NullPointerException e) {
				e.printStackTrace();
			} catch (SWTException e) {
			}
		}
	}
}