/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.PropertyTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
public class PropertySection extends Composite implements IDetails, ModifyListener, INotifyChangedListener {
	protected Text nameText;
	protected Text valueText;
	protected boolean isDisplaying;
	protected PropertyType currentSelection;
	protected PropertyTypeItemProvider itemProvider;
	protected UnitItemProviderAdapterFactory itemFactory;
	public PropertySection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
		super(composite, style);
		itemFactory = new UnitItemProviderAdapterFactory();
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PNAME"), SWT.NONE);
		nameText = factory.createText(this, "", SWT.NULL);
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PVALUE"), SWT.NONE);
		valueText = factory.createText(this, "", SWT.NULL);
		valueText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		valueText.addModifyListener(this);
		nameText.addModifyListener(this);
		itemProvider = (PropertyTypeItemProvider) itemFactory.createPropertyTypeAdapter();
		itemProvider.addListener(this);
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
		if (object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType) object.eContainer().eContainer());
		if (currentSelection == object)
			return;
		if (valueText.isFocusControl() || nameText.isFocusControl())
			return;
		currentSelection = (PropertyType) object;
		isDisplaying = true;
		valueText.setText(currentSelection.getPropertyValue() == null ? "" : currentSelection.getPropertyValue());
		nameText.setText(currentSelection.getPropertyName() == null ? "" : currentSelection.getPropertyName());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {
		this.currentSelection = (PropertyType) currentSelection;
		this.currentSelection.setPropertyName(nameText.getText());
		this.currentSelection.setPropertyValue(valueText.getText());
		return false;
	}
	public void setFocusToText() {
		nameText.setFocus();
		nameText.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (isDisplaying || currentSelection == null)
			return;
		if (e.getSource() == valueText) {
			String text = valueText.getText();
			if (!text.equals(currentSelection.getPropertyValue())) {
				if (text.length() == 0 && currentSelection.getPropertyValue() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, PropertyTypeItemProvider.VALUE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == nameText) {
			String text = nameText.getText();
			if (!text.equals(currentSelection.getPropertyName())) {
				if (text.length() == 0 && currentSelection.getPropertyName() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, PropertyTypeItemProvider.NAME);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
	}
	/**
	 */
	public void notifyChanged(Notification notification) {
		Object obj = notification.getNotifier();
		if (obj == null || (obj != currentSelection))
			return;
		display(currentSelection);
	}
}
