/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * @author psun
 *
 */
public class StringValueClass implements IDisplayValueClass {

	public String getPropertyDescription(Object theObject)
	{
		if(theObject instanceof String)
			return (String)theObject;
		
		String returnString = null;
		if(theObject != null)
			returnString = theObject.toString();
		else
			returnString = "null"; //$NON-NLS-1$
		return returnString;
	}
	
	public Object getPropertyDisplay(Object theObject, Composite parent, boolean editable)
	{
		if(editable && theObject != null)
		{
			TextCellEditor cellEditor = new TextCellEditor(parent);
			cellEditor.setValue(theObject.toString());
			return cellEditor;
		}
		else
		{
			Label label = new Label(parent, SWT.NONE);
			label.setText(getPropertyDescription(theObject));
			return label;
		}
	}
	
	public Object getValueDisplay(Object theObject, Composite parent, boolean editable)
	{
		return null;
	}	
	
	
	public Object getUpdatedObject(Object theObject, Object display)
	{
		String input = (String)((TextCellEditor)display).getValue();
		
		if(theObject == null && (input == null || input.length() == 0))
			return theObject;			
			
		return input;
	}
}
