/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

/** @author jgout */

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IExecutableExtension;

/**
 * @author jgout
 */
public interface IHyadesTestNavigatorConverter extends IExecutableExtension {
	
	/** Conversion method between a file and an object to be displayed in the test navigator.<br>
	 * This method should be implemented by extender plugin of <code>org.eclipse.hyades.test.ui.testnavigatorFile</code>
	 * @param file the file plug-in wants to add to the navigator
	 * @return the memory object displayed in the navigator corresponding to the file. 
	 */
	public Object getObjectFromResource(IResource file);

}
